/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.projecteditor.backend.server;

import java.util.stream.Collectors;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.ModuleRepositories;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.ProjectImports;
import org.guvnor.common.services.project.service.ModuleRepositoriesService;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.kie.workbench.common.screens.projecteditor.model.GitUrl;
import org.kie.workbench.common.screens.projecteditor.model.ProjectScreenModel;
import org.kie.workbench.common.services.shared.allowlist.AllowList;
import org.kie.workbench.common.services.shared.allowlist.PackageNameAllowListService;
import org.kie.workbench.common.services.shared.kmodule.KModuleModel;
import org.kie.workbench.common.services.shared.kmodule.KModuleService;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.kie.workbench.common.services.shared.project.ProjectImportsService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;

public class ProjectScreenModelLoader {
    private KieModuleService moduleService;
    private POMService pomService;
    private MetadataService metadataService;
    private KModuleService kModuleService;
    private ProjectImportsService importsService;
    private ModuleRepositoriesService repositoriesService;
    private PackageNameAllowListService allowListService;
    private WorkspaceProjectService workspaceProjectService;

    public ProjectScreenModelLoader() {
    }

    @Inject
    public ProjectScreenModelLoader(KieModuleService moduleService, POMService pomService, MetadataService metadataService, KModuleService kModuleService, ProjectImportsService importsService, ModuleRepositoriesService repositoriesService, PackageNameAllowListService allowListService, WorkspaceProjectService workspaceProjectService) {
        this.moduleService = moduleService;
        this.pomService = pomService;
        this.metadataService = metadataService;
        this.kModuleService = kModuleService;
        this.importsService = importsService;
        this.repositoriesService = repositoriesService;
        this.allowListService = allowListService;
        this.workspaceProjectService = workspaceProjectService;
    }

    public ProjectScreenModel load(org.uberfire.backend.vfs.Path pathToPom) {
        return new Loader(pathToPom).load();
    }

    protected boolean fileExists(org.uberfire.backend.vfs.Path path) {
        return Files.exists((Path)Paths.convert((org.uberfire.backend.vfs.Path)path), (LinkOption[])new LinkOption[0]);
    }

    class Loader {
        private final ProjectScreenModel model = new ProjectScreenModel();
        private final org.uberfire.backend.vfs.Path pathToPom;
        private final KieModule project;

        public Loader(org.uberfire.backend.vfs.Path pathToPom) {
            this.pathToPom = pathToPom;
            this.project = (KieModule)ProjectScreenModelLoader.this.moduleService.resolveModule(pathToPom);
        }

        public ProjectScreenModel load() {
            this.loadPOM();
            this.loadKModule();
            this.loadGitURLs();
            this.loadImports();
            this.loadAllowList();
            this.loadRepositories();
            return this.model;
        }

        private void loadPOM() {
            this.model.setPOM((POM)ProjectScreenModelLoader.this.pomService.load(this.pathToPom));
            this.model.setPOMMetaData(this.getMetadata(this.pathToPom));
            this.model.setPathToPOM(this.pathToPom);
        }

        private void loadKModule() {
            this.model.setKModule((KModuleModel)ProjectScreenModelLoader.this.kModuleService.load(this.project.getKModuleXMLPath()));
            this.model.setKModuleMetaData(this.getMetadata(this.project.getKModuleXMLPath()));
            this.model.setPathToKModule(this.project.getKModuleXMLPath());
        }

        private void loadGitURLs() {
            this.model.setGitUrls(ProjectScreenModelLoader.this.workspaceProjectService.resolveProject(this.project.getPomXMLPath()).getRepository().getPublicURIs().stream().map(uri -> new GitUrl(uri.getProtocol(), uri.getURI())).collect(Collectors.toList()));
        }

        private void loadImports() {
            this.model.setProjectImports((ProjectImports)ProjectScreenModelLoader.this.importsService.load(this.project.getImportsPath()));
            this.model.setProjectImportsMetaData(this.getMetadata(this.project.getImportsPath()));
            this.model.setPathToImports(this.project.getImportsPath());
        }

        private void loadRepositories() {
            this.model.setRepositories((ModuleRepositories)ProjectScreenModelLoader.this.repositoriesService.load(this.project.getRepositoriesPath()));
            this.model.setPathToRepositories(this.project.getRepositoriesPath());
        }

        private void loadAllowList() {
            this.model.setAllowList((AllowList)ProjectScreenModelLoader.this.allowListService.load(this.project.getPackageNamesAllowListPath()));
            this.model.setAllowListMetaData(this.getMetadata(this.project.getPackageNamesAllowListPath()));
            this.model.setPathToAllowList(this.project.getPackageNamesAllowListPath());
        }

        private Metadata getMetadata(org.uberfire.backend.vfs.Path path) {
            if (ProjectScreenModelLoader.this.fileExists(path)) {
                return ProjectScreenModelLoader.this.metadataService.getMetadata(path);
            }
            return new Metadata();
        }
    }
}

