/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.definition.adapter.binding;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class DefinitionAdapterBindings {
    private Class<?> baseType = Object.class;
    private Class<?> graphFactory;
    private String idField;
    private String labelsField;
    private String titleField;
    private String categoryField;
    private String descriptionField;
    private List<String> propertiesFieldNames;
    private List<Boolean> typedPropertyFields;
    private PropertyMetaTypes metaTypes;

    public PropertyMetaTypes getMetaTypes() {
        return this.metaTypes;
    }

    public DefinitionAdapterBindings setMetaTypes(PropertyMetaTypes metaTypes) {
        this.metaTypes = metaTypes;
        return this;
    }

    public Class<?> getBaseType() {
        return this.baseType;
    }

    public DefinitionAdapterBindings setBaseType(Class<?> baseType) {
        this.baseType = baseType;
        return this;
    }

    public Class<?> getGraphFactory() {
        return this.graphFactory;
    }

    public DefinitionAdapterBindings setGraphFactory(Class<?> graphFactory) {
        this.graphFactory = graphFactory;
        return this;
    }

    public String getIdField() {
        return this.idField;
    }

    public DefinitionAdapterBindings setIdField(String idField) {
        this.idField = idField;
        return this;
    }

    public String getLabelsField() {
        return this.labelsField;
    }

    public DefinitionAdapterBindings setLabelsField(String labelsField) {
        this.labelsField = labelsField;
        return this;
    }

    public String getTitleField() {
        return this.titleField;
    }

    public DefinitionAdapterBindings setTitleField(String titleField) {
        this.titleField = titleField;
        return this;
    }

    public String getCategoryField() {
        return this.categoryField;
    }

    public DefinitionAdapterBindings setCategoryField(String categoryField) {
        this.categoryField = categoryField;
        return this;
    }

    public String getDescriptionField() {
        return this.descriptionField;
    }

    public DefinitionAdapterBindings setDescriptionField(String descriptionField) {
        this.descriptionField = descriptionField;
        return this;
    }

    public List<String> getPropertiesFieldNames() {
        return this.propertiesFieldNames;
    }

    public DefinitionAdapterBindings setPropertiesFieldNames(List<String> propertiesFieldNames) {
        this.propertiesFieldNames = propertiesFieldNames;
        return this;
    }

    public List<Boolean> getTypedPropertyFields() {
        return this.typedPropertyFields;
    }

    public DefinitionAdapterBindings setTypedPropertyFields(List<Boolean> typedPropertyFields) {
        this.typedPropertyFields = typedPropertyFields;
        return this;
    }

    public static class PropertyMetaTypes {
        private static final int NAME = 0;
        private static final int WIDTH = 1;
        private static final int HEIGHT = 2;
        private static final int RADIUS = 3;
        private static final int ID = 4;
        private final int[] metaTypeFieldIndexes = new int[]{-1, -1, -1, -1, -1};

        public static PropertyMetaTypes parse(String s) {
            String[] values = s.trim().split(",");
            return new PropertyMetaTypes().parse(values);
        }

        public static String format(PropertyMetaTypes dpmt) {
            return Arrays.stream(dpmt.metaTypeFieldIndexes).mapToObj(Integer::toString).collect(Collectors.joining(","));
        }

        public String format() {
            return PropertyMetaTypes.format(this);
        }

        PropertyMetaTypes parse(String[] values) {
            this.metaTypeFieldIndexes[0] = Integer.parseInt(values[0]);
            this.metaTypeFieldIndexes[1] = Integer.parseInt(values[1]);
            this.metaTypeFieldIndexes[2] = Integer.parseInt(values[2]);
            this.metaTypeFieldIndexes[3] = Integer.parseInt(values[3]);
            this.metaTypeFieldIndexes[4] = Integer.parseInt(values[4]);
            return this;
        }

        public void setIndex(org.kie.workbench.common.stunner.core.definition.property.PropertyMetaTypes type, int index) {
            switch (type) {
                case NAME: {
                    this.setNameIndex(index);
                    break;
                }
                case WIDTH: {
                    this.setWidthIndex(index);
                    break;
                }
                case HEIGHT: {
                    this.setHeightIndex(index);
                    break;
                }
                case RADIUS: {
                    this.setRadiusIndex(index);
                    break;
                }
                case ID: {
                    this.setIdIndex(index);
                }
            }
        }

        public int getIndex(org.kie.workbench.common.stunner.core.definition.property.PropertyMetaTypes type) {
            switch (type) {
                case NAME: {
                    return this.getNameIndex();
                }
                case WIDTH: {
                    return this.getWidthIndex();
                }
                case HEIGHT: {
                    return this.getHeightIndex();
                }
                case RADIUS: {
                    return this.getRadiusIndex();
                }
                case ID: {
                    return this.getIdIndex();
                }
            }
            return -1;
        }

        public void setNameIndex(int index) {
            this.metaTypeFieldIndexes[0] = index;
        }

        public void setWidthIndex(int index) {
            this.metaTypeFieldIndexes[1] = index;
        }

        public void setHeightIndex(int index) {
            this.metaTypeFieldIndexes[2] = index;
        }

        public void setRadiusIndex(int index) {
            this.metaTypeFieldIndexes[3] = index;
        }

        public void setIdIndex(int index) {
            this.metaTypeFieldIndexes[4] = index;
        }

        public int getNameIndex() {
            return this.metaTypeFieldIndexes[0];
        }

        public int getWidthIndex() {
            return this.metaTypeFieldIndexes[1];
        }

        public int getHeightIndex() {
            return this.metaTypeFieldIndexes[2];
        }

        public int getRadiusIndex() {
            return this.metaTypeFieldIndexes[3];
        }

        public int getIdIndex() {
            return this.metaTypeFieldIndexes[4];
        }
    }
}

