/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.definition.service;

import java.io.IOException;
import java.io.InputStream;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMetadataMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingMessage;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingRequest;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingResponse;
import org.kie.workbench.common.stunner.core.validation.Violation;

public interface DiagramMarshaller<G extends Graph, M extends Metadata, D extends Diagram<G, M>> {
    public G unmarshall(M var1, InputStream var2) throws IOException;

    default public MarshallingResponse<G> unmarshallWithValidation(MarshallingRequest<InputStream, M> request) {
        try {
            G result = this.unmarshall(request.getMetadata(), request.getInput());
            return MarshallingResponse.builder().result(result).state(MarshallingResponse.State.SUCCESS).build();
        }
        catch (Exception e) {
            String message = e.getMessage();
            return MarshallingResponse.builder().state(MarshallingResponse.State.ERROR).addMessage(MarshallingMessage.builder().type(Violation.Type.ERROR).message(message).build()).build();
        }
    }

    public String marshall(D var1) throws IOException;

    public DiagramMetadataMarshaller<M> getMetadataMarshaller();
}

