/*
 * Decompiled with CFR 0.152.
 */
package protostream.com.squareup.protoparser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import protostream.com.squareup.protoparser.AutoValue_EnumElement;
import protostream.com.squareup.protoparser.EnumConstantElement;
import protostream.com.squareup.protoparser.OptionElement;
import protostream.com.squareup.protoparser.TypeElement;
import protostream.com.squareup.protoparser.Utils;

public abstract class EnumElement
implements TypeElement {
    private static void validateTagUniqueness(String qualifiedName, List<EnumConstantElement> constants) {
        Utils.checkNotNull(qualifiedName, "qualifiedName");
        LinkedHashSet<Integer> tags = new LinkedHashSet<Integer>();
        for (EnumConstantElement constant : constants) {
            int tag = constant.tag();
            if (tags.add(tag)) continue;
            throw new IllegalStateException("Duplicate tag " + tag + " in " + qualifiedName);
        }
    }

    private static boolean parseAllowAlias(List<OptionElement> options) {
        OptionElement option = OptionElement.findByName(options, "allow_alias");
        return option != null && "true".equals(option.value());
    }

    static void validateValueUniquenessInScope(String qualifiedName, List<TypeElement> nestedElements) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (TypeElement nestedElement : nestedElements) {
            if (!(nestedElement instanceof EnumElement)) continue;
            EnumElement enumElement = (EnumElement)nestedElement;
            for (EnumConstantElement constant : enumElement.constants()) {
                String name = constant.name();
                if (names.add(name)) continue;
                throw new IllegalStateException("Duplicate enum constant " + name + " in scope " + qualifiedName);
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    EnumElement() {
    }

    @Override
    public abstract String name();

    @Override
    public abstract String qualifiedName();

    @Override
    public abstract String documentation();

    public abstract List<EnumConstantElement> constants();

    @Override
    public abstract List<OptionElement> options();

    @Override
    public final List<TypeElement> nestedElements() {
        return Collections.emptyList();
    }

    @Override
    public final String toSchema() {
        StringBuilder builder = new StringBuilder();
        Utils.appendDocumentation(builder, this.documentation());
        builder.append("enum ").append(this.name()).append(" {");
        if (!this.options().isEmpty()) {
            builder.append('\n');
            for (OptionElement option : this.options()) {
                Utils.appendIndented(builder, option.toSchemaDeclaration());
            }
        }
        if (!this.constants().isEmpty()) {
            builder.append('\n');
            for (EnumConstantElement constant : this.constants()) {
                Utils.appendIndented(builder, constant.toSchema());
            }
        }
        return builder.append("}\n").toString();
    }

    public static final class Builder {
        private String name;
        private String qualifiedName;
        private String documentation = "";
        private final List<EnumConstantElement> constants = new ArrayList<EnumConstantElement>();
        private final List<OptionElement> options = new ArrayList<OptionElement>();

        private Builder() {
        }

        public Builder name(String name) {
            this.name = Utils.checkNotNull(name, "name");
            if (this.qualifiedName == null) {
                this.qualifiedName = name;
            }
            return this;
        }

        public Builder qualifiedName(String qualifiedName) {
            this.qualifiedName = Utils.checkNotNull(qualifiedName, "qualifiedName");
            return this;
        }

        public Builder documentation(String documentation) {
            this.documentation = Utils.checkNotNull(documentation, "documentation");
            return this;
        }

        public Builder addConstant(EnumConstantElement constant) {
            this.constants.add(Utils.checkNotNull(constant, "constant"));
            return this;
        }

        public Builder addConstants(Collection<EnumConstantElement> constants) {
            for (EnumConstantElement constant : Utils.checkNotNull(constants, "constants")) {
                this.addConstant(constant);
            }
            return this;
        }

        public Builder addOption(OptionElement option) {
            this.options.add(Utils.checkNotNull(option, "option"));
            return this;
        }

        public Builder addOptions(Collection<OptionElement> options) {
            for (OptionElement option : Utils.checkNotNull(options, "options")) {
                this.addOption(option);
            }
            return this;
        }

        public EnumElement build() {
            Utils.checkNotNull(this.name, "name");
            Utils.checkNotNull(this.qualifiedName, "qualifiedName");
            if (!EnumElement.parseAllowAlias(this.options)) {
                EnumElement.validateTagUniqueness(this.qualifiedName, this.constants);
            }
            return new AutoValue_EnumElement(this.name, this.qualifiedName, this.documentation, Utils.immutableCopyOf(this.constants), Utils.immutableCopyOf(this.options));
        }
    }
}

