/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.ethereum;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.ethereum.EthereumAuth;
import org.jbpm.process.workitem.ethereum.EthereumUtils;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.abi.TypeReference;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.http.HttpService;

@Wid(widfile="EthereumQueryExistingContract.wid", name="EthereumQueryExistingContract", displayName="EthereumQueryExistingContract", defaultHandler="mvel: new org.jbpm.process.workitem.ethereum.QueryExistingContractWorkitemHandler(\"walletPassword\", \"walletPath\")", documentation="ethereum-workitem/index.html", category="ethereum-workitem", icon="EthereumQueryExistingContract.png", parameters={@WidParameter(name="ServiceURL", required=true), @WidParameter(name="ContractAddress", required=true), @WidParameter(name="ContractMethodName", required=true), @WidParameter(name="MethodOutputType")}, results={@WidResult(name="Result", runtimeType="java.lang.Object")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="ethereum-workitem", version="7.70.0.Final")}, serviceInfo=@WidService(category="Ethereum", description="Integrate with the Ethereum Blockchain app platform", keywords="Ethereum,blockchain,smart,contract,smartcontract,query", action=@WidAction(title="Query an existing contract deployed on the blockchain"), authinfo=@WidAuth(required=true, params={"walletPassword", "walletPath"}, paramsdescription={"Wallet password", "Path to the wallet file"})))
public class QueryExistingContractWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private String walletPassword;
    private String walletPath;
    private EthereumAuth auth;
    private Web3j web3j;
    private ClassLoader classLoader;
    private static final String RESULTS = "Result";
    private static final Logger logger = LoggerFactory.getLogger(QueryExistingContractWorkitemHandler.class);

    public QueryExistingContractWorkitemHandler(String walletPassword, String walletPath) {
        this(walletPassword, walletPath, null);
    }

    public QueryExistingContractWorkitemHandler(String walletPassword, String walletPath, ClassLoader classLoader) {
        this.walletPassword = walletPassword;
        this.walletPath = walletPath;
        this.classLoader = classLoader == null ? ((Object)((Object)this)).getClass().getClassLoader() : classLoader;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            String serviceURL = (String)workItem.getParameter("ServiceURL");
            String contractAddress = (String)workItem.getParameter("ContractAddress");
            String contractMethodName = (String)workItem.getParameter("ContractMethodName");
            String contractMethodOutputType = (String)workItem.getParameter("MethodOutputType");
            HashMap<String, Object> results = new HashMap<String, Object>();
            if (this.web3j == null) {
                this.web3j = Web3j.build((Web3jService)new HttpService(serviceURL));
            }
            this.auth = new EthereumAuth(this.walletPassword, this.walletPath, this.classLoader);
            Credentials credentials = this.auth.getCredentials();
            List<TypeReference<?>> outputTypeList = null;
            if (contractMethodOutputType != null) {
                Class<?> typeClazz = Class.forName(contractMethodOutputType);
                outputTypeList = Collections.singletonList(TypeReference.create(typeClazz));
            }
            Object queryReturnObj = EthereumUtils.queryExistingContract(credentials, this.web3j, contractAddress, contractMethodName, null, outputTypeList);
            results.put(RESULTS, queryReturnObj);
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            logger.error("Error executing workitem: " + e.getMessage());
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setWeb3j(Web3j web3j) {
        this.web3j = web3j;
    }
}

