/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.project.backend.forms.conditions.parser;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.workbench.common.services.datamodeller.util.StringEscapeUtils;
import org.kie.workbench.common.stunner.bpmn.forms.conditions.Condition;
import org.kie.workbench.common.stunner.bpmn.forms.conditions.FunctionDef;
import org.kie.workbench.common.stunner.bpmn.forms.conditions.ParamDef;
import org.kie.workbench.common.stunner.bpmn.project.backend.forms.conditions.parser.FunctionsRegistry;
import org.kie.workbench.common.stunner.bpmn.project.backend.forms.conditions.parser.ParsingUtils;

public class ConditionParser {
    public static final String KIE_FUNCTIONS = "KieFunctions.";
    private int parseIndex;
    private String expression;
    private String functionName;
    private static final String FUNCTION_NAME_NOT_RECOGNIZED_ERROR = "The function name \"{0}\" is not recognized by system.";
    private static final String FUNCTION_CALL_NOT_FOUND_ERROR = "Function call was not found, a token like \"KieFunctions.functionName(variable, params)\" is expected.";
    private static final String VALID_FUNCTION_CALL_NOT_FOUND_ERROR = "The \"KieFunctions.\" keyword must be followed by one of the following function names: \"{0}\"";
    private static final String CONDITION_OUT_OF_BOUNDS_ERROR = "Out of bounds error, the condition has missing parameters or is not properly configured.";
    private static final String FUNCTION_CALL_NOT_CLOSED_PROPERLY_ERROR = "Function call \"{0}\" is not closed properly, character \")\" is expected.";
    private static final String FUNCTION_CALL_NOT_OPEN_PROPERLY_ERROR = "Function call \"{0}\" is not opened properly, character \"(\" is expected.";
    private static final String SENTENCE_NOT_CLOSED_PROPERLY_ERROR = "Condition not closed properly, character \";\" is expected.";
    private static final String FIELD_NAME_EXPECTED_ERROR = "A valid field name is expected.";
    private static final String PARAMETER_DELIMITER_EXPECTED_ERROR = "Parameter delimiter \",\" is expected.";
    private static final String STRING_PARAMETER_EXPECTED_ERROR = "String parameter value like \"some value\" is expected.";
    private static final String SENTENCE_EXPECTED_AT_POSITION_ERROR = "Sentence \"{0}\" is expected at position {1}.";
    private static final String BLANK_AFTER_RETURN_EXPECTED_ERROR = "Sentence \"{0}\" must be followed by a blank space or a line break.";
    private static final String METHOD_INVOCATION_EXPECTED_ERROR = "A method invocation is expected at position {0}.";
    private static final String METHOD_NOT_PROPERLY_OPENED_ERROR = "Method \"{0}\" invocation is not properly opened, character \"(\" is expected.";
    private static final String METHOD_NOT_PROPERLY_CLOSED_ERROR = "Method \"{0}\" invocation is not properly closed, character \")\" is expected.";
    private static String functionNames = ConditionParser.buildFunctionNames();
    private static final String RETURN_SENTENCE = "return";

    public ConditionParser(String expression) {
        this.expression = expression;
        this.parseIndex = expression != null ? 0 : -1;
    }

    public Condition parse() throws ParseException {
        this.parseReturnSentence();
        this.functionName = this.parseFunctionName();
        this.functionName = this.functionName.substring(KIE_FUNCTIONS.length());
        List<FunctionDef> functionDefs = FunctionsRegistry.getInstance().getFunctions(this.functionName);
        if (functionDefs.isEmpty()) {
            throw new ParseException(this.errorMessage(FUNCTION_NAME_NOT_RECOGNIZED_ERROR, this.functionName), this.parseIndex);
        }
        ParseException lastTryException = null;
        for (FunctionDef functionDef : functionDefs) {
            try {
                this.reset();
                return this.parse(functionDef);
            }
            catch (ParseException e) {
                lastTryException = e;
            }
        }
        throw lastTryException;
    }

    private Condition parse(FunctionDef functionDef) throws ParseException {
        this.parseReturnSentence();
        this.functionName = this.parseFunctionName();
        this.functionName = this.functionName.substring(KIE_FUNCTIONS.length());
        this.parseFunctionOpen();
        Condition condition = new Condition(this.functionName);
        boolean first = true;
        for (ParamDef ignored : functionDef.getParams()) {
            String param;
            if (first) {
                String[] variableParam = this.parseVariableParam();
                param = variableParam[0] + (variableParam[1] != null ? "." + variableParam[1] : "");
                first = false;
            } else {
                this.parseParamDelimiter();
                param = this.parseStringParameter();
            }
            condition.addParam(param);
        }
        this.parseFunctionClose();
        this.parseSentenceClose();
        return condition;
    }

    private void reset() {
        this.parseIndex = 0;
        this.functionName = null;
    }

    private void parseReturnSentence() throws ParseException {
        int index = this.nextNonBlank();
        if (index < 0 || !this.expression.startsWith(RETURN_SENTENCE, index)) {
            throw new ParseException(this.errorMessage(SENTENCE_EXPECTED_AT_POSITION_ERROR, RETURN_SENTENCE, this.parseIndex), this.parseIndex);
        }
        this.setParseIndex(index + RETURN_SENTENCE.length());
        if (this.isNoneBlank(Character.valueOf(this.expression.charAt(this.parseIndex)))) {
            throw new ParseException(this.errorMessage(BLANK_AFTER_RETURN_EXPECTED_ERROR, RETURN_SENTENCE), this.parseIndex);
        }
    }

    private String parseFunctionName() throws ParseException {
        int index = this.nextNonBlank();
        if (index < 0 || !this.expression.startsWith(KIE_FUNCTIONS, index)) {
            throw new ParseException(this.errorMessage(FUNCTION_CALL_NOT_FOUND_ERROR, new Object[0]), this.parseIndex);
        }
        for (FunctionDef functionDef : FunctionsRegistry.getInstance().getFunctions()) {
            if (!this.expression.startsWith(KIE_FUNCTIONS + functionDef.getName(), index)) continue;
            this.functionName = KIE_FUNCTIONS + functionDef.getName();
            break;
        }
        if (this.functionName == null) {
            throw new ParseException(this.errorMessage(VALID_FUNCTION_CALL_NOT_FOUND_ERROR, this.functionNames()), this.parseIndex);
        }
        this.setParseIndex(index + this.functionName.length());
        return this.functionName;
    }

    private String parseFunctionOpen() throws ParseException {
        int index = this.nextNonBlank();
        if (index < 0 || this.expression.charAt(index) != '(') {
            throw new ParseException(this.errorMessage(FUNCTION_CALL_NOT_OPEN_PROPERLY_ERROR, this.functionName), this.parseIndex);
        }
        this.setParseIndex(index + 1);
        return "(";
    }

    private void parseFunctionClose() throws ParseException {
        int index = this.nextNonBlank();
        if (index < 0 || this.expression.charAt(index) != ')') {
            throw new ParseException(this.errorMessage(FUNCTION_CALL_NOT_CLOSED_PROPERLY_ERROR, this.functionName), this.parseIndex);
        }
        this.setParseIndex(index + 1);
    }

    private void parseSentenceClose() throws ParseException {
        int index = this.nextNonBlank();
        if (index < 0 || this.expression.charAt(index) != ';') {
            throw new ParseException(this.errorMessage(SENTENCE_NOT_CLOSED_PROPERLY_ERROR, new Object[0]), this.parseIndex);
        }
        this.parseIndex = index + 1;
        while (this.parseIndex < this.expression.length()) {
            if (this.isNoneBlank(Character.valueOf(this.expression.charAt(this.parseIndex)))) {
                throw new ParseException(this.errorMessage(SENTENCE_NOT_CLOSED_PROPERLY_ERROR, new Object[0]), this.parseIndex);
            }
            ++this.parseIndex;
        }
    }

    private String[] parseVariableParam() throws ParseException {
        String[] result = new String[2];
        String variableName = this.parseVariableName();
        String methodName = null;
        int index = this.nextNonBlank();
        if (index < 0) {
            throw new ParseException(this.errorMessage(FUNCTION_CALL_NOT_CLOSED_PROPERLY_ERROR, new Object[0]), this.parseIndex);
        }
        if (this.expression.charAt(index) == '.') {
            this.setParseIndex(index + 1);
            methodName = this.parseMethodName();
        }
        result[0] = variableName;
        result[1] = methodName;
        return result;
    }

    private String parseVariableName() throws ParseException {
        int index = this.nextNonBlank();
        if (index < 0) {
            throw new ParseException(this.errorMessage(FIELD_NAME_EXPECTED_ERROR, new Object[0]), this.parseIndex);
        }
        String result = ParsingUtils.parseJavaName(this.expression, index, new char[]{' ', '.', ',', ')', '\r', '\n', '\t'});
        this.setParseIndex(index + result.length());
        return result;
    }

    private String parseMethodName() throws ParseException {
        int index = this.nextNonBlank();
        if (index < 0) {
            throw new ParseException(this.errorMessage(METHOD_INVOCATION_EXPECTED_ERROR, this.parseIndex), this.parseIndex);
        }
        String result = ParsingUtils.parseJavaName(this.expression, index, new char[]{' ', '\r', '\n', '\t', '('});
        this.setParseIndex(index + result.length());
        index = this.nextNonBlank();
        if (index < 0 || this.expression.charAt(index) != '(') {
            throw new ParseException(this.errorMessage(METHOD_NOT_PROPERLY_OPENED_ERROR, result), index);
        }
        this.setParseIndex(index + 1);
        index = this.nextNonBlank();
        if (index < 0 || this.expression.charAt(index) != ')') {
            throw new ParseException(this.errorMessage(METHOD_NOT_PROPERLY_CLOSED_ERROR, result), index);
        }
        this.setParseIndex(index + 1);
        return result + "()";
    }

    private void parseParamDelimiter() throws ParseException {
        int index = this.nextNonBlank();
        if (index < 0 || this.expression.charAt(index) != ',') {
            throw new ParseException(this.errorMessage(PARAMETER_DELIMITER_EXPECTED_ERROR, new Object[0]), this.parseIndex);
        }
        this.setParseIndex(index + 1);
    }

    private String parseStringParameter() throws ParseException {
        int index = this.nextNonBlank();
        if (index < 0 || this.expression.charAt(index) != '\"') {
            throw new ParseException(STRING_PARAMETER_EXPECTED_ERROR, this.parseIndex);
        }
        Character scapeChar = Character.valueOf('\\');
        Character last = null;
        boolean strReaded = false;
        StringBuilder param = new StringBuilder();
        for (int i = index + 1; i < this.expression.length(); ++i) {
            if (this.expression.charAt(i) == '\"' && !scapeChar.equals(last)) {
                strReaded = true;
                break;
            }
            param.append(this.expression.charAt(i));
            last = Character.valueOf(this.expression.charAt(i));
        }
        if (!strReaded) {
            throw new ParseException(STRING_PARAMETER_EXPECTED_ERROR, this.parseIndex);
        }
        this.setParseIndex(index + param.length() + 2);
        return StringEscapeUtils.unescapeJava((String)param.toString());
    }

    private int nextNonBlank() {
        if (this.parseIndex < 0) {
            return -1;
        }
        for (int i = this.parseIndex; i < this.expression.length(); ++i) {
            if (!this.isNoneBlank(Character.valueOf(this.expression.charAt(i)))) continue;
            return i;
        }
        return -1;
    }

    private boolean isNoneBlank(Character character) {
        return character != null && !Character.isWhitespace(character.charValue());
    }

    private String errorMessage(String message, Object ... params) {
        return MessageFormat.format(message, params);
    }

    private void setParseIndex(int parseIndex) throws ParseException {
        if (parseIndex >= this.expression.length()) {
            throw new ParseException(this.errorMessage(CONDITION_OUT_OF_BOUNDS_ERROR, this.functionName), parseIndex);
        }
        this.parseIndex = parseIndex;
    }

    private String functionNames() {
        return functionNames;
    }

    private static String buildFunctionNames() {
        String functionNames = FunctionsRegistry.getInstance().getFunctions().stream().map(FunctionDef::getName).collect(Collectors.joining(", "));
        return "{" + functionNames + "}";
    }
}

