/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodel.backend.server;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.project.model.Package;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.soup.project.datamodel.commons.oracle.ModuleDataModelOracleImpl;
import org.kie.soup.project.datamodel.commons.oracle.PackageDataModelOracleImpl;
import org.kie.soup.project.datamodel.oracle.ModuleDataModelOracle;
import org.kie.soup.project.datamodel.oracle.PackageDataModelOracle;
import org.kie.workbench.common.services.datamodel.backend.server.cache.LRUDataModelOracleCache;
import org.kie.workbench.common.services.datamodel.backend.server.cache.LRUModuleDataModelOracleCache;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
public class DataModelServiceImpl
implements DataModelService {
    private LRUDataModelOracleCache cachePackages;
    private LRUModuleDataModelOracleCache cacheModules;
    private KieModuleService moduleService;

    @Inject
    public DataModelServiceImpl(@Named(value="PackageDataModelOracleCache") LRUDataModelOracleCache cachePackages, @Named(value="ModuleDataModelOracleCache") LRUModuleDataModelOracleCache cacheModules, KieModuleService moduleService) {
        this.cachePackages = cachePackages;
        this.cacheModules = cacheModules;
        this.moduleService = moduleService;
    }

    public PackageDataModelOracle getDataModel(Path resourcePath) {
        try {
            PortablePreconditions.checkNotNull((String)"resourcePath", (Object)resourcePath);
            KieModule module = this.resolveModule(resourcePath);
            Package pkg = this.resolvePackage(resourcePath);
            if (module == null) {
                return new PackageDataModelOracleImpl();
            }
            PackageDataModelOracle oracle = this.cachePackages.assertPackageDataModelOracle(module, pkg);
            return oracle;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public ModuleDataModelOracle getModuleDataModel(Path resourcePath) {
        try {
            PortablePreconditions.checkNotNull((String)"resourcePath", (Object)resourcePath);
            KieModule module = this.resolveModule(resourcePath);
            if (module == null) {
                return new ModuleDataModelOracleImpl();
            }
            ModuleDataModelOracle oracle = this.cacheModules.assertModuleDataModelOracle(module);
            return oracle;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private KieModule resolveModule(Path resourcePath) {
        return (KieModule)this.moduleService.resolveModule(resourcePath);
    }

    private Package resolvePackage(Path resourcePath) {
        return this.moduleService.resolvePackage(resourcePath);
    }
}

