/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server;

import java.io.IOException;
import java.io.PrintWriter;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.util.Utils;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.IDiagramProfileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(displayName="StencilPatterns", name="StencilPatternsServlet", urlPatterns={"/stencilpatterns"})
public class StencilPatternsServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger _logger = LoggerFactory.getLogger(StencilPatternsServlet.class);
    public static final String PATTERNS_NAME = "patterns";
    protected IDiagramProfile profile;
    @Inject
    private IDiagramProfileService _profileService = null;

    public void setProfile(IDiagramProfile profile) {
        this.profile = profile;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String profileName = Utils.getDefaultProfileName(req.getParameter("profile"));
        String uuid = Utils.getUUID(req);
        if (this.profile == null) {
            this.profile = this._profileService.findProfile(req, profileName);
        }
        String patternsJSON = this.getWorkflowPatternJSON(this.profile, uuid);
        PrintWriter pw = resp.getWriter();
        resp.setContentType("text/json");
        resp.setCharacterEncoding("UTF-8");
        pw.write(patternsJSON);
    }

    private String getWorkflowPatternJSON(IDiagramProfile profile, String uuid) {
        String retStr = "";
        Repository repository = profile.getRepository();
        try {
            Asset patternAsset = repository.loadAssetFromPath(profile.getRepositoryGlobalDir(uuid) + "/" + PATTERNS_NAME + ".json");
            retStr = (String)patternAsset.getAssetContent();
        }
        catch (Exception e) {
            _logger.error("Error retriving patterns info: " + e.getMessage());
        }
        return retStr;
    }
}

