/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.processing.index.bounds;

import java.util.List;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bound;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.processing.index.bounds.GraphBoundsIndexer;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.AbstractChildrenTraverseCallback;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.ChildrenTraverseProcessor;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;

@Dependent
public class GraphBoundsIndexerImpl
implements GraphBoundsIndexer {
    ChildrenTraverseProcessor childrenTraverseProcessor;
    private Graph<View, Node<View, Edge>> graph;
    private String rootUUID = null;

    @Inject
    public GraphBoundsIndexerImpl(ChildrenTraverseProcessor childrenTraverseProcessor) {
        this.childrenTraverseProcessor = childrenTraverseProcessor;
    }

    public GraphBoundsIndexerImpl build(Graph<View, Node<View, Edge>> graph) {
        this.graph = graph;
        return this;
    }

    public Node<View<?>, Edge> getAt(double x, double y) {
        return this.findElementAt(x, y);
    }

    public Node<View<?>, Edge> getAt(double x, double y, double width, double height, Element parentNode) {
        double xToCheck = 0.0;
        double yToCheck = 0.0;
        if (parentNode != null) {
            Point2D parentNodePosition = GraphUtils.getComputedPosition(parentNode.asNode());
            xToCheck = x + parentNodePosition.getX();
            yToCheck = y + parentNodePosition.getY();
        }
        Point2D[] pointsToCheck = new Point2D[]{new Point2D(xToCheck, yToCheck), new Point2D(xToCheck + width, yToCheck), new Point2D(xToCheck + width / 2.0, yToCheck + height / 2.0), new Point2D(xToCheck, yToCheck + height), new Point2D(xToCheck + width, yToCheck + height)};
        for (Point2D point : pointsToCheck) {
            Node<View<?>, Edge> element = this.findElementAt(point.getX(), point.getY());
            if (element == null || element == parentNode) continue;
            return element;
        }
        return null;
    }

    public double[] getTrimmedBounds() {
        final double[] result = new double[]{Double.MAX_VALUE, Double.MAX_VALUE, 0.0, 0.0};
        this.childrenTraverseProcessor.setRootUUID(this.rootUUID).traverse(this.graph, (Object)new GraphBoundIndexerTraverseCallback(new NodeBoundsTraverseCallback(){

            @Override
            public void onNodeTraverse(Node<View, Edge> node, double parentX, double parentY) {
                boolean isRoot;
                String uuid = node.getUUID();
                boolean bl = isRoot = null != GraphBoundsIndexerImpl.this.rootUUID && GraphBoundsIndexerImpl.this.rootUUID.equals(uuid);
                if (!isRoot) {
                    double[] absCoords = GraphBoundsIndexerImpl.this.getNodeAbsoluteCoordinates(node, parentX, parentY);
                    double x = absCoords[0];
                    double y = absCoords[1];
                    double w = absCoords[2];
                    double h = absCoords[3];
                    if (x < result[0]) {
                        result[0] = x;
                    }
                    if (y < result[1]) {
                        result[1] = y;
                    }
                    if (w > result[2]) {
                        result[2] = w;
                    }
                    if (h > result[3]) {
                        result[3] = h;
                    }
                }
            }
        }));
        return result;
    }

    public Node<View<?>, Edge> findElementAt(final double x, final double y) {
        final Node[] result = new Node[1];
        this.childrenTraverseProcessor.traverse(this.graph, (Object)new GraphBoundIndexerTraverseCallback(new NodeBoundsTraverseCallback(){

            @Override
            public void onNodeTraverse(Node<View, Edge> node, double parentX, double parentY) {
                if (GraphBoundsIndexerImpl.this.isNodeAt(node, parentX, parentY, x, y)) {
                    result[0] = node;
                }
            }
        }));
        return result[0];
    }

    private Point2D getNodeCoordinates(Node node) {
        Object content;
        if (null != node && (content = node.getContent()) instanceof View) {
            View viewContent = (View)content;
            return GraphUtils.getPosition(viewContent);
        }
        return null;
    }

    private double[] getNodeAbsoluteCoordinates(Node node, double parentX, double parentY) {
        View content = (View)node.getContent();
        Bounds bounds = content.getBounds();
        Bound ulBound = bounds.getUpperLeft();
        Bound lrBound = bounds.getLowerRight();
        double ulX = ulBound.getX() + parentX;
        double ulY = ulBound.getY() + parentY;
        double lrX = lrBound.getX() + parentX;
        double lrY = lrBound.getY() + parentY;
        return new double[]{ulX, ulY, lrX, lrY};
    }

    private boolean isNodeAt(Node node, double parentX, double parentY, double mouseX, double mouseY) {
        if (null != this.rootUUID && node.getUUID().equals(this.rootUUID)) {
            return true;
        }
        double[] absoluteCoords = this.getNodeAbsoluteCoordinates(node, parentX, parentY);
        double ulX = absoluteCoords[0];
        double ulY = absoluteCoords[1];
        double lrX = absoluteCoords[2];
        double lrY = absoluteCoords[3];
        return mouseX >= ulX && mouseX <= lrX && mouseY >= ulY && mouseY <= lrY;
    }

    public GraphBoundsIndexer setRootUUID(String uuid) {
        this.rootUUID = uuid;
        return this;
    }

    public void destroy() {
        this.graph = null;
        this.rootUUID = null;
        this.childrenTraverseProcessor = null;
    }

    private class GraphBoundIndexerTraverseCallback
    extends AbstractChildrenTraverseCallback<Node<View, Edge>, Edge<Child, Node>> {
        private final NodeBoundsTraverseCallback callback;

        private GraphBoundIndexerTraverseCallback(NodeBoundsTraverseCallback callback) {
            this.callback = callback;
        }

        @Override
        public void startNodeTraversal(Node<View, Edge> node) {
            super.startNodeTraversal(node);
            this.onStartNodeTraversal(Optional.empty(), node);
        }

        @Override
        public boolean startNodeTraversal(List<Node<View, Edge>> parents, Node<View, Edge> node) {
            super.startNodeTraversal(parents, node);
            this.onStartNodeTraversal(Optional.ofNullable(parents), node);
            return true;
        }

        private void onStartNodeTraversal(Optional<List<Node<View, Edge>>> parents, Node<View, Edge> node) {
            double[] parentLocation = new double[]{0.0, 0.0};
            if (parents.isPresent()) {
                parents.get().forEach(parent -> {
                    Point2D nodeCoordinates = GraphBoundsIndexerImpl.this.getNodeCoordinates(parent);
                    if (null != nodeCoordinates) {
                        parentLocation[0] = parentLocation[0] + nodeCoordinates.getX();
                        parentLocation[1] = parentLocation[1] + nodeCoordinates.getY();
                    }
                });
            }
            this.callback.onNodeTraverse(node, parentLocation[0], parentLocation[1]);
        }
    }

    private abstract class NodeBoundsTraverseCallback {
        private NodeBoundsTraverseCallback() {
        }

        public abstract void onNodeTraverse(Node<View, Edge> var1, double var2, double var4);
    }
}

