/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.dashbuilder.dataprovider.BeanDataSetProvider;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataprovider.StaticDataSetProvider;
import org.dashbuilder.dataprovider.StaticDataSetProviderCDI;
import org.dashbuilder.dataset.DataSetGenerator;
import org.dashbuilder.dataset.def.BeanDataSetDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.events.DataSetDefModifiedEvent;
import org.dashbuilder.dataset.events.DataSetDefRemovedEvent;
import org.dashbuilder.dataset.events.DataSetStaleEvent;

@ApplicationScoped
public class BeanDataSetProviderCDI
extends BeanDataSetProvider {
    protected BeanManager beanManager;
    protected Map<String, DataSetGenerator> generatorMap = new HashMap<String, DataSetGenerator>();

    public BeanDataSetProviderCDI() {
    }

    @Inject
    public BeanDataSetProviderCDI(StaticDataSetProviderCDI staticDataSetProvider, BeanManager beanManager) {
        super((StaticDataSetProvider)staticDataSetProvider);
        this.beanManager = beanManager;
    }

    @PostConstruct
    protected void init() {
        Set beans = this.beanManager.getBeans(DataSetGenerator.class, new Annotation[0]);
        for (Bean bean : beans) {
            CreationalContext ctx = this.beanManager.createCreationalContext((Contextual)bean);
            DataSetGenerator generator = (DataSetGenerator)this.beanManager.getReference(bean, DataSetGenerator.class, ctx);
            this.generatorMap.put(bean.getBeanClass().getName(), generator);
        }
    }

    public DataSetGenerator lookupGenerator(DataSetDef def) {
        BeanDataSetDef beanDef = (BeanDataSetDef)def;
        String beanName = beanDef.getGeneratorClass();
        DataSetGenerator generator = this.generatorMap.get(beanName);
        if (generator != null) {
            return generator;
        }
        throw new IllegalArgumentException("Data set generator class not found: " + beanName);
    }

    protected void onDataSetStaleEvent(@Observes DataSetStaleEvent event) {
        DataSetDef def = event.getDataSetDef();
        if (DataSetProviderType.BEAN.equals((Object)def.getProvider())) {
            this.staticDataSetProvider.removeDataSet(def.getUUID());
        }
    }

    protected void onDataSetDefRemovedEvent(@Observes DataSetDefRemovedEvent event) {
        DataSetDef def = event.getDataSetDef();
        if (DataSetProviderType.BEAN.equals((Object)def.getProvider())) {
            this.staticDataSetProvider.removeDataSet(def.getUUID());
        }
    }

    protected void onDataSetDefModifiedEvent(@Observes DataSetDefModifiedEvent event) {
        DataSetDef def = event.getOldDataSetDef();
        if (DataSetProviderType.BEAN.equals((Object)def.getProvider())) {
            this.staticDataSetProvider.removeDataSet(def.getUUID());
        }
    }
}

