/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.io.IOException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.commands.PathUtil;
import org.uberfire.java.nio.fs.jgit.util.model.PathInfo;
import org.uberfire.java.nio.fs.jgit.util.model.PathType;

public class GetPathInfo {
    private final Git git;
    private final String branchName;
    private final String path;

    public GetPathInfo(Git git, String branchName, String path) {
        this.git = git;
        this.branchName = branchName;
        this.path = path;
    }

    public PathInfo execute() throws IOException {
        String gitPath = PathUtil.normalize(this.path);
        if (gitPath.isEmpty()) {
            return new PathInfo(null, gitPath, PathType.DIRECTORY);
        }
        ObjectId tree = this.git.getTreeFromRef(this.branchName);
        if (tree == null) {
            return new PathInfo(null, gitPath, PathType.NOT_FOUND);
        }
        try (TreeWalk tw = new TreeWalk(this.git.getRepository());){
            tw.setFilter((TreeFilter)PathFilter.create((String)gitPath));
            tw.reset((AnyObjectId)tree);
            while (tw.next()) {
                if (tw.getPathString().equals(gitPath)) {
                    if (tw.getFileMode(0).equals(16384)) {
                        PathInfo pathInfo = new PathInfo(tw.getObjectId(0), gitPath, PathType.DIRECTORY);
                        return pathInfo;
                    }
                    if (tw.getFileMode(0).equals(32768) || tw.getFileMode(0).equals(FileMode.EXECUTABLE_FILE) || tw.getFileMode(0).equals(FileMode.REGULAR_FILE)) {
                        long size = tw.getObjectReader().getObjectSize((AnyObjectId)tw.getObjectId(0), 3);
                        PathInfo pathInfo = new PathInfo(tw.getObjectId(0), gitPath, PathType.FILE, size);
                        return pathInfo;
                    }
                }
                if (!tw.isSubtree()) continue;
                tw.enterSubtree();
            }
        }
        return new PathInfo(null, gitPath, PathType.NOT_FOUND);
    }
}

