/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.condition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Condition;
import org.assertj.core.description.Description;
import org.assertj.core.description.JoinDescription;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;

public abstract class Join<T>
extends Condition<T> {
    @VisibleForTesting
    final Collection<Condition<? super T>> conditions;

    @SafeVarargs
    protected Join(Condition<? super T> ... conditions) {
        Preconditions.checkNotNull(conditions, Join.conditionsIsNull());
        this.conditions = Arrays.stream(conditions).map(Join::notNull).collect(Collectors.toList());
        List<Description> descriptions = this.conditions.stream().map(Condition::description).collect(Collectors.toList());
        this.describedAs(new JoinDescription(this.descriptionPrefix() + ":[", "]", descriptions));
    }

    public abstract String descriptionPrefix();

    protected Join(Iterable<? extends Condition<? super T>> conditions) {
        Preconditions.checkNotNull(conditions, Join.conditionsIsNull());
        this.conditions = new ArrayList<Condition<? super T>>();
        for (Condition<T> condition : conditions) {
            this.conditions.add(Join.notNull(condition));
        }
    }

    private static String conditionsIsNull() {
        return "The given conditions should not be null";
    }

    private static <T> Condition<T> notNull(Condition<T> condition) {
        return Preconditions.checkNotNull(condition, "The given conditions should not have null entries");
    }

    protected final Collection<Condition<? super T>> conditions() {
        return Collections.unmodifiableCollection(this.conditions);
    }
}

