/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.longrest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.io.IOException;
import java.net.HttpCookie;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.jbpm.process.longrest.ProcessVariableResolverFactory;
import org.jbpm.process.longrest.RemoteInvocationException;
import org.jbpm.process.longrest.ResponseProcessingException;
import org.jbpm.process.longrest.WorkitemAbortedException;
import org.jbpm.process.longrest.util.Mapper;
import org.jbpm.process.longrest.util.ProcessUtils;
import org.jbpm.process.longrest.util.Strings;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.MapVariableResolverFactory;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="LongRunningRestService.wid", name="LongRunningRestService", displayName="LongRunningRestService", defaultHandler="mvel: new org.jbpm.process.longrest.LongRunningRestServiceWorkItemHandler(runtimeManager)", category="long-running-rest-workitem", documentation="", parameters={@WidParameter(name="url", required=true), @WidParameter(name="method", required=true), @WidParameter(name="headers", required=false), @WidParameter(name="template", required=false), @WidParameter(name="cancelUrlJsonPointer", required=false), @WidParameter(name="cancelUrlTemplate", required=false), @WidParameter(name="socketTimeout", required=false), @WidParameter(name="connectTimeout", required=false), @WidParameter(name="connectionRequestTimeout", required=false)}, results={@WidResult(name="responseCode"), @WidResult(name="result"), @WidResult(name="cancelUrl"), @WidResult(name="error")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="long-running-rest-workitem", version="7.73.0.Final")}, serviceInfo=@WidService(category="REST service", description="", keywords="rest,long-running", action=@WidAction(title="Long running REST service handler ver. 7.73.0.Final"), authinfo=@WidAuth(required=true, params={"url"})))
public class LongRunningRestServiceWorkItemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(LongRunningRestServiceWorkItemHandler.class);
    private static final String COOKIES_KEY = "cookies";
    private final RuntimeManager runtimeManager;
    ParserContext mvelContext = new ParserContext();

    public LongRunningRestServiceWorkItemHandler(RuntimeManager runtimeManager) {
        this.runtimeManager = runtimeManager;
        logger.debug("Constructing with runtimeManager ...");
        this.initializeMvelContext();
        this.setLogThrownException(false);
    }

    public LongRunningRestServiceWorkItemHandler() {
        logger.debug("Constructing without runtimeManager ...");
        this.runtimeManager = null;
        this.initializeMvelContext();
        this.setLogThrownException(false);
    }

    private void initializeMvelContext() {
        this.mvelContext.addImport("quote", MVEL.getStaticMethod(Strings.class, (String)"quoteString", (Class[])new Class[]{Object.class}));
        this.mvelContext.addImport("asJson", MVEL.getStaticMethod(Mapper.class, (String)"writeValueAsString", (Class[])new Class[]{Object.class, Boolean.TYPE}));
        this.mvelContext.addImport("asJson", MVEL.getStaticMethod(Mapper.class, (String)"writeValueAsString", (Class[])new Class[]{Object.class}));
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            long processInstanceId = workItem.getProcessInstanceId();
            WorkflowProcessInstance processInstance = ProcessUtils.getProcessInstance(this.runtimeManager, processInstanceId);
            String cancelUrlJsonPointer = ProcessUtils.getStringParameter(workItem, "cancelUrlJsonPointer");
            String cancelUrlTemplate = ProcessUtils.getStringParameter(workItem, "cancelUrlTemplate");
            String requestUrl = ProcessUtils.getStringParameter(workItem, "url");
            String requestMethod = ProcessUtils.getStringParameter(workItem, "method");
            String requestTemplate = ProcessUtils.getStringParameter(workItem, "template");
            String requestHeaders = ProcessUtils.getStringParameter(workItem, "headers");
            int socketTimeout = ProcessUtils.getIntParameter(workItem, "socketTimeout", 5000);
            int connectTimeout = ProcessUtils.getIntParameter(workItem, "connectTimeout", 5000);
            int connectionRequestTimeout = ProcessUtils.getIntParameter(workItem, "connectionRequestTimeout", 5000);
            KieSession kieSession = ProcessUtils.getKsession(this.runtimeManager, processInstanceId);
            String containerId = (String)kieSession.getEnvironment().get("deploymentId");
            logger.debug("Should run ProcessInstance.id: {}.", (Object)processInstance.getId());
            try {
                this.invokeRemoteService(processInstance, manager, workItem.getId(), requestUrl, requestMethod, requestTemplate, containerId, cancelUrlJsonPointer, cancelUrlTemplate, requestHeaders, socketTimeout, connectTimeout, connectionRequestTimeout);
            }
            catch (RemoteInvocationException e) {
                String message = MessageFormat.format("Failed to invoke remote service. ProcessInstanceId {0}.", processInstanceId);
                logger.warn(message, (Throwable)e);
                this.completeWorkItem(manager, workItem.getId(), e);
            }
            catch (ResponseProcessingException e) {
                String message = MessageFormat.format("Failed to process response. ProcessInstanceId {0}.", processInstanceId);
                logger.warn(message, (Throwable)e);
                this.completeWorkItem(manager, workItem.getId(), e);
            }
        }
        catch (Throwable cause) {
            logger.error("Failed to execute workitem handler due to the following error.", cause);
            this.completeWorkItem(manager, workItem.getId(), cause);
        }
    }

    private void invokeRemoteService(WorkflowProcessInstance processInstance, WorkItemManager manager, long workItemId, String requestUrl, String httpMethod, String requestTemplate, String containerId, String cancelUrlJsonPointer, String cancelUrlTemplate, String requestHeaders, int socketTimeout, int connectTimeout, int connectionRequestTimeout) throws RemoteInvocationException, ResponseProcessingException {
        String requestBodyEvaluated;
        logger.debug("requestTemplate: {}", (Object)requestTemplate);
        VariableResolverFactory variableResolverFactory = this.getVariableResolverFactory(processInstance, containerId);
        if (requestTemplate != null && !requestTemplate.equals("")) {
            CompiledTemplate compiled = TemplateCompiler.compileTemplate((String)requestTemplate, (ParserContext)this.mvelContext);
            requestBodyEvaluated = (String)TemplateRuntime.execute((CompiledTemplate)compiled, (Object)this.mvelContext, (VariableResolverFactory)variableResolverFactory);
        } else {
            requestBodyEvaluated = "";
        }
        HashMap<String, String> requestHeadersMap = new HashMap<String, String>();
        Map cookies = (Map)processInstance.getVariable(COOKIES_KEY);
        if (cookies != null) {
            String cookieHeader = cookies.entrySet().stream().map(c -> (String)c.getKey() + "=" + (String)c.getValue()).collect(Collectors.joining("; "));
            requestHeadersMap.put("Cookie", cookieHeader);
        }
        requestHeadersMap.putAll(Strings.toMap(requestHeaders));
        HttpResponse httpResponse = this.httpRequest(requestUrl, requestBodyEvaluated, httpMethod, requestHeadersMap, socketTimeout, connectTimeout, connectionRequestTimeout);
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        logger.info("Remote endpoint returned status: {}.", (Object)statusCode);
        if (statusCode < 200 || statusCode >= 300) {
            String message = MessageFormat.format("Remote service responded with error status code {0} and reason: {1}. ProcessInstanceId {2}.", statusCode, httpResponse.getStatusLine().getReasonPhrase(), processInstance.getId());
            throw new RemoteInvocationException(message);
        }
        this.storeCookies(httpResponse, processInstance);
        HttpEntity responseEntity = httpResponse.getEntity();
        if (statusCode == 204 || responseEntity.getContentLength() == 0L) {
            this.completeWorkItem(manager, workItemId, statusCode, Collections.emptyMap(), "");
        } else {
            Map<String, Object> serviceInvocationResponse;
            JsonNode root;
            String responseString;
            try {
                responseString = EntityUtils.toString((HttpEntity)responseEntity, (String)"UTF-8");
                logger.debug("Invocation response: {}", (Object)responseString);
            }
            catch (IOException e) {
                throw new ResponseProcessingException("Cannot read remote entity.", e);
            }
            try {
                root = Mapper.getInstance().readTree(responseString);
                if (JsonNodeType.ARRAY.equals((Object)root.getNodeType())) {
                    serviceInvocationResponse = new LinkedHashMap();
                    Object[] array = (Object[])Mapper.getInstance().convertValue((Object)root, (TypeReference)new TypeReference<Object[]>(){});
                    for (int i = 0; i < array.length; ++i) {
                        serviceInvocationResponse.put(Integer.toString(i), array[i]);
                    }
                } else {
                    serviceInvocationResponse = (Map)Mapper.getInstance().convertValue((Object)root, (TypeReference)new TypeReference<Map<String, Object>>(){});
                }
            }
            catch (Exception e) {
                String message = MessageFormat.format("Cannot parse service invocation response. ProcessInstanceId {0}.", processInstance.getId());
                throw new ResponseProcessingException(message, e);
            }
            String cancelUrl = "";
            try {
                if (!Strings.isEmpty(cancelUrlTemplate)) {
                    logger.debug("Setting cancel url from template: {}.", (Object)cancelUrlTemplate);
                    CompiledTemplate compiled = TemplateCompiler.compileTemplate((String)cancelUrlTemplate);
                    cancelUrl = (String)TemplateRuntime.execute((CompiledTemplate)compiled, null, (VariableResolverFactory)variableResolverFactory);
                } else if (!Strings.isEmpty(cancelUrlJsonPointer)) {
                    logger.debug("Setting cancel url from json pointer: {}.", (Object)cancelUrlJsonPointer);
                    JsonNode cancelUrlNode = root.at(cancelUrlJsonPointer);
                    if (!cancelUrlNode.isMissingNode()) {
                        cancelUrl = cancelUrlNode.asText();
                    }
                }
                logger.debug("Cancel url: {}.", (Object)cancelUrl);
            }
            catch (Exception e) {
                String message = MessageFormat.format("Cannot read cancel url from service invocation response. ProcessInstanceId {0}.", processInstance.getId());
                throw new ResponseProcessingException(message, e);
            }
            this.completeWorkItem(manager, workItemId, statusCode, serviceInvocationResponse, cancelUrl);
        }
    }

    private void storeCookies(HttpResponse response, WorkflowProcessInstance processInstance) {
        Header[] cookieHeaders;
        HashMap<String, String> cookies = new HashMap<String, String>();
        for (Header cookieHeader : cookieHeaders = response.getHeaders("Set-Cookie")) {
            List<HttpCookie> cookiesInTheHeader = HttpCookie.parse(cookieHeader.getValue());
            Map<String, String> cookiesMap = cookiesInTheHeader.stream().collect(Collectors.toMap(HttpCookie::getName, HttpCookie::getValue));
            cookies.putAll(cookiesMap);
        }
        processInstance.setVariable(COOKIES_KEY, cookies);
    }

    private VariableResolverFactory getVariableResolverFactory(WorkflowProcessInstance processInstance, String containerId) {
        HashMap<String, Object> systemVariables = new HashMap<String, Object>();
        String baseUrl = this.getKieHost() + "/services/rest/server/containers/" + containerId + "/processes/instances/";
        systemVariables.put("callbackUrl", baseUrl + processInstance.getId() + "/signal/RESTResponded");
        systemVariables.put("callbackMethod", "POST");
        systemVariables.put("heartBeatUrl", baseUrl + processInstance.getId() + "/signal/imAlive");
        systemVariables.put("heartBeatMethod", "POST");
        return this.getVariableResolverFactoryChain(systemVariables, processInstance);
    }

    private VariableResolverFactory getVariableResolverFactoryChain(Map<String, Object> systemVariables, WorkflowProcessInstance processInstance) {
        MapVariableResolverFactory variableResolverFactory = new MapVariableResolverFactory(Collections.singletonMap("system", systemVariables));
        VariableResolverFactory resolver = variableResolverFactory.setNextFactory((VariableResolverFactory)new ProcessVariableResolverFactory(processInstance));
        WorkflowProcessInstance currentInstance = processInstance;
        int maxDepth = 100;
        int depth = 0;
        while (true) {
            if (++depth > maxDepth) {
                throw new RuntimeException("To many nested process instances, allowed only up to " + maxDepth + ".");
            }
            long parentProcessInstanceId = currentInstance.getParentProcessInstanceId();
            if (parentProcessInstanceId <= 0L) break;
            WorkflowProcessInstance parentProcessInstance = ProcessUtils.getProcessInstance(this.runtimeManager, parentProcessInstanceId);
            resolver.setNextFactory((VariableResolverFactory)new ProcessVariableResolverFactory(parentProcessInstance));
            currentInstance = parentProcessInstance;
        }
        return variableResolverFactory;
    }

    private HttpResponse httpRequest(String url, String jsonContent, String httpMethod, Map<String, String> requestHeaders, int socketTimeout, int connectTimeout, int connectionRequestTimeout) throws RemoteInvocationException {
        HttpResponse httpResponse;
        RequestConfig config = RequestConfig.custom().setSocketTimeout(socketTimeout).setConnectTimeout(connectTimeout).setConnectionRequestTimeout(connectionRequestTimeout).build();
        HttpClientBuilder clientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(config);
        CloseableHttpClient httpClient = clientBuilder.build();
        RequestBuilder requestBuilder = RequestBuilder.create((String)httpMethod).setUri(url);
        if (requestHeaders != null) {
            requestHeaders.forEach((k, v) -> requestBuilder.addHeader(k, v));
        }
        if (jsonContent != null && !jsonContent.equals("")) {
            requestBuilder.setHeader("Content-Type", "application/json");
            StringEntity entity = new StringEntity(jsonContent, ContentType.APPLICATION_JSON);
            requestBuilder.setEntity((HttpEntity)entity);
        }
        logger.info("Invoking remote endpoint {} {} Headers: {} Body: {}.", new Object[]{httpMethod, url, requestHeaders, jsonContent});
        try {
            httpResponse = httpClient.execute(requestBuilder.build());
        }
        catch (IOException e) {
            throw new RemoteInvocationException("Unable to invoke remote endpoint.", e);
        }
        return httpResponse;
    }

    private String getKieHost() {
        String host = System.getProperty("HOSTNAME_HTTPS");
        if (host != null) {
            host = "https://" + host;
        }
        if (host == null && (host = System.getProperty("HOSTNAME_HTTP")) != null) {
            host = "http://" + host;
        }
        if (host == null && (host = System.getenv("HOSTNAME_HTTPS")) != null) {
            host = "https://" + host;
        }
        if (host == null && (host = System.getenv("HOSTNAME_HTTP")) != null) {
            host = "http://" + host;
        }
        return host;
    }

    private void completeWorkItem(WorkItemManager manager, long workItemId, int responseCode, Map<String, Object> serviceInvocationResult, String cancelUrl) {
        this.completeWorkItem(manager, workItemId, responseCode, serviceInvocationResult, cancelUrl, Optional.empty());
    }

    private void completeWorkItem(WorkItemManager manager, long workItemId, Throwable cause) {
        this.completeWorkItem(manager, workItemId, -1, Collections.emptyMap(), "", Optional.ofNullable(cause));
    }

    private void completeWorkItem(WorkItemManager manager, long workItemId, int responseCode, Map<String, Object> serviceInvocationResult, String cancelUrl, Optional<Throwable> cause) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("responseCode", responseCode);
        results.put("result", serviceInvocationResult);
        results.put("cancelUrl", cancelUrl);
        cause.ifPresent(c -> results.put("error", c));
        logger.info("Rest service workitem completion result {}.", results);
        manager.completeWorkItem(workItemId, results);
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        this.completeWorkItem(manager, workItem.getId(), new WorkitemAbortedException());
    }
}

