/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.backend;

import java.io.IOException;
import java.io.InputStream;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.FilenameUtils;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.plugin.backend.MediaServletURI;
import org.uberfire.ext.plugin.event.MediaAdded;
import org.uberfire.ext.plugin.model.Media;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.EncodingUtil;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.server.BaseUploadServlet;
import org.uberfire.server.MimeType;

public class PluginMediaServlet
extends BaseUploadServlet {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private Event<MediaAdded> newMediaEvent;
    private String pattern = "/plugins/";
    @Inject
    @Named(value="MediaServletURI")
    private MediaServletURI mediaServletURI;
    @Inject
    @Named(value="pluginsFS")
    private FileSystem fileSystem;
    private Path root;

    public void init(ServletConfig config) throws ServletException {
        String pattern = config.getInitParameter("url-pattern");
        if (pattern != null && !pattern.trim().isEmpty()) {
            this.pattern = pattern.endsWith("/") ? pattern : pattern + "/";
            if (this.pattern.startsWith("/")) {
                this.mediaServletURI.setURI(this.pattern.substring(1));
            } else {
                this.mediaServletURI.setURI(this.pattern);
            }
        }
        this.root = (Path)this.fileSystem.getRootDirectories().iterator().next();
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        InputStream in;
        String filename;
        String mime = null;
        boolean isPreview = req.getParameterMap().containsKey("preview");
        String _filename = EncodingUtil.decode((String)req.getRequestURI().substring(req.getContextPath().length()));
        if (_filename.toLowerCase().endsWith("?preview")) {
            filename = _filename.substring(0, _filename.toLowerCase().indexOf("?preview"));
            isPreview = true;
        } else {
            filename = _filename;
        }
        Path mediaPath = this.resolve(filename.replace(this.pattern, "/"));
        if (!this.ioService.exists(mediaPath)) {
            mime = "image/png";
            in = ((Object)((Object)this)).getClass().getResourceAsStream("/nofound.png");
        } else {
            mime = MimeType.fromExtension((String)("." + FilenameUtils.getExtension((String)mediaPath.getFileName().toString()))).getType();
            if (isPreview) {
                if (mime != null && !mime.startsWith("image/")) {
                    mime = "image/png";
                    in = ((Object)((Object)this)).getClass().getResourceAsStream("/placeholder.png");
                } else {
                    in = this.ioService.newInputStream(mediaPath, new OpenOption[0]);
                }
            } else {
                in = this.ioService.newInputStream(mediaPath, new OpenOption[0]);
            }
        }
        if (mime == null) {
            resp.setStatus(500);
            return;
        }
        resp.setContentType(mime);
        ServletOutputStream out = resp.getOutputStream();
        byte[] buf = new byte[1024];
        int count = 0;
        while ((count = in.read(buf)) >= 0) {
            out.write(buf, 0, count);
        }
        out.close();
        in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        block6: {
            try {
                String filename = req.getRequestURI().substring(req.getContextPath().length());
                String pluginName = filename.replace(this.pattern, "/");
                if (pluginName == null) break block6;
                FileItem fileItem = this.getFileItem(req);
                String fileName = FilenameUtils.getName((String)fileItem.getName());
                Path path = this.resolve(pluginName + "/media/" + fileName);
                if (this.ioService.exists(path)) {
                    this.writeResponse(response, "FAIL - ALREADY EXISTS");
                    return;
                }
                try {
                    this.ioService.startBatch(path.getFileSystem());
                    this.writeFile(this.ioService, path, fileItem);
                }
                finally {
                    this.ioService.endBatch();
                }
                this.newMediaEvent.fire((Object)new MediaAdded(pluginName.substring(1), new Media(this.pattern.substring(1) + pluginName.substring(1) + "/media/" + path.getFileName(), Paths.convert((Path)path))));
                this.writeResponse(response, "OK");
            }
            catch (Exception e) {
                this.logError(e);
                this.writeResponse(response, "FAIL");
            }
        }
    }

    Path resolve(String other) {
        return this.root.resolve(other);
    }
}

