/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.backend.service;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.runtime.ContainerList;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.service.RuntimeManagementService;
import org.kie.server.controller.api.service.SpecManagementService;
import org.kie.workbench.common.screens.server.management.model.ContainerSpecData;

@Service
@ApplicationScoped
public class RuntimeManagementServiceCDI
implements org.kie.workbench.common.screens.server.management.service.RuntimeManagementService {
    @Inject
    @Any
    private SpecManagementService specManagementService;
    @Inject
    @Any
    private RuntimeManagementService service;

    public Collection<Container> getContainersByServerInstance(String serverTemplateId, String serverInstanceId) {
        ServerTemplate serverTemplate = this.specManagementService.getServerTemplate(serverTemplateId);
        if (serverTemplate == null) {
            throw new RuntimeException("Server template with id " + serverTemplateId + " not found");
        }
        return serverTemplate.getServerInstanceKeys().stream().filter(serverInstanceKey -> serverInstanceKey.getServerInstanceId().equalsIgnoreCase(serverInstanceId)).findFirst().map(serverInstanceKey -> Arrays.asList(this.service.getContainers(serverInstanceKey).getContainers())).orElse(Collections.emptyList());
    }

    public ContainerSpecData getContainersByContainerSpec(String serverTemplateId, String containerSpecId) {
        ServerTemplate serverTemplate = this.specManagementService.getServerTemplate(serverTemplateId);
        if (serverTemplate == null) {
            throw new RuntimeException("Server template with id " + serverTemplateId + " not found");
        }
        ContainerSpec containerSpec = serverTemplate.getContainerSpec(containerSpecId);
        if (containerSpec == null) {
            throw new RuntimeException("Container with id " + containerSpecId + " not found");
        }
        ContainerList containerList = this.service.getContainers(serverTemplate, containerSpec);
        List<Container> containers = Arrays.asList(containerList.getContainers());
        return new ContainerSpecData(containerSpec, containers);
    }
}

