/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.backend.server;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.screens.datamodeller.model.persistence.PersistenceDescriptorModel;
import org.kie.workbench.common.screens.datamodeller.model.persistence.PersistenceUnitModel;
import org.kie.workbench.common.screens.datamodeller.model.persistence.Property;
import org.kie.workbench.common.screens.datamodeller.model.persistence.TransactionType;
import org.kie.workbench.common.screens.datamodeller.service.PersistenceDescriptorService;
import org.kie.workbench.common.screens.datamodeller.util.PersistenceDescriptorXMLMarshaller;
import org.kie.workbench.common.screens.datamodeller.validation.PersistenceDescriptorValidator;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@Service
@ApplicationScoped
public class PersistenceDescriptorServiceImpl
implements PersistenceDescriptorService {
    private IOService ioService;
    private MetadataService metadataService;
    private CommentedOptionFactory optionsFactory;
    private KieModuleService moduleService;
    private PersistenceDescriptorValidator descriptorValidator;

    public PersistenceDescriptorServiceImpl() {
    }

    @Inject
    public PersistenceDescriptorServiceImpl(@Named(value="ioStrategy") IOService ioService, KieModuleService moduleService, PersistenceDescriptorValidator descriptorValidator, MetadataService metadataService, CommentedOptionFactory optionsFactory) {
        this.ioService = ioService;
        this.moduleService = moduleService;
        this.descriptorValidator = descriptorValidator;
        this.metadataService = metadataService;
        this.optionsFactory = optionsFactory;
    }

    public PersistenceDescriptorModel load(org.uberfire.backend.vfs.Path path) {
        try {
            BufferedInputStream inputStream = new BufferedInputStream(this.ioService.newInputStream(Paths.convert((org.uberfire.backend.vfs.Path)path), new OpenOption[0]));
            return PersistenceDescriptorXMLMarshaller.fromXML((InputStream)inputStream, (boolean)false);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public PersistenceDescriptorModel load(Module module) {
        org.uberfire.backend.vfs.Path descriptorPath = this.calculatePersistenceDescriptorPath(module);
        if (descriptorPath != null) {
            return this.load(descriptorPath);
        }
        return null;
    }

    public org.uberfire.backend.vfs.Path calculatePersistenceDescriptorPath(Module module) {
        org.uberfire.backend.vfs.Path rootPath;
        if (module == null || (rootPath = module.getRootPath()) == null) {
            return null;
        }
        Path nioRootPath = Paths.convert((org.uberfire.backend.vfs.Path)rootPath);
        org.uberfire.backend.vfs.Path descriptorPath = Paths.convert((Path)nioRootPath.resolve("src/main/resources/META-INF/persistence.xml"));
        return descriptorPath;
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path path, PersistenceDescriptorModel model, Metadata metadata, String comment) {
        try {
            Path result = null;
            String content = PersistenceDescriptorXMLMarshaller.toXML((PersistenceDescriptorModel)model);
            result = metadata != null ? this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)path), content, this.metadataService.setUpAttributes(path, metadata), new OpenOption[]{this.optionsFactory.makeCommentedOption(comment)}) : (comment != null ? this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)path), content, new OpenOption[]{this.optionsFactory.makeCommentedOption(comment)}) : this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)path), content, new OpenOption[0]));
            return Paths.convert((Path)result);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public List<ValidationMessage> validate(org.uberfire.backend.vfs.Path path, PersistenceDescriptorModel model) {
        return this.descriptorValidator.validate(path, model);
    }

    public String toSource(org.uberfire.backend.vfs.Path path, PersistenceDescriptorModel model) {
        String content;
        try {
            content = PersistenceDescriptorXMLMarshaller.toXML((PersistenceDescriptorModel)model);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
        return content;
    }

    public PersistenceDescriptorModel createModuleDefaultDescriptor(org.uberfire.backend.vfs.Path path) {
        KieModule module = (KieModule)this.moduleService.resolveModule(path);
        if (module == null) {
            return null;
        }
        PersistenceDescriptorModel descriptorModel = new PersistenceDescriptorModel();
        descriptorModel.setVersion("2.0");
        PersistenceUnitModel unitModel = new PersistenceUnitModel();
        descriptorModel.setPersistenceUnit(unitModel);
        unitModel.setName(module.getPom().getGav().toString());
        unitModel.setTransactionType(TransactionType.JTA);
        unitModel.setProvider("org.hibernate.jpa.HibernatePersistenceProvider");
        unitModel.setJtaDataSource("java:jboss/datasources/ExampleDS");
        unitModel.addProperty(new Property("hibernate.dialect", "org.hibernate.dialect.H2Dialect"));
        unitModel.addProperty(new Property("hibernate.max_fetch_depth", "3"));
        unitModel.addProperty(new Property("hibernate.hbm2ddl.auto", "update"));
        unitModel.addProperty(new Property("hibernate.show_sql", "false"));
        unitModel.addProperty(new Property("hibernate.id.new_generator_mappings", "false"));
        unitModel.addProperty(new Property("hibernate.transaction.jta.platform", "org.hibernate.service.jta.platform.internal.JBossAppServerJtaPlatform"));
        unitModel.setExcludeUnlistedClasses(Boolean.valueOf(true));
        return descriptorModel;
    }
}

