/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.service;

import java.io.File;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.dashbuilder.DataSetCore;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetDefDeployerCDI;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetManagerCDI;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.exception.DataSetLookupException;
import org.dashbuilder.dataset.service.DataSetLookupServices;
import org.dashbuilder.dataset.uuid.UUIDGenerator;
import org.dashbuilder.exception.ExceptionManager;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.bus.server.api.RpcContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Service
public class DataSetLookupServicesImpl
implements DataSetLookupServices {
    protected static Logger log = LoggerFactory.getLogger(DataSetLookupServicesImpl.class);
    protected DataSetManagerCDI dataSetManager;
    protected UUIDGenerator uuidGenerator;
    protected DataSetDefDeployerCDI dataSetDefDeployer;
    protected ExceptionManager exceptionManager;

    public DataSetLookupServicesImpl() {
    }

    @Inject
    public DataSetLookupServicesImpl(DataSetManagerCDI dataSetManager, DataSetDefDeployerCDI dataSetDefDeployer, ExceptionManager exceptionManager) {
        this.dataSetManager = dataSetManager;
        this.uuidGenerator = DataSetCore.get().getUuidGenerator();
        this.dataSetDefDeployer = dataSetDefDeployer;
        this.exceptionManager = exceptionManager;
    }

    @PostConstruct
    protected void init() {
        String dir;
        ServletContext servletContext = RpcContext.getHttpSession().getServletContext();
        if (!this.dataSetDefDeployer.isRunning() && servletContext != null && (dir = servletContext.getRealPath("WEB-INF/datasets")) != null && new File(dir).exists()) {
            dir = dir.replaceAll("\\\\", "/");
            this.dataSetDefDeployer.deploy(dir);
        }
    }

    public DataSet lookupDataSet(DataSetLookup lookup) throws Exception {
        DataSet _d = null;
        try {
            _d = this.dataSetManager.lookupDataSet(lookup);
        }
        catch (DataSetLookupException e) {
            throw this.exceptionManager.handleException((Exception)((Object)e));
        }
        return _d;
    }

    public DataSet lookupDataSet(DataSetDef def, DataSetLookup lookup) throws Exception {
        try {
            if (def.getUUID() == null) {
                String uuid = this.uuidGenerator.newUuid();
                def.setUUID(uuid);
                lookup.setDataSetUUID(uuid);
            }
            return this.dataSetManager.resolveProvider(def).lookupDataSet(def, lookup);
        }
        catch (Exception e) {
            throw this.exceptionManager.handleException(e);
        }
    }

    public DataSetMetadata lookupDataSetMetadata(String uuid) throws Exception {
        DataSetMetadata _d = null;
        try {
            _d = this.dataSetManager.getDataSetMetadata(uuid);
        }
        catch (DataSetLookupException e) {
            throw this.exceptionManager.handleException((Exception)((Object)e));
        }
        return _d;
    }
}

