/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.backend.core;

import java.util.ArrayList;
import java.util.List;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceDeploymentInfo;
import org.kie.workbench.common.screens.datasource.management.model.DriverDef;

public class DriverDeploymentCacheEntry {
    private DriverDef driverDef;
    private List<DataSourceDeploymentInfo> dependants = new ArrayList<DataSourceDeploymentInfo>();

    public DriverDeploymentCacheEntry(DriverDef driverDef) {
        this.driverDef = driverDef;
    }

    public String getUuid() {
        return this.driverDef.getUuid();
    }

    public DriverDef getDriverDef() {
        return this.driverDef;
    }

    public void addDependant(DataSourceDeploymentInfo deploymentInfo) {
        this.dependants.add(deploymentInfo);
    }

    public boolean hasDependants() {
        return !this.dependants.isEmpty();
    }

    public boolean hasDependant(DataSourceDeploymentInfo deploymentInfo) {
        return this.dependants.contains(deploymentInfo);
    }

    public void removeDependant(DataSourceDeploymentInfo deploymentInfo) {
        this.dependants.remove(deploymentInfo);
    }

    public List<DataSourceDeploymentInfo> getDependants() {
        return this.dependants;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DriverDeploymentCacheEntry that = (DriverDeploymentCacheEntry)o;
        if (this.driverDef != null ? !this.driverDef.equals((Object)that.driverDef) : that.driverDef != null) {
            return false;
        }
        return !(this.dependants == null ? that.dependants != null : !this.dependants.equals(that.dependants));
    }

    public int hashCode() {
        int result = this.driverDef != null ? this.driverDef.hashCode() : 0;
        result = 31 * result + (this.dependants != null ? this.dependants.hashCode() : 0);
        return result;
    }
}

