/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.editor.backend.indexing;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.kie.workbench.common.forms.editor.backend.indexing.FormDefinitionVisitor;
import org.kie.workbench.common.forms.editor.backend.indexing.FormModelVisitor;
import org.kie.workbench.common.forms.editor.backend.indexing.FormModelVisitorProvider;
import org.kie.workbench.common.forms.editor.type.FormResourceTypeDefinition;
import org.kie.workbench.common.forms.model.FormDefinition;
import org.kie.workbench.common.forms.model.FormModel;
import org.kie.workbench.common.forms.services.backend.serialization.FormDefinitionSerializer;
import org.kie.workbench.common.services.refactoring.Resource;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.AbstractFileIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.IndexBuilder;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class FormDefinitionIndexer
extends AbstractFileIndexer {
    private static final Logger logger = LoggerFactory.getLogger(FormDefinitionIndexer.class);
    protected FormResourceTypeDefinition formResourceTypeDefinition;
    protected FormDefinitionSerializer formDefinitionSerializer;
    protected Map<Class, FormModelVisitorProvider> visitorProviders = new HashMap<Class, FormModelVisitorProvider>();

    @Inject
    public FormDefinitionIndexer(FormResourceTypeDefinition formResourceTypeDefinition, FormDefinitionSerializer formDefinitionSerializer, Instance<FormModelVisitorProvider<? extends FormModel>> visitorProviderInstance) {
        this.formResourceTypeDefinition = formResourceTypeDefinition;
        this.formDefinitionSerializer = formDefinitionSerializer;
        visitorProviderInstance.iterator().forEachRemaining(visitorProvider -> this.visitorProviders.put(visitorProvider.getModelType(), (FormModelVisitorProvider)visitorProvider));
    }

    protected IndexBuilder fillIndexBuilder(Path path) throws Exception {
        DefaultIndexBuilder builder = this.getIndexBuilder(path);
        if (builder == null) {
            return null;
        }
        String formContent = this.ioService.readAllString(path);
        FormDefinition formDefinition = this.formDefinitionSerializer.deserialize(formContent);
        if (formDefinition != null) {
            FormModelVisitorProvider provider;
            Resource resParts = new Resource(formDefinition.getName(), ResourceType.FORM);
            FormDefinitionVisitor visitor = new FormDefinitionVisitor(resParts);
            visitor.visit(formDefinition);
            this.addReferencedResourcesToIndexBuilder(builder, visitor);
            FormModel model = formDefinition.getModel();
            if (model != null && (provider = this.getProviderForModel(model.getClass())) != null) {
                FormModelVisitor<FormModel> modelVisitor = provider.getVisitor();
                modelVisitor.index(formDefinition, model);
                this.addReferencedResourcesToIndexBuilder(builder, modelVisitor);
            }
        } else {
            logger.error("Unable to read FormDefinition on " + path.toUri().toString() + ".");
            return null;
        }
        return builder;
    }

    protected FormModelVisitorProvider getProviderForModel(Class<? extends FormModel> modelClass) {
        return this.visitorProviders.get(modelClass);
    }

    public boolean supportsPath(Path path) {
        return this.formResourceTypeDefinition.accept(Paths.convert((Path)path));
    }
}

