/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.kafka;

import java.util.List;
import java.util.function.Consumer;
import org.dashbuilder.DataSetCore;
import org.dashbuilder.dataprovider.DataSetProvider;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataprovider.StaticDataSetProvider;
import org.dashbuilder.dataprovider.kafka.KafkaMetricsProvider;
import org.dashbuilder.dataprovider.kafka.model.KafkaMetric;
import org.dashbuilder.dataprovider.kafka.model.KafkaMetricsRequest;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.dashbuilder.dataset.def.DataSetDefRegistryListener;
import org.dashbuilder.dataset.def.KafkaDataSetDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaDataSetProvider
implements DataSetProvider,
DataSetDefRegistryListener {
    public static final String DOMAIN_COLUMN = "DOMAIN";
    public static final String TYPE_COLUMN = "TYPE";
    public static final String NAME_COLUMN = "NAME";
    public static final String ATTRIBUTE_COLUMN = "ATTRIBUTE";
    public static final String VALUE_COLUMN = "VALUE";
    protected StaticDataSetProvider staticDataSetProvider;
    protected Logger log = LoggerFactory.getLogger(KafkaDataSetProvider.class);
    private static KafkaDataSetProvider instance = null;

    public static KafkaDataSetProvider get() {
        if (instance == null) {
            StaticDataSetProvider staticDataSetProvider = DataSetCore.get().getStaticDataSetProvider();
            DataSetDefRegistry dataSetDefRegistry = DataSetCore.get().getDataSetDefRegistry();
            instance = new KafkaDataSetProvider(staticDataSetProvider);
            dataSetDefRegistry.addListener((DataSetDefRegistryListener)instance);
        }
        return instance;
    }

    public KafkaDataSetProvider() {
    }

    public KafkaDataSetProvider(StaticDataSetProvider staticDataSetProvider) {
        this.staticDataSetProvider = staticDataSetProvider;
    }

    public DataSetProviderType getType() {
        return DataSetProviderType.KAFKA;
    }

    public DataSetMetadata getDataSetMetadata(DataSetDef def) throws Exception {
        DataSet dataSet = this.lookupDataSet(def, null);
        if (dataSet == null) {
            return null;
        }
        return dataSet.getMetadata();
    }

    public DataSet lookupDataSet(DataSetDef def, DataSetLookup lookup) throws Exception {
        KafkaMetricsRequest request = this.buildRequestFromDef(def);
        List<KafkaMetric> metrics = this.loadMetrics(request);
        DataSet dataSet = this.toDataSet(metrics);
        dataSet.setUUID(def.getUUID());
        dataSet.setDefinition(def);
        this.staticDataSetProvider.registerDataSet(dataSet);
        return this.staticDataSetProvider.lookupDataSet(def, lookup);
    }

    List<KafkaMetric> loadMetrics(KafkaMetricsRequest request) {
        List<KafkaMetric> metrics;
        try {
            metrics = KafkaMetricsProvider.get().getMetrics(request);
        }
        catch (Exception e) {
            this.log.error("Error retrieving metrics from Kafka: {}", (Object)e.getMessage());
            this.log.debug("Error retrieving metrics from Kafka", (Throwable)e);
            throw new RuntimeException("Error connecting to Kafka, check if the host/port is correct and the server is running. See logs for more details.");
        }
        if (metrics.isEmpty()) {
            throw new RuntimeException(this.noMetricsErrorMessage(request));
        }
        return metrics;
    }

    String noMetricsErrorMessage(KafkaMetricsRequest request) {
        StringBuilder sb = new StringBuilder("No metrics were found. Check if ");
        Consumer<String> appendParamCheck = s -> sb.append(String.format(", %s is correct", s));
        sb.append("the " + request.getMetricsTarget().name() + " has available metrics");
        request.clientId().ifPresent(c -> appendParamCheck.accept("client id " + c));
        request.nodeId().ifPresent(c -> appendParamCheck.accept("node id " + c));
        request.topic().ifPresent(c -> appendParamCheck.accept("topic " + c));
        sb.append(" and the filter matches any metrics");
        return sb.toString();
    }

    private KafkaMetricsRequest buildRequestFromDef(DataSetDef def) {
        if (!(def instanceof KafkaDataSetDef)) {
            throw new IllegalArgumentException("Not a Kafka data set definition");
        }
        KafkaDataSetDef kafkaDef = (KafkaDataSetDef)def;
        if (kafkaDef.getTarget() != KafkaDataSetDef.MetricsTarget.BROKER && kafkaDef.getClientId() == null) {
            throw new IllegalArgumentException("Client Id is required for producer or consumer metrics");
        }
        return KafkaMetricsRequest.Builder.newBuilder(kafkaDef.getHost(), kafkaDef.getPort()).target(kafkaDef.getTarget()).filter(kafkaDef.getFilter()).clientId(kafkaDef.getClientId()).nodeId(kafkaDef.getNodeId()).topic(kafkaDef.getTopic()).partition(kafkaDef.getPartition()).build();
    }

    /*
     * Exception decompiling
     */
    DataSet toDataSet(List<KafkaMetric> metrics) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ColumnType findValueColumnType(List<KafkaMetric> metrics) {
        if (metrics.stream().allMatch(m -> m.getValue() instanceof Number)) {
            return ColumnType.NUMBER;
        }
        return ColumnType.LABEL;
    }

    public void onDataSetDefStale(DataSetDef def) {
        this.staticDataSetProvider.removeDataSet(def.getUUID());
    }

    public void onDataSetDefModified(DataSetDef olDef, DataSetDef newDef) {
        this.staticDataSetProvider.removeDataSet(olDef.getUUID());
    }

    public void onDataSetDefRemoved(DataSetDef oldDef) {
        this.staticDataSetProvider.removeDataSet(oldDef.getUUID());
    }

    public void onDataSetDefRegistered(DataSetDef newDef) {
    }

    public boolean isDataSetOutdated(DataSetDef def) {
        return true;
    }

    private static /* synthetic */ void lambda$toDataSet$5(DataSet dataSet, Object[] row) {
        dataSet.addValuesAt(dataSet.getRowCount(), row);
    }
}

