/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.contributors.backend.dataset;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetBuilder;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.DataSetGenerator;
import org.dashbuilder.dataset.def.DataColumnDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefFactory;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.dashbuilder.dataset.events.DataSetStaleEvent;
import org.dashbuilder.dataset.impl.BeanDataSetDefBuilderImpl;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.RemoveOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.RepoRemovedFromOrganizationalUnitEvent;
import org.guvnor.structure.repositories.Branch;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.ext.editor.commons.backend.version.VersionRecordService;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.file.Path;
import org.uberfire.workbench.events.ResourceAddedEvent;
import org.uberfire.workbench.events.ResourceBatchChangesEvent;
import org.uberfire.workbench.events.ResourceCopiedEvent;
import org.uberfire.workbench.events.ResourceDeletedEvent;
import org.uberfire.workbench.events.ResourceRenamedEvent;
import org.uberfire.workbench.events.ResourceUpdatedEvent;

@Startup
@ApplicationScoped
public class ContributorsManager
implements DataSetGenerator {
    @Inject
    protected DataSetDefRegistry dataSetDefRegistry;
    @Inject
    protected OrganizationalUnitService organizationalUnitService;
    @Inject
    protected WorkspaceProjectService projectService;
    @Inject
    protected VersionRecordService recordService;
    @Inject
    protected Event<DataSetStaleEvent> dataSetStaleEvent;
    protected Properties authorMappings = new Properties();
    protected DataSetDef dataSetdef = ((BeanDataSetDefBuilderImpl)((BeanDataSetDefBuilderImpl)((BeanDataSetDefBuilderImpl)((BeanDataSetDefBuilderImpl)((BeanDataSetDefBuilderImpl)((BeanDataSetDefBuilderImpl)((BeanDataSetDefBuilderImpl)((BeanDataSetDefBuilderImpl)((BeanDataSetDefBuilderImpl)DataSetDefFactory.newBeanDataSetDef().uuid("gitContributors")).name("GIT Contributors")).generatorClass(ContributorsManager.class.getName()).label("organization")).label("repository")).label("branch")).label("project")).label("author")).text("message")).date("date")).buildDef();
    private DataSet dataSet;
    private Set<Branch> addedBranches = new HashSet<Branch>();

    @PostConstruct
    protected void init() {
        this.dataSetdef.setPublic(false);
        this.dataSetDefRegistry.registerDataSetDef(this.dataSetdef);
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("author_mappings.properties");
        if (is != null) {
            try {
                this.authorMappings.load(is);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public DataSet buildDataSet(Map<String, String> params) {
        if (this.dataSet == null) {
            DataSetBuilder dsBuilder = DataSetFactory.newDataSetBuilder();
            for (DataColumnDef columnDef : this.dataSetdef.getColumns()) {
                dsBuilder.column(columnDef.getId(), columnDef.getColumnType());
            }
            this.dataSet = dsBuilder.buildDataSet();
            this.dataSet.setUUID("gitContributors");
        }
        return this.dataSet;
    }

    private void addProject(WorkspaceProject workspaceProject) {
        List orgUnitList = this.organizationalUnitService.getOrganizationalUnits(workspaceProject.getRepository());
        for (OrganizationalUnit orgUnit : orgUnitList) {
            this.addProject(Optional.of(workspaceProject), orgUnit);
        }
    }

    private void addProject(Optional<WorkspaceProject> workspaceProject, OrganizationalUnit orgUnit) {
        Collection projects = this.projectService.getAllWorkspaceProjects(orgUnit);
        if (projects.isEmpty()) {
            this.getDataSet().addValues(new Object[]{orgUnit.getName(), null, null, null, null, null, null});
        } else {
            for (WorkspaceProject project : projects) {
                Collection branches = project.getRepository().getBranches();
                if (!workspaceProject.isPresent()) {
                    for (Branch branch : branches) {
                        this.addBranch(orgUnit.getName(), project.getRepository().getAlias(), project.getName(), branch);
                    }
                    continue;
                }
                if (!branches.contains(workspaceProject.get().getBranch())) continue;
                this.addBranch(orgUnit.getName(), project.getRepository().getAlias(), project.getName(), workspaceProject.get().getBranch());
            }
        }
    }

    private void addBranch(String org, String repoAlias, String projectName, Branch branch) {
        if (!this.addedBranches.contains(branch)) {
            this.addedBranches.add(branch);
            org.uberfire.backend.vfs.Path rootPath = branch.getPath();
            Path projectRoot = Paths.convert((org.uberfire.backend.vfs.Path)rootPath);
            List recordList = this.recordService.loadVersionRecords(projectRoot);
            if (recordList.isEmpty()) {
                this.getDataSet().addValues(new Object[]{org, repoAlias, branch.getName(), null, null, "Empty project", null});
            } else {
                for (VersionRecord record : recordList) {
                    String alias = record.author();
                    String author = this.authorMappings.getProperty(alias);
                    author = author == null ? alias : author;
                    String msg = record.comment();
                    Date date = record.date();
                    this.getDataSet().addValues(new Object[]{org, repoAlias, branch.getName(), projectName, author, msg, date});
                }
            }
        }
        this.dataSetStaleEvent.fire((Object)new DataSetStaleEvent(this.dataSetdef));
    }

    private DataSet getDataSet() {
        return this.buildDataSet(Collections.emptyMap());
    }

    protected void invalidateDataSet() {
        this.addedBranches.clear();
        this.dataSet = null;
        this.buildDataSet(Collections.emptyMap());
        this.dataSetStaleEvent.fire((Object)new DataSetStaleEvent(this.dataSetdef));
    }

    public void onUpdate(WorkspaceProject workspaceProject) {
        this.addProject(workspaceProject);
    }

    public void onUpdate(OrganizationalUnit organizationalUnit) {
        this.addProject(Optional.empty(), organizationalUnit);
    }

    public void onRepoRemovedFromOrgUnit(@Observes RepoRemovedFromOrganizationalUnitEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        this.invalidateDataSet();
    }

    public void onOrganizationUnitRemoved(@Observes RemoveOrganizationalUnitEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        this.invalidateDataSet();
    }

    public void processResourceAdd(@Observes ResourceAddedEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        this.invalidateDataSet();
    }

    public void processResourceDelete(@Observes ResourceDeletedEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        this.invalidateDataSet();
    }

    public void processResourceUpdate(@Observes ResourceUpdatedEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        this.invalidateDataSet();
    }

    public void processResourceCopied(@Observes ResourceCopiedEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        this.invalidateDataSet();
    }

    public void processResourceRenamed(@Observes ResourceRenamedEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        this.invalidateDataSet();
    }

    public void processBatchChanges(@Observes ResourceBatchChangesEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        this.invalidateDataSet();
    }
}

