/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.rule.violations;

import java.util.Optional;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.NonPortable;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.rule.violations.AbstractRuleViolation;

@Portable
public class EmptyConnectionViolation
extends AbstractRuleViolation {
    private final String sourceUUID;
    private final String targetUUID;

    public EmptyConnectionViolation(@MapsTo(value="sourceUUID") String sourceUUID, @MapsTo(value="targetUUID") String targetUUID) {
        this.sourceUUID = sourceUUID;
        this.targetUUID = targetUUID;
    }

    public Optional<Object[]> getArguments() {
        return this.of(this.getUUID(), this.sourceUUID, this.targetUUID);
    }

    @Override
    public String getMessage() {
        return "Empty Connection [connector=" + this.getUUID() + "[source=" + this.sourceUUID + "[target=" + this.targetUUID + "]";
    }

    @NonPortable
    public static class Builder {
        public static EmptyConnectionViolation build(Edge<? extends View<?>, ? extends Node> connector, Optional<Node<? extends View<?>, ? extends Edge>> sourceNode, Optional<Node<? extends View<?>, ? extends Edge>> targetNode) {
            String sourceUUID = sourceNode.map(Element::getUUID).orElse(null);
            String targetUUID = targetNode.map(Element::getUUID).orElse(null);
            return (EmptyConnectionViolation)new EmptyConnectionViolation(sourceUUID, targetUUID).setUUID(connector.getUUID());
        }
    }
}

