/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.util;

import org.eclipse.bpmn2.util.Bpmn2ResourceImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;

public class QNameURIHandler
extends URIHandlerImpl {
    private final Bpmn2ResourceImpl.BpmnXmlHelper xmlHelper;

    public QNameURIHandler(Bpmn2ResourceImpl.BpmnXmlHelper xmlHelper) {
        this.xmlHelper = xmlHelper;
    }

    public String convertQNameToUri(String qName) {
        String fragment;
        String prefix;
        if (qName.contains("#") || qName.contains("/")) {
            return qName;
        }
        String[] parts = qName.split(":");
        if (parts.length == 1) {
            prefix = null;
            fragment = qName;
        } else if (parts.length == 2) {
            prefix = parts[0];
            fragment = parts[1];
        } else {
            throw new IllegalArgumentException("Illegal QName: " + qName);
        }
        if (fragment.contains(".")) {
            return qName;
        }
        if (!this.xmlHelper.isTargetNamespace(prefix)) {
            return this.xmlHelper.getPathForPrefix(prefix).appendFragment(fragment).toString();
        }
        return this.baseURI.appendFragment(fragment).toString();
    }

    public URI resolve(URI uri) {
        return super.resolve(URI.createURI((String)this.convertQNameToUri(uri.toString())));
    }

    public URI deresolve(URI uri) {
        String fragment = uri.fragment();
        if (fragment != null && !fragment.startsWith("/")) {
            String prefix = "";
            if (uri.hasPath()) {
                prefix = this.xmlHelper.getNsPrefix(uri.trimFragment());
            }
            if (prefix.length() > 0) {
                return URI.createURI((String)(String.valueOf(prefix) + ":" + fragment));
            }
            return URI.createURI((String)fragment);
        }
        return super.deresolve(uri);
    }
}

