/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.engine.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dashbuilder.dataset.engine.index.DataSetFilterIndex;
import org.dashbuilder.dataset.engine.index.DataSetFunctionIndex;
import org.dashbuilder.dataset.engine.index.DataSetGroupIndex;
import org.dashbuilder.dataset.engine.index.DataSetIndexElement;
import org.dashbuilder.dataset.engine.index.DataSetSortIndex;
import org.dashbuilder.dataset.engine.index.visitor.DataSetIndexVisitor;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.impl.MemSizeEstimator;
import org.dashbuilder.dataset.sort.DataSetSort;

public abstract class DataSetIndexNode
extends DataSetIndexElement {
    DataSetIndexNode parent = null;
    List<Integer> rows = null;
    List<DataSetGroupIndex> groupIndexes = null;
    List<DataSetSortIndex> sortIndexes = null;
    List<DataSetFilterIndex> filterIndexes = null;
    Map<String, Map<AggregateFunctionType, DataSetFunctionIndex>> functionIndexes = null;

    public DataSetIndexNode() {
        this(null, null, 0L);
    }

    public DataSetIndexNode(DataSetIndexNode parent, List<Integer> rows, long buildTime) {
        super(buildTime);
        this.parent = parent;
        this.rows = rows;
    }

    public DataSetIndexNode getParent() {
        return this.parent;
    }

    public void setParent(DataSetIndexNode parent) {
        this.parent = parent;
    }

    public List<Integer> getRows() {
        return this.rows;
    }

    @Override
    public long getEstimatedSize() {
        long result = super.getEstimatedSize();
        if (this.rows != null) {
            result += (long)(this.rows.size() * MemSizeEstimator.sizeOfInteger);
        }
        return result;
    }

    @Override
    public void acceptVisitor(DataSetIndexVisitor visitor) {
        super.acceptVisitor(visitor);
        if (this.groupIndexes != null) {
            for (DataSetGroupIndex dataSetGroupIndex : this.groupIndexes) {
                dataSetGroupIndex.acceptVisitor(visitor);
            }
        }
        if (this.filterIndexes != null) {
            for (DataSetFilterIndex dataSetFilterIndex : this.filterIndexes) {
                dataSetFilterIndex.acceptVisitor(visitor);
            }
        }
        if (this.sortIndexes != null) {
            for (DataSetSortIndex dataSetSortIndex : this.sortIndexes) {
                dataSetSortIndex.acceptVisitor(visitor);
            }
        }
        if (this.functionIndexes != null) {
            for (Map map : this.functionIndexes.values()) {
                for (DataSetFunctionIndex index : map.values()) {
                    index.acceptVisitor(visitor);
                }
            }
        }
    }

    public DataSetFunctionIndex indexAggValue(String columnId, AggregateFunctionType type, Object value, long buildTime) {
        Map<AggregateFunctionType, DataSetFunctionIndex> columnAggFunctions;
        if (this.functionIndexes == null) {
            this.functionIndexes = new HashMap<String, Map<AggregateFunctionType, DataSetFunctionIndex>>();
        }
        if ((columnAggFunctions = this.functionIndexes.get(columnId)) == null) {
            columnAggFunctions = new EnumMap<AggregateFunctionType, DataSetFunctionIndex>(AggregateFunctionType.class);
            this.functionIndexes.put(columnId, columnAggFunctions);
        }
        DataSetFunctionIndex index = new DataSetFunctionIndex(value, buildTime);
        columnAggFunctions.put(type, index);
        return index;
    }

    public Object getAggValue(String columnId, AggregateFunctionType type) {
        if (this.functionIndexes == null) {
            return null;
        }
        Map<AggregateFunctionType, DataSetFunctionIndex> columnAggFunctions = this.functionIndexes.get(columnId);
        if (columnAggFunctions == null) {
            return null;
        }
        DataSetFunctionIndex functionIndex = columnAggFunctions.get(type);
        if (functionIndex == null) {
            return null;
        }
        functionIndex.reuseHit();
        return functionIndex.getValue();
    }

    public DataSetGroupIndex indexGroup(DataSetGroupIndex index) {
        if (this.groupIndexes == null) {
            this.groupIndexes = new ArrayList<DataSetGroupIndex>();
        }
        index.setParent(this);
        index.setBuildTime(this.buildTime);
        this.groupIndexes.add(index);
        return index;
    }

    public DataSetGroupIndex getGroupIndex(ColumnGroup gc) {
        if (this.groupIndexes == null) {
            return null;
        }
        String key = this.getGroupKey(gc);
        for (DataSetGroupIndex groupIndex : this.groupIndexes) {
            ColumnGroup c = groupIndex.columnGroup;
            if (!key.equals(this.getGroupKey(c))) continue;
            groupIndex.reuseHit();
            return groupIndex;
        }
        return null;
    }

    public String getGroupKey(ColumnGroup columnGroup) {
        return columnGroup.getSourceId() + "_" + columnGroup.getStrategy().toString() + "_" + columnGroup.getIntervalSize() + "_" + columnGroup.getMaxIntervals() + "_" + columnGroup.areEmptyIntervalsAllowed() + "_" + columnGroup.isAscendingOrder() + (columnGroup.getFirstMonthOfYear() != null ? "_" + columnGroup.getFirstMonthOfYear() : "") + (columnGroup.getFirstDayOfWeek() != null ? "_" + columnGroup.getFirstDayOfWeek() : "");
    }

    public DataSetFilterIndex indexFilter(ColumnFilter filter, List<Integer> rows, long buildTime) {
        if (this.filterIndexes == null) {
            this.filterIndexes = new ArrayList<DataSetFilterIndex>();
        }
        DataSetFilterIndex index = new DataSetFilterIndex(filter, rows);
        index.setParent(this);
        index.setBuildTime(buildTime);
        this.filterIndexes.add(index);
        return index;
    }

    public DataSetFilterIndex getFilterIndex(ColumnFilter filter) {
        if (this.filterIndexes == null) {
            return null;
        }
        for (DataSetFilterIndex index : this.filterIndexes) {
            if (!filter.equals((Object)index.getColumnFilter())) continue;
            index.reuseHit();
            return index;
        }
        return null;
    }

    public DataSetSortIndex indexSort(DataSetSort sortOp, List<Integer> sortedRows, long buildTime) {
        if (this.sortIndexes == null) {
            this.sortIndexes = new ArrayList<DataSetSortIndex>();
        }
        DataSetSortIndex index = new DataSetSortIndex(sortOp, sortedRows);
        index.setParent(this);
        index.setBuildTime(buildTime);
        this.sortIndexes.add(index);
        DataSetSort invertedSortOp = sortOp.cloneInstance().invertOrder();
        ArrayList<Integer> invertedRows = new ArrayList<Integer>(sortedRows);
        Collections.reverse(invertedRows);
        DataSetSortIndex invertedIndex = new DataSetSortIndex(invertedSortOp, invertedRows);
        invertedIndex.setParent(this);
        this.sortIndexes.add(invertedIndex);
        return index;
    }

    public DataSetSortIndex getSortIndex(DataSetSort sortOp) {
        if (this.sortIndexes == null) {
            return null;
        }
        for (DataSetSortIndex sortIndex : this.sortIndexes) {
            if (!sortOp.equals((Object)sortIndex.getSortOp())) continue;
            sortIndex.reuseHit();
            return sortIndex;
        }
        return null;
    }
}

