/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.processes;

import java.util.AbstractMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.bpmn2.Process;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.ConverterFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.DefinitionsBuildingContext;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.FlowElementConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.lanes.LaneConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.processes.RootProcessConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.processes.SubProcessConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.ProcessPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.PropertyWriterFactory;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNDiagramImpl;
import org.kie.workbench.common.stunner.bpmn.definition.property.cm.CaseFileVariables;
import org.kie.workbench.common.stunner.bpmn.definition.property.cm.CaseIdPrefix;
import org.kie.workbench.common.stunner.bpmn.definition.property.cm.CaseManagementSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.cm.CaseRoles;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.DiagramSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.GlobalVariables;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.imports.DefaultImport;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.SLADueDate;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RootProcessConverterTest {
    private RootProcessConverter converter;
    private DefinitionsBuildingContext context;
    @Mock
    private PropertyWriterFactory propertyWriterFactory;
    @Mock
    private ConverterFactory converterFactory;
    @Mock
    private Node node;
    @Mock
    private Definition<BPMNDiagramImpl> content;
    private BPMNDiagramImpl diagram;
    @Mock
    private CaseManagementSet caseManagementSet;
    @Mock
    private CaseRoles caseRoles;
    @Mock
    private CaseFileVariables caseFileVariables;
    @Mock
    private ProcessPropertyWriter processPropertyWriter;
    @Mock
    private SubProcessConverter subProcessConverter;
    @Mock
    private FlowElementConverter viewDefinitionConverter;
    @Mock
    private LaneConverter laneConverter;
    @Mock
    private CaseIdPrefix caseIdPrefix;

    @Before
    public void setUp() throws Exception {
        this.diagram = new BPMNDiagramImpl();
        this.diagram.setDiagramSet(new DiagramSet());
        this.diagram.setCaseManagementSet(this.caseManagementSet);
        this.context = new DefinitionsBuildingContext(this.node, Stream.of(new AbstractMap.SimpleEntry<String, Node>("uuid", this.node)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).withRootNode(this.node);
        this.converter = new RootProcessConverter(this.context, this.propertyWriterFactory, this.converterFactory);
        Mockito.when((Object)this.propertyWriterFactory.of((Process)ArgumentMatchers.any(Process.class))).thenReturn((Object)this.processPropertyWriter);
        Mockito.when((Object)this.node.getContent()).thenReturn(this.content);
        Mockito.when((Object)((BPMNDiagramImpl)this.content.getDefinition())).thenReturn((Object)this.diagram);
        Mockito.when((Object)this.caseManagementSet.getCaseIdPrefix()).thenReturn((Object)this.caseIdPrefix);
        Mockito.when((Object)this.caseManagementSet.getCaseRoles()).thenReturn((Object)this.caseRoles);
        Mockito.when((Object)this.caseManagementSet.getCaseFileVariables()).thenReturn((Object)this.caseFileVariables);
        Mockito.when((Object)this.converterFactory.subProcessConverter()).thenReturn((Object)this.subProcessConverter);
        Mockito.when((Object)this.converterFactory.viewDefinitionConverter()).thenReturn((Object)this.viewDefinitionConverter);
        Mockito.when((Object)this.converterFactory.laneConverter()).thenReturn((Object)this.laneConverter);
    }

    @Test
    public void convertProcessWithCaseProperties() {
        ProcessPropertyWriter propertyWriter = this.converter.convertProcess();
        ((ProcessPropertyWriter)Mockito.verify((Object)propertyWriter)).setCaseIdPrefix(this.caseIdPrefix);
        ((ProcessPropertyWriter)Mockito.verify((Object)propertyWriter)).setCaseRoles(this.caseRoles);
        ((ProcessPropertyWriter)Mockito.verify((Object)propertyWriter)).setCaseFileVariables(this.caseFileVariables);
    }

    @Test
    public void convertProcessWithExecutable() {
        ProcessPropertyWriter propertyWriter = this.converter.convertProcess();
        ((ProcessPropertyWriter)Mockito.verify((Object)propertyWriter)).setExecutable(Boolean.valueOf(ArgumentMatchers.anyBoolean()));
    }

    @Test
    public void convertProcessWithGlobalVariables() {
        ProcessPropertyWriter propertyWriter = this.converter.convertProcess();
        ((ProcessPropertyWriter)Mockito.verify((Object)propertyWriter)).setGlobalVariables((GlobalVariables)ArgumentMatchers.any(GlobalVariables.class));
    }

    @Test
    public void convertProcessWithImports() {
        ProcessPropertyWriter propertyWriter = this.converter.convertProcess();
        ((ProcessPropertyWriter)Mockito.verify((Object)propertyWriter)).setDefaultImports(ArgumentMatchers.anyListOf(DefaultImport.class));
    }

    @Test
    public void convertProcessWithSlaDueDate() {
        ProcessPropertyWriter propertyWriter = this.converter.convertProcess();
        ((ProcessPropertyWriter)Mockito.verify((Object)propertyWriter)).setSlaDueDate((SLADueDate)ArgumentMatchers.any(SLADueDate.class));
    }
}

