/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.subprocesses;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.BPMNDiagramMarshallerBaseTest;
import org.kie.workbench.common.stunner.bpmn.definition.BaseSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;

public abstract class SubProcessTest<T extends BaseSubprocess>
extends BPMNDiagramMarshallerBaseTest {
    static final String DEFAULT_NAME = "";
    static final String DEFAULT_DOCUMENTATION = "";
    static final String EMPTY_VALUE = "";
    static final int EMPTY_INCOME_EDGES = 1;
    static final int EMPTY_OUTCOME_EDGES = 0;
    static final int ONE_INCOME_EDGE = 2;
    static final int TWO_OUTCOME_EDGES = 2;
    static final int FOUR_OUTCOME_EDGES = 4;
    static final boolean IS_ASYNC = true;
    static final boolean IS_NOT_ASYNC = false;
    private Diagram<Graph, Metadata> diagram;
    private Diagram<Graph, Metadata> roundTripDiagram;

    public Diagram<Graph, Metadata> getDiagram() {
        return this.diagram;
    }

    public void setDiagram(Diagram<Graph, Metadata> diagram) {
        this.diagram = diagram;
    }

    public Diagram<Graph, Metadata> getRoundTripDiagram() {
        return this.roundTripDiagram;
    }

    public void setRoundTripDiagram(Diagram<Graph, Metadata> diagram) {
        this.roundTripDiagram = diagram;
    }

    SubProcessTest() throws Exception {
        this.marshallDiagramWithNewMarshaller();
    }

    private void marshallDiagramWithNewMarshaller() throws Exception {
        this.setDiagram(this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, this.getBpmnSubProcessFilePath()));
        this.setRoundTripDiagram(this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, this.getStream(this.marshaller.marshall(this.getDiagram()))));
    }

    @Test
    public void testMarshallTopLevelEmptyPropertiesSubProcess() {
        this.checkSubProcessMarshalling(this.getTopLevelEmptyPropertiesSubProcessId(), 1, 0);
    }

    @Test
    public void testMarshallTopLevelFilledPropertiesSubProcess() {
        for (String subProcessId : this.getTopLevelFilledPropertiesSubProcessesIds()) {
            this.checkSubProcessMarshalling(subProcessId, 1, 0);
        }
    }

    @Test
    public void testMarshallTopLevelSubProcessWithEdges() {
        this.checkSubProcessMarshalling(this.getTopLevelSubProcessWithEdgesId(), 2, 4);
    }

    @Test
    public void testMarshallSubProcessLevelEmptyPropertiesSubProcess() {
        this.checkSubProcessMarshalling(this.getSubProcessLevelEmptyPropertiesSubProcessId(), 1, 0);
    }

    @Test
    public void testMarshallSubProcessLevelFilledPropertiesSubProcess() {
        for (String subProcessId : this.getSubProcessLevelFilledPropertiesSubProcessesIds()) {
            this.checkSubProcessMarshalling(subProcessId, 1, 0);
        }
    }

    @Test
    public void testMarshallSubProcessLevelSubProcessWithEdges() {
        this.checkSubProcessMarshalling(this.getSubProcessLevelSubProcessWithEdgesId(), 2, 4);
    }

    @Test
    public abstract void testUnmarshallTopLevelEmptyPropertiesSubProcess() throws Exception;

    @Test
    public abstract void testUnmarshallTopLevelFilledPropertiesSubProcess() throws Exception;

    @Test
    public abstract void testUnmarshallTopLevelSubProcessWithEdges() throws Exception;

    @Test
    public abstract void testUnmarshallSubProcessLevelEmptyPropertiesSubProcess() throws Exception;

    @Test
    public abstract void testUnmarshallSubProcessLevelFilledPropertiesSubProcess() throws Exception;

    @Test
    public abstract void testUnmarshallSubProcessLevelSubProcessWithEdges() throws Exception;

    abstract Class<T> getSubProcessType();

    abstract String getBpmnSubProcessFilePath();

    abstract String getTopLevelEmptyPropertiesSubProcessId();

    abstract String[] getTopLevelFilledPropertiesSubProcessesIds();

    abstract String getTopLevelSubProcessWithEdgesId();

    abstract String getSubProcessLevelEmptyPropertiesSubProcessId();

    abstract String[] getSubProcessLevelFilledPropertiesSubProcessesIds();

    abstract String getSubProcessLevelSubProcessWithEdgesId();

    private void assertNodesEqualsAfterMarshalling(Diagram<Graph, Metadata> before, Diagram<Graph, Metadata> after, String nodeId, int incomeEdges, int outcomeEdges) {
        T nodeBeforeMarshalling = this.getSubProcessNodeById(before, nodeId, incomeEdges, outcomeEdges);
        T nodeAfterMarshalling = this.getSubProcessNodeById(after, nodeId, incomeEdges, outcomeEdges);
        Assertions.assertThat(nodeAfterMarshalling).isEqualTo(nodeBeforeMarshalling);
    }

    protected Diagram<Graph, Metadata> getSpecificDiagram(String fileName) throws Exception {
        return this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, fileName);
    }

    T getSubProcessNodeById(Diagram<Graph, Metadata> diagram, String id, int incomeEdges, int outcomeEdges) {
        Node<Definition, ?> node = this.getNodebyId(diagram, id, incomeEdges, outcomeEdges);
        return (T)((BaseSubprocess)this.getSubProcessType().cast(((Definition)node.getContent()).getDefinition()));
    }

    private Node<? extends Definition, ?> getNodebyId(Diagram<Graph, Metadata> diagram, String id, int incomeEdges, int outcomeEdges) {
        Node node = diagram.getGraph().getNode(id);
        Assertions.assertThat((Object)node).isNotNull();
        Assertions.assertThat((List)node.getInEdges()).hasSize(incomeEdges);
        Assertions.assertThat((List)node.getOutEdges()).hasSize(outcomeEdges);
        return node;
    }

    void checkSubProcessMarshalling(String nodeID, int incomeEdges, int outcomeEdges) {
        Diagram<Graph, Metadata> initialDiagram = this.getDiagram();
        int AMOUNT_OF_NODES_IN_DIAGRAM = this.getNodes(initialDiagram).size();
        Diagram<Graph, Metadata> marshalledDiagram = this.getRoundTripDiagram();
        this.assertDiagram(marshalledDiagram, AMOUNT_OF_NODES_IN_DIAGRAM);
        this.assertNodesEqualsAfterMarshalling(initialDiagram, marshalledDiagram, nodeID, incomeEdges, outcomeEdges);
    }

    void assertGeneralSet(BPMNGeneralSet generalSet, String nodeName, String documentation) {
        Assertions.assertThat((Object)generalSet).isNotNull();
        Assertions.assertThat((Object)generalSet.getName()).isNotNull();
        Assertions.assertThat((Object)generalSet.getDocumentation()).isNotNull();
        Assertions.assertThat((String)generalSet.getName().getValue()).isEqualTo(nodeName);
        Assertions.assertThat((String)generalSet.getDocumentation().getValue()).isEqualTo(documentation);
    }

    void assertSubProcessProcessData(ProcessData processData, String variableValue) {
        Assertions.assertThat((Object)processData).isNotNull();
        Assertions.assertThat((Object)processData.getProcessVariables()).isNotNull();
        Assertions.assertThat((String)processData.getProcessVariables().getValue()).isEqualTo(variableValue);
    }
}

