/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.common.rest;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.core.MediaType;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.kie.server.api.rest.RestURI;
import org.kie.server.common.rest.Base64Util;
import org.kie.server.common.rest.ClientCertificate;
import org.kie.server.common.rest.KieServerHttpRequestException;
import org.kie.server.common.rest.KieServerHttpResponse;

public class KieServerHttpRequest {
    public static final String CHARSET_UTF8 = "UTF-8";
    public static final String HEADER_PROXY_AUTHORIZATION = "Proxy-Authorization";
    public static final String HEADER_REFERER = "Referer";
    public static final String HEADER_SERVER = "Server";
    public static final String PARAM_CHARSET = "charset";
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final String IDENTITY_KEYSTORE_TYPE = "jks";
    private static final int DEFAULT_TIMEOUT_SECS = 5;
    private RequestInfo requestInfo;
    private int bufferSize = 8192;
    private boolean ignoreCloseExceptions = true;
    boolean uncompress = false;
    private HttpURLConnection connection = null;
    private RequestOutputStream output;
    boolean followRedirects = false;
    String httpProxyHost;
    int httpProxyPort;
    private KieServerHttpResponse response = null;
    private static ConnectionFactory CONNECTION_FACTORY = ConnectionFactory.DEFAULT;
    private static SSLSocketFactory TRUSTED_FACTORY;
    private static HostnameVerifier TRUSTED_VERIFIER;

    private RequestInfo getRequestInfo() {
        if (this.requestInfo == null) {
            this.requestInfo = new RequestInfo();
        }
        return this.requestInfo;
    }

    private static String getValidCharset(String charset) {
        if (charset != null && charset.length() > 0) {
            return charset;
        }
        return CHARSET_UTF8;
    }

    private static StringBuilder addPathSeparator(String baseUrl, StringBuilder result) {
        if (baseUrl.indexOf(58) + 2 == baseUrl.lastIndexOf(47)) {
            result.append('/');
        }
        return result;
    }

    private static StringBuilder addParamPrefix(String baseUrl, StringBuilder result) {
        int queryStart = baseUrl.indexOf(63);
        int lastChar = result.length() - 1;
        if (queryStart == -1) {
            result.append('?');
        } else if (queryStart < lastChar && baseUrl.charAt(lastChar) != '&') {
            result.append('&');
        }
        return result;
    }

    static String appendQueryParameters(CharSequence url, Map<?, ?> params) {
        String baseUrl = url.toString();
        if (params == null || params.isEmpty()) {
            return baseUrl;
        }
        StringBuilder result = new StringBuilder(baseUrl);
        KieServerHttpRequest.addPathSeparator(baseUrl, result);
        KieServerHttpRequest.addParamPrefix(baseUrl, result);
        Iterator<Map.Entry<?, ?>> iterator = params.entrySet().iterator();
        Map.Entry<?, ?> entry = iterator.next();
        result.append(entry.getKey().toString());
        result.append('=');
        KieServerHttpRequest.appendValue(result, entry.getValue());
        while (iterator.hasNext()) {
            result.append('&');
            entry = iterator.next();
            result.append(entry.getKey().toString());
            result.append('=');
            KieServerHttpRequest.appendValue(result, entry.getValue());
        }
        return result.toString();
    }

    static String appendQueryParameters(CharSequence url, Object ... params) {
        String baseUrl = url.toString();
        if (params == null || params.length == 0) {
            return baseUrl;
        }
        if (params.length % 2 != 0) {
            throw new IllegalArgumentException("Must specify an even number of parameter names/values");
        }
        StringBuilder result = new StringBuilder(baseUrl);
        KieServerHttpRequest.addPathSeparator(baseUrl, result);
        KieServerHttpRequest.addParamPrefix(baseUrl, result);
        result.append(params[0]);
        result.append('=');
        KieServerHttpRequest.appendValue(result, params[1]);
        for (int i = 2; i < params.length; i += 2) {
            result.append('&');
            result.append(params[i]);
            result.append('=');
            KieServerHttpRequest.appendValue(result, params[i + 1]);
        }
        return result.toString();
    }

    private static void appendValue(StringBuilder result, Object value) {
        if (value != null) {
            result.append(RestURI.encode((Object)value));
        }
    }

    public static void setKeepAlive(boolean keepAlive) {
        KieServerHttpRequest.setProperty("http.keepAlive", Boolean.toString(keepAlive));
    }

    public static void setMaxConnections(int maxConnections) {
        KieServerHttpRequest.setProperty("http.maxConnections", Integer.toString(maxConnections));
    }

    private static String setProperty(final String name, final String value) {
        PrivilegedAction<String> action = value != null ? new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.setProperty(name, value);
            }
        } : new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.clearProperty(name);
            }
        };
        return AccessController.doPrivileged(action);
    }

    public static KieServerHttpRequest deleteRequest(URL url) throws KieServerHttpRequestException {
        KieServerHttpRequest request = new KieServerHttpRequest(url);
        request.getRequestInfo().requestMethod = "DELETE";
        return request;
    }

    public static KieServerHttpRequest putRequest(URL url) throws KieServerHttpRequestException {
        KieServerHttpRequest request = new KieServerHttpRequest(url);
        request.getRequestInfo().requestMethod = "PUT";
        return request;
    }

    public static KieServerHttpRequest getRequest(String urlString) throws KieServerHttpRequestException {
        KieServerHttpRequest request = new KieServerHttpRequest(urlString);
        request.getRequestInfo().requestMethod = "GET";
        return request;
    }

    public static KieServerHttpRequest getRequest(URL url) throws KieServerHttpRequestException {
        KieServerHttpRequest request = new KieServerHttpRequest(url);
        request.getRequestInfo().requestMethod = "GET";
        return request;
    }

    public static KieServerHttpRequest postRequest(URL url) throws KieServerHttpRequestException {
        KieServerHttpRequest request = new KieServerHttpRequest(url);
        request.getRequestInfo().requestMethod = "POST";
        return request;
    }

    public static KieServerHttpRequest newRequest(String url) throws KieServerHttpRequestException {
        return new KieServerHttpRequest(url);
    }

    public static KieServerHttpRequest newRequest(URL url) throws KieServerHttpRequestException {
        return new KieServerHttpRequest(url);
    }

    public static KieServerHttpRequest newRequest(String url, String username, String password) throws KieServerHttpRequestException {
        return new KieServerHttpRequest(url, username, password);
    }

    public static KieServerHttpRequest newRequest(URL url, String username, String password) throws KieServerHttpRequestException {
        return new KieServerHttpRequest(url, username, password);
    }

    private KieServerHttpRequest(URL url) throws KieServerHttpRequestException {
        this.getRequestInfo().baseUrl = url;
    }

    private KieServerHttpRequest(String urlString) throws KieServerHttpRequestException {
        this.getRequestInfo().baseUrl = KieServerHttpRequest.convertStringToUrl(urlString);
    }

    private static URL convertStringToUrl(String urlString) throws KieServerHttpRequestException {
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new KieServerHttpRequestException("Unable to create request with url '" + urlString + "'", e);
        }
    }

    private KieServerHttpRequest(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    private KieServerHttpRequest(URL stringUrl, String username, String password) {
        RequestInfo requestInfo = this.getRequestInfo();
        requestInfo.baseUrl = stringUrl;
        requestInfo.user = username;
        requestInfo.password = password;
    }

    private KieServerHttpRequest(String stringUrl, String username, String password) {
        this(stringUrl);
        RequestInfo requestInfo = this.getRequestInfo();
        requestInfo.user = username;
        requestInfo.password = password;
    }

    public KieServerHttpRequest get(String relativeUrl) throws KieServerHttpRequestException {
        this.relativeRequest(relativeUrl, "GET");
        this.responseCode();
        return this;
    }

    public KieServerHttpRequest get() throws KieServerHttpRequestException {
        this.getRequestInfo().requestMethod = "GET";
        this.responseCode();
        return this;
    }

    public KieServerHttpRequest post(String relativeUrl) throws KieServerHttpRequestException {
        this.relativeRequest(relativeUrl, "POST");
        this.responseCode();
        return this;
    }

    public KieServerHttpRequest post() throws KieServerHttpRequestException {
        this.getRequestInfo().requestMethod = "POST";
        this.responseCode();
        return this;
    }

    public KieServerHttpRequest put(String relativeUrl) throws KieServerHttpRequestException {
        this.relativeRequest(relativeUrl, "PUT");
        this.responseCode();
        return this;
    }

    public KieServerHttpRequest put() throws KieServerHttpRequestException {
        this.getRequestInfo().requestMethod = "PUT";
        this.responseCode();
        return this;
    }

    public KieServerHttpRequest delete(String relativeUrl) throws KieServerHttpRequestException {
        this.relativeRequest(relativeUrl, "DELETE");
        this.responseCode();
        return this;
    }

    public KieServerHttpRequest delete() throws KieServerHttpRequestException {
        this.getRequestInfo().requestMethod = "DELETE";
        this.responseCode();
        return this;
    }

    private KieServerHttpRequest copy(final InputStream input, final OutputStream output) throws IOException {
        return (KieServerHttpRequest)new CloseOperation<KieServerHttpRequest>((Closeable)input, this.ignoreCloseExceptions){

            @Override
            public KieServerHttpRequest run() throws IOException {
                int read;
                byte[] buffer = new byte[KieServerHttpRequest.this.bufferSize];
                while ((read = input.read(buffer)) != -1) {
                    output.write(buffer, 0, read);
                }
                return KieServerHttpRequest.this;
            }
        }.call();
    }

    public KieServerHttpRequest ignoreCloseExceptions(boolean ignore) {
        this.ignoreCloseExceptions = ignore;
        return this;
    }

    public boolean ignoreCloseExceptions() {
        return this.ignoreCloseExceptions;
    }

    public KieServerHttpRequest bufferSize(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("Size must be greater than zero");
        }
        this.bufferSize = size;
        return this;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public KieServerHttpRequest setUncompress(boolean uncompress) {
        this.uncompress = uncompress;
        return this;
    }

    public KieServerHttpRequest followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public URI getUri() {
        try {
            return this.getRequestInfo().getRequestUrl().toURI();
        }
        catch (URISyntaxException urise) {
            throw new KieServerHttpRequestException("Invalid request URL", urise);
        }
    }

    public KieServerHttpRequest timeout(long timeoutInMilliseconds) {
        if (this.connection != null) {
            this.connection.setReadTimeout((int)timeoutInMilliseconds);
        } else {
            this.getRequestInfo().timeoutInMilliSecs = (int)timeoutInMilliseconds;
        }
        return this;
    }

    private void setRequestUrl(String urlString) {
        this.getRequestInfo().setRequestUrl(urlString);
    }

    private HttpURLConnection createConnection() {
        String urlString = this.getRequestInfo().getRequestUrl().toString();
        if (this.getRequestInfo().requestMethod == null) {
            throw new KieServerHttpRequestException("Please specify (and execute?) a HTTP method first.");
        }
        try {
            HttpURLConnection connection;
            if (this.httpProxyHost != null) {
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.httpProxyHost, this.httpProxyPort));
                connection = CONNECTION_FACTORY.create(this.getRequestInfo().getRequestUrl(), proxy);
            } else {
                connection = CONNECTION_FACTORY.create(this.getRequestInfo().getRequestUrl());
            }
            if (this.getRequestInfo().getRequestUrl().getProtocol().equalsIgnoreCase("https") && this.getRequestInfo().getRequestUrl().getHost().equalsIgnoreCase("localhost")) {
                ((HttpsURLConnection)connection).setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession sslSession) {
                        return hostname.equalsIgnoreCase("localhost");
                    }
                });
            }
            if (this.getRequestInfo().clientCertificate != null) {
                ClientCertificate clientCertificate = this.getRequestInfo().clientCertificate;
                try {
                    KeyStore identityKeyStore = KeyStore.getInstance(IDENTITY_KEYSTORE_TYPE);
                    identityKeyStore.load(new FileInputStream(clientCertificate.getKeystore()), clientCertificate.getKeystorePassword().toCharArray());
                    SSLContextBuilder contextBuilder = SSLContexts.custom().loadKeyMaterial(identityKeyStore, clientCertificate.getCertPassword().toCharArray(), (map, socket) -> clientCertificate.getCertName());
                    if (clientCertificate.getTruststore() != null) {
                        KeyStore trustStore = KeyStore.getInstance(IDENTITY_KEYSTORE_TYPE);
                        trustStore.load(new FileInputStream(clientCertificate.getTruststore()), clientCertificate.getTruststorePassword().toCharArray());
                        contextBuilder.loadTrustMaterial(trustStore, null);
                    }
                    SSLSocketFactory socketFactory = contextBuilder.build().getSocketFactory();
                    ((HttpsURLConnection)connection).setSSLSocketFactory(socketFactory);
                }
                catch (IOException | GeneralSecurityException e) {
                    throw new RuntimeException("Unable to create SSLSocketFactory", e);
                }
            }
            connection.setRequestMethod(this.getRequestInfo().requestMethod);
            return connection;
        }
        catch (IOException ioe) {
            throw new KieServerHttpRequestException("Unable to create (" + this.getRequestInfo().requestMethod + ") connection to '" + urlString + "'", ioe);
        }
    }

    HttpURLConnection getConnection() {
        if (this.getRequestInfo().requestMethod == null) {
            throw new KieServerHttpRequestException("Please set HTTP request method before opening a connection.");
        }
        this.initializeConnection();
        return this.connection;
    }

    private void initializeConnection() {
        if (this.connection == null) {
            this.addQueryParametersToUrl();
            this.connection = this.createConnection();
            this.connection.setReadTimeout(this.getRequestInfo().timeoutInMilliSecs);
            this.connection.setConnectTimeout(this.getRequestInfo().timeoutInMilliSecs);
            RequestInfo requestInfo = this.getRequestInfo();
            int contentLength = 0;
            if (requestInfo.body != null) {
                contentLength = requestInfo.body.toString().getBytes(Charset.forName(CHARSET_UTF8)).length;
                this.connection.setFixedLengthStreamingMode(contentLength);
                List<String> contentTypeList = requestInfo.getHeader("Accept");
                if (contentTypeList != null && !contentTypeList.isEmpty()) {
                    requestInfo.setHeader("Content-Type", contentTypeList.get(0));
                }
            }
            requestInfo.setHeader("Content-Length", contentLength);
            this.connection.setInstanceFollowRedirects(this.followRedirects);
            if (requestInfo.user != null && requestInfo.password != null) {
                this.basicAuthorization(requestInfo.user, requestInfo.password);
            }
            if (requestInfo.headers != null) {
                for (Map.Entry entry : requestInfo.headers.entrySet()) {
                    List headerVals = (List)entry.getValue();
                    for (String val : headerVals) {
                        this.connection.setRequestProperty((String)entry.getKey(), val);
                    }
                }
            }
            this.addFormParametersToConnection();
            if (requestInfo.body != null) {
                try {
                    this.openOutput();
                    this.output.write(requestInfo.body.toString());
                }
                catch (IOException ioe) {
                    throw new KieServerHttpRequestException("Unable to add char sequence to request body", ioe);
                }
            }
        }
    }

    public KieServerHttpRequest relativeRequest(String relativeUrlString, String httpMethod) {
        this.relativeRequest(relativeUrlString);
        this.getRequestInfo().requestMethod = httpMethod;
        return this;
    }

    public KieServerHttpRequest relativeRequest(String relativeUrlString) {
        String baseUrlString = this.getRequestInfo().baseUrl.toExternalForm();
        boolean urlSlash = baseUrlString.endsWith("/");
        boolean postfixSlash = relativeUrlString.startsWith("/");
        String separator = "";
        if (!urlSlash && !postfixSlash) {
            separator = "/";
        } else if (urlSlash && postfixSlash) {
            relativeUrlString = relativeUrlString.substring(1);
        }
        this.setRequestUrl(baseUrlString + separator + relativeUrlString);
        return this;
    }

    public KieServerHttpRequest disconnect() {
        this.getConnection().disconnect();
        return this;
    }

    public KieServerHttpRequest resetStream() throws IOException {
        this.getConnection().getInputStream().reset();
        return this;
    }

    public KieServerHttpRequest followRedirets(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public URL getUrl() {
        return this.getRequestInfo().getRequestUrl();
    }

    public String getMethod() {
        return this.getRequestInfo().requestMethod;
    }

    public String getHeader(String name) {
        List<String> headerVals = this.getRequestInfo().getHeader(name);
        if (headerVals != null && !headerVals.isEmpty()) {
            return headerVals.get(0);
        }
        return null;
    }

    public KieServerHttpRequest header(String name, Object value) {
        this.getRequestInfo().setHeader(name, value);
        return this;
    }

    public KieServerHttpRequest headers(Map<String, String> headers) {
        if (!headers.isEmpty()) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                this.header(header.getKey(), header.getValue());
            }
        }
        return this;
    }

    public List<String> getRequestHeader(String headerName) {
        return this.getRequestInfo().getHeader(headerName);
    }

    public KieServerHttpRequest acceptEncoding(String acceptEncoding) {
        return this.header("Accept-Encoding", acceptEncoding);
    }

    public KieServerHttpRequest acceptCharset(String acceptCharset) {
        return this.header("Accept-Charset", acceptCharset);
    }

    public KieServerHttpRequest basicAuthorization(String name, String password) {
        return this.header("Authorization", "Basic " + Base64Util.encode(name + ':' + password));
    }

    public KieServerHttpRequest tokenAuthorization(String token) {
        return this.header("Authorization", "Bearer " + token);
    }

    public KieServerHttpRequest clientCertificate(ClientCertificate clientCertificate) {
        this.getRequestInfo().clientCertificate = clientCertificate;
        return this;
    }

    public KieServerHttpRequest contentType(String contentType) {
        return this.contentType(contentType, null);
    }

    public KieServerHttpRequest contentType(String contentType, String charset) {
        if (charset != null && charset.length() > 0) {
            String separator = "; charset=";
            return this.header("Content-Type", contentType + "; charset=" + charset);
        }
        return this.header("Content-Type", contentType);
    }

    public KieServerHttpRequest accept(String accept) {
        RequestInfo requestInfo = this.getRequestInfo();
        if (requestInfo.getHeader("Accept").isEmpty()) {
            requestInfo.setHeader("Accept", new ArrayList());
        }
        requestInfo.headers.get("Accept").set(0, accept);
        return this;
    }

    private KieServerHttpRequest openOutput() throws IOException {
        if (this.output != null) {
            return this;
        }
        this.getConnection().setDoOutput(true);
        String charset = KieServerHttpRequest.getHeaderParam(this.getConnection().getRequestProperty("Content-Type"), PARAM_CHARSET);
        this.output = new RequestOutputStream(this.getConnection().getOutputStream(), charset, this.bufferSize);
        return this;
    }

    private KieServerHttpRequest closeOutput() throws IOException {
        if (this.connection == null) {
            throw new KieServerHttpRequestException("Please execute a HTTP method first on the request.");
        }
        if (this.output == null) {
            return this;
        }
        if (this.ignoreCloseExceptions) {
            try {
                this.output.close();
            }
            catch (IOException iOException) {}
        } else {
            this.output.close();
        }
        this.output = null;
        return this;
    }

    private KieServerHttpRequest closeOutputQuietly() throws KieServerHttpRequestException {
        try {
            return this.closeOutput();
        }
        catch (IOException ioe) {
            throw new KieServerHttpRequestException("Unable to close output from response", ioe);
        }
    }

    public KieServerHttpRequest body(CharSequence value) throws KieServerHttpRequestException {
        this.getRequestInfo().addToBody(value);
        return this;
    }

    public OutputStreamWriter writer() throws KieServerHttpRequestException {
        try {
            this.openOutput();
            return new OutputStreamWriter((OutputStream)this.output, this.output.encoder.charset());
        }
        catch (IOException ioe) {
            throw new KieServerHttpRequestException("Unable to create writer to request output stream", ioe);
        }
    }

    public KieServerHttpRequest query(Object name, Object value) throws KieServerHttpRequestException {
        this.getRequestInfo().setQueryParameter(name.toString(), value != null ? value.toString() : null);
        return this;
    }

    public KieServerHttpRequest query(Map<?, ?> values) throws KieServerHttpRequestException {
        if (!values.isEmpty()) {
            for (Map.Entry<?, ?> entry : values.entrySet()) {
                this.query(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    private void addQueryParametersToUrl() {
        RequestInfo requestInfo = this.getRequestInfo();
        Object[] paramList = null;
        if (requestInfo.queryParameters != null) {
            ArrayList<String> queryParamList = new ArrayList<String>();
            for (Map.Entry<String, List<String>> paramListEntry : requestInfo.queryParameters.entrySet()) {
                String name = paramListEntry.getKey();
                for (String val : paramListEntry.getValue()) {
                    queryParamList.add(name);
                    queryParamList.add(val);
                }
            }
            paramList = queryParamList.toArray();
        }
        requestInfo.setRequestUrl(KieServerHttpRequest.appendQueryParameters((CharSequence)requestInfo.getRequestUrl().toString(), paramList));
    }

    public KieServerHttpRequest form(Object name, Object value, String charset) throws KieServerHttpRequestException {
        if (!this.getRequestInfo().form) {
            this.contentType("application/x-www-form-urlencoded", charset);
            this.getRequestInfo().form = true;
        }
        charset = KieServerHttpRequest.getValidCharset(charset);
        RequestInfo requestInfo = this.getRequestInfo();
        requestInfo.form = true;
        requestInfo.charset = charset;
        requestInfo.setFormParameter(name.toString(), value);
        return this;
    }

    public KieServerHttpRequest form(Object name, Object value) throws KieServerHttpRequestException {
        return this.form(name, value, CHARSET_UTF8);
    }

    public KieServerHttpRequest form(Map<?, ?> values, String charset) throws KieServerHttpRequestException {
        if (!values.isEmpty()) {
            for (Map.Entry<?, ?> entry : values.entrySet()) {
                this.form(entry.getKey(), entry.getValue(), charset);
            }
        }
        return this;
    }

    public KieServerHttpRequest form(Map<?, ?> values) throws KieServerHttpRequestException {
        return this.form(values, CHARSET_UTF8);
    }

    private void addFormParametersToConnection() {
        RequestInfo requestInfo = this.getRequestInfo();
        if (requestInfo.form && requestInfo.formParameters != null) {
            String name = null;
            String value = null;
            try {
                this.openOutput();
                boolean first = true;
                for (Map.Entry<String, List<String>> entry : requestInfo.formParameters.entrySet()) {
                    name = entry.getKey();
                    Iterator<String> iterator = entry.getValue().iterator();
                    while (iterator.hasNext()) {
                        String formValue;
                        value = formValue = iterator.next();
                        if (!first) {
                            this.output.write(38);
                        }
                        first = false;
                        this.output.write(URLEncoder.encode(name.toString(), requestInfo.charset));
                        this.output.write(61);
                        if (value == null) continue;
                        this.output.write(URLEncoder.encode(value.toString(), requestInfo.charset));
                    }
                }
            }
            catch (IOException ioe) {
                throw new KieServerHttpRequestException("Unable to add form parameter (" + name + "/" + value + ") to request body", ioe);
            }
        }
    }

    public KieServerHttpResponse response() {
        if (this.response == null) {
            this.response = new KieServerHttpResponse(){
                private String body = null;

                @Override
                public InputStream stream() throws KieServerHttpRequestException {
                    return KieServerHttpRequest.this.responseStream();
                }

                @Override
                public String message() throws KieServerHttpRequestException {
                    return KieServerHttpRequest.this.responseMessage();
                }

                @Override
                public int intHeader(String name) throws KieServerHttpRequestException {
                    return KieServerHttpRequest.this.intResponseHeader(name);
                }

                @Override
                public String[] headers(String name) {
                    return KieServerHttpRequest.this.responseHeaders(name);
                }

                @Override
                public Map<String, List<String>> headers() throws KieServerHttpRequestException {
                    return KieServerHttpRequest.this.responseHeaders();
                }

                @Override
                public Map<String, String> headerParameters(String headerName) {
                    return KieServerHttpRequest.this.responseHeaderParameters(headerName);
                }

                @Override
                public String headerParameter(String headerName, String paramName) {
                    return KieServerHttpRequest.this.responseHeaderParameter(headerName, paramName);
                }

                @Override
                public String header(String name) throws KieServerHttpRequestException {
                    return KieServerHttpRequest.this.responseHeader(name);
                }

                @Override
                public String contentType() {
                    return KieServerHttpRequest.this.responseContentType();
                }

                @Override
                public int contentLength() {
                    return KieServerHttpRequest.this.responseContentLength();
                }

                @Override
                public String contentEncoding() {
                    return KieServerHttpRequest.this.responseContentEncoding();
                }

                @Override
                public int code() throws KieServerHttpRequestException {
                    return KieServerHttpRequest.this.responseCode();
                }

                @Override
                public String charset() {
                    return KieServerHttpRequest.this.responseCharset();
                }

                @Override
                public byte[] bytes() throws KieServerHttpRequestException {
                    return KieServerHttpRequest.this.responseBytes();
                }

                @Override
                public BufferedInputStream buffer() throws KieServerHttpRequestException {
                    return KieServerHttpRequest.this.responseBuffer();
                }

                @Override
                public String body() throws KieServerHttpRequestException {
                    if (this.body == null) {
                        this.body = KieServerHttpRequest.this.responseBody();
                    }
                    return this.body;
                }
            };
        }
        return this.response;
    }

    private int responseCode() throws KieServerHttpRequestException {
        this.initializeConnection();
        try {
            this.closeOutput();
            return this.getConnection().getResponseCode();
        }
        catch (IOException ioe) {
            throw new KieServerHttpRequestException("Error occurred when trying to retrieve response code", ioe);
        }
    }

    private String responseMessage() throws KieServerHttpRequestException {
        this.initializeConnection();
        try {
            this.closeOutput();
            return this.getConnection().getResponseMessage();
        }
        catch (IOException ioe) {
            throw new KieServerHttpRequestException("Error occurred when trying to retrieve response message", ioe);
        }
    }

    private String responseBody() throws KieServerHttpRequestException {
        String charset = this.responseCharset();
        ByteArrayOutputStream output = this.byteStream();
        try {
            this.copy(this.responseBuffer(), output);
            return output.toString(KieServerHttpRequest.getValidCharset(charset));
        }
        catch (IOException ioe) {
            throw new KieServerHttpRequestException("Error occurred when retrieving response body", ioe);
        }
    }

    private byte[] responseBytes() throws KieServerHttpRequestException {
        ByteArrayOutputStream output = this.byteStream();
        try {
            this.copy(this.responseBuffer(), output);
        }
        catch (IOException ioe) {
            throw new KieServerHttpRequestException("Error occurred when retrieving byte content of response", ioe);
        }
        return output.toByteArray();
    }

    private ByteArrayOutputStream byteStream() {
        int size = this.responseContentLength();
        if (size > 0) {
            return new ByteArrayOutputStream(size);
        }
        return new ByteArrayOutputStream();
    }

    private InputStream responseStream() throws KieServerHttpRequestException {
        InputStream stream;
        if (this.responseCode() < 400) {
            try {
                stream = this.getConnection().getInputStream();
            }
            catch (IOException ioe) {
                throw new KieServerHttpRequestException("Unable to retrieve input stream of response", ioe);
            }
        }
        stream = this.getConnection().getErrorStream();
        if (stream == null) {
            try {
                stream = this.getConnection().getInputStream();
            }
            catch (IOException ioe) {
                if (this.responseContentLength() > 0) {
                    throw new KieServerHttpRequestException("Unable to retrieve input stream of response", ioe);
                }
                stream = new ByteArrayInputStream(new byte[0]);
            }
        }
        if (!this.uncompress || !"gzip".equals(this.responseContentEncoding())) {
            return stream;
        }
        try {
            return new GZIPInputStream(stream);
        }
        catch (IOException e) {
            throw new KieServerHttpRequestException("Unable to decompress gzipped stream", e);
        }
    }

    private BufferedInputStream responseBuffer() throws KieServerHttpRequestException {
        return new BufferedInputStream(this.responseStream(), this.bufferSize);
    }

    private String responseHeader(String name) throws KieServerHttpRequestException {
        this.closeOutputQuietly();
        return this.getConnection().getHeaderField(name);
    }

    private int intResponseHeader(String name) throws KieServerHttpRequestException {
        this.closeOutputQuietly();
        return this.getConnection().getHeaderFieldInt(name, -1);
    }

    private Map<String, List<String>> responseHeaders() throws KieServerHttpRequestException {
        this.closeOutputQuietly();
        return this.getConnection().getHeaderFields();
    }

    private String[] responseHeaders(String name) {
        Map<String, List<String>> headers = this.responseHeaders();
        if (headers == null || headers.isEmpty()) {
            return EMPTY_STRINGS;
        }
        List<String> values = headers.get(name);
        if (values != null && !values.isEmpty()) {
            return values.toArray(new String[values.size()]);
        }
        return EMPTY_STRINGS;
    }

    private String responseHeaderParameter(String headerName, String paramName) {
        return KieServerHttpRequest.getHeaderParam(this.responseHeader(headerName), paramName);
    }

    private Map<String, String> responseHeaderParameters(String headerName) {
        return KieServerHttpRequest.getHeaderParams(this.responseHeader(headerName));
    }

    private static Map<String, String> getHeaderParams(String header) {
        if (header == null || header.length() == 0) {
            return Collections.emptyMap();
        }
        int headerLength = header.length();
        int start = header.indexOf(59) + 1;
        if (start == 0 || start == headerLength) {
            return Collections.emptyMap();
        }
        int end = header.indexOf(59, start);
        if (end == -1) {
            end = headerLength;
        }
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        while (start < end) {
            String value;
            int length;
            String name;
            int nameEnd = header.indexOf(61, start);
            if (nameEnd != -1 && nameEnd < end && (name = header.substring(start, nameEnd).trim()).length() > 0 && (length = (value = header.substring(nameEnd + 1, end).trim()).length()) != 0) {
                if (length > 2 && '\"' == value.charAt(0) && '\"' == value.charAt(length - 1)) {
                    params.put(name, value.substring(1, length - 1));
                } else {
                    params.put(name, value);
                }
            }
            if ((end = header.indexOf(59, start = end + 1)) != -1) continue;
            end = headerLength;
        }
        return params;
    }

    private static String getHeaderParam(String value, String paramName) {
        if (value == null || value.length() == 0) {
            return null;
        }
        int length = value.length();
        int start = value.indexOf(59) + 1;
        if (start == 0 || start == length) {
            return null;
        }
        int end = value.indexOf(59, start);
        if (end == -1) {
            end = length;
        }
        while (start < end) {
            String paramValue;
            int valueLength;
            int nameEnd = value.indexOf(61, start);
            if (nameEnd != -1 && nameEnd < end && paramName.equals(value.substring(start, nameEnd).trim()) && (valueLength = (paramValue = value.substring(nameEnd + 1, end).trim()).length()) != 0) {
                if (valueLength > 2 && '\"' == paramValue.charAt(0) && '\"' == paramValue.charAt(valueLength - 1)) {
                    return paramValue.substring(1, valueLength - 1);
                }
                return paramValue;
            }
            start = end + 1;
            if ((end = value.indexOf(59, start)) != -1) continue;
            end = length;
        }
        return null;
    }

    private String responseContentEncoding() {
        return this.responseHeader("Content-Encoding");
    }

    private String responseContentType() {
        return this.responseHeader("Content-Type");
    }

    private int responseContentLength() {
        this.closeOutputQuietly();
        return this.getConnection().getHeaderFieldInt("Content-Length", -1);
    }

    private String responseCharset() {
        return this.responseHeaderParameter("Content-Type", PARAM_CHARSET);
    }

    private static SSLSocketFactory getTrustedFactory() throws KieServerHttpRequestException {
        if (TRUSTED_FACTORY == null) {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }
            }};
            try {
                SSLContext context = SSLContext.getInstance("TLS");
                context.init(null, trustAllCerts, new SecureRandom());
                TRUSTED_FACTORY = context.getSocketFactory();
            }
            catch (GeneralSecurityException e) {
                throw new KieServerHttpRequestException("Security exception configuring SSL context", e);
            }
        }
        return TRUSTED_FACTORY;
    }

    private static HostnameVerifier getTrustedVerifier() {
        if (TRUSTED_VERIFIER == null) {
            TRUSTED_VERIFIER = (hostname, session) -> true;
        }
        return TRUSTED_VERIFIER;
    }

    public KieServerHttpRequest trustAllCerts() throws KieServerHttpRequestException {
        HttpURLConnection connection = this.getConnection();
        if (connection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)connection).setSSLSocketFactory(KieServerHttpRequest.getTrustedFactory());
        }
        return this;
    }

    public KieServerHttpRequest trustAllHosts() {
        HttpURLConnection connection = this.getConnection();
        if (connection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)connection).setHostnameVerifier(KieServerHttpRequest.getTrustedVerifier());
        }
        return this;
    }

    public static void setProxyHost(String host) {
        KieServerHttpRequest.setProperty("http.proxyHost", host);
        KieServerHttpRequest.setProperty("https.proxyHost", host);
    }

    public static void setProxyPort(int port) {
        String portValue = Integer.toString(port);
        KieServerHttpRequest.setProperty("http.proxyPort", portValue);
        KieServerHttpRequest.setProperty("https.proxyPort", portValue);
    }

    public static void setNonProxyHosts(String ... hosts) {
        if (hosts != null && hosts.length > 0) {
            StringBuilder separated = new StringBuilder();
            int last = hosts.length - 1;
            for (int i = 0; i < last; ++i) {
                separated.append(hosts[i]).append('|');
            }
            separated.append(hosts[last]);
            KieServerHttpRequest.setProperty("http.nonProxyHosts", separated.toString());
        } else {
            KieServerHttpRequest.setProperty("http.nonProxyHosts", null);
        }
    }

    public KieServerHttpRequest useProxy(String proxyHost, int proxyPort) {
        if (this.connection != null) {
            throw new IllegalStateException("The connection has already been created. This method must be called before reading or writing to the request.");
        }
        this.httpProxyHost = proxyHost;
        this.httpProxyPort = proxyPort;
        return this;
    }

    public KieServerHttpRequest proxyAuthorization(String proxyAuthorization) {
        return this.header(HEADER_PROXY_AUTHORIZATION, proxyAuthorization);
    }

    public KieServerHttpRequest proxyBasic(String name, String password) {
        return this.proxyAuthorization("Basic " + Base64Util.encode(name + ':' + password));
    }

    public String toString() {
        return this.getMethod() + ' ' + this.getUrl();
    }

    public KieServerHttpRequest clone() {
        if (this.connection != null) {
            throw new KieServerHttpRequestException("Unable to clone request with open or completed connection.");
        }
        return new KieServerHttpRequest(this.getRequestInfo().clone());
    }

    public static class RequestOutputStream
    extends BufferedOutputStream {
        private final CharsetEncoder encoder;

        public RequestOutputStream(OutputStream stream, String charset, int bufferSize) {
            super(stream, bufferSize);
            this.encoder = Charset.forName(KieServerHttpRequest.getValidCharset(charset)).newEncoder();
        }

        public RequestOutputStream write(String value) throws IOException {
            ByteBuffer bytes = this.encoder.encode(CharBuffer.wrap(value));
            super.write(bytes.array(), 0, bytes.limit());
            return this;
        }
    }

    private static abstract class FlushOperation<V>
    extends Operation<V> {
        private final Flushable flushable;

        protected FlushOperation(Flushable flushable) {
            this.flushable = flushable;
        }

        @Override
        protected void done() throws IOException {
            this.flushable.flush();
        }
    }

    private static abstract class CloseOperation<V>
    extends Operation<V> {
        private final Closeable closeable;
        private final boolean ignoreCloseExceptions;

        protected CloseOperation(Closeable closeable, boolean ignoreCloseExceptions) {
            this.closeable = closeable;
            this.ignoreCloseExceptions = ignoreCloseExceptions;
        }

        @Override
        protected void done() throws IOException {
            if (this.closeable instanceof Flushable) {
                ((Flushable)((Object)this.closeable)).flush();
            }
            if (this.ignoreCloseExceptions) {
                try {
                    this.closeable.close();
                }
                catch (IOException iOException) {}
            } else {
                this.closeable.close();
            }
        }
    }

    private static abstract class Operation<V>
    implements Callable<V> {
        private Operation() {
        }

        protected abstract V run() throws KieServerHttpRequestException, IOException;

        protected abstract void done() throws IOException;

        @Override
        public V call() throws KieServerHttpRequestException {
            boolean thrown = false;
            try {
                V v = this.run();
                return v;
            }
            catch (KieServerHttpRequestException e) {
                thrown = true;
                throw e;
            }
            catch (IOException ioe) {
                thrown = true;
                throw new KieServerHttpRequestException("Unable to do " + this.getClass().getSimpleName(), ioe);
            }
            finally {
                block10: {
                    try {
                        this.done();
                    }
                    catch (IOException ioe) {
                        if (thrown) break block10;
                        throw new KieServerHttpRequestException("Exception thrown when finishing " + this.getClass().getSimpleName(), ioe);
                    }
                }
            }
        }
    }

    public static interface ConnectionFactory {
        public static final ConnectionFactory DEFAULT = new ConnectionFactory(){

            @Override
            public HttpURLConnection create(URL url) throws IOException {
                return (HttpURLConnection)url.openConnection();
            }

            @Override
            public HttpURLConnection create(URL url, Proxy proxy) throws IOException {
                return (HttpURLConnection)url.openConnection(proxy);
            }
        };

        public HttpURLConnection create(URL var1) throws IOException;

        public HttpURLConnection create(URL var1, Proxy var2) throws IOException;
    }

    private static class RequestInfo {
        URL baseUrl;
        URL requestUrl;
        String user;
        String password;
        ClientCertificate clientCertificate;
        Integer timeoutInMilliSecs = 5000;
        String requestMethod;
        Map<String, List<String>> headers;
        Map<String, List<String>> queryParameters;
        Map<String, List<String>> formParameters;
        boolean form = false;
        String charset;
        StringBuilder body;
        MediaType bodyContentType;

        private RequestInfo() {
        }

        public URL getRequestUrl() {
            if (this.requestUrl == null) {
                this.requestUrl = this.baseUrl;
            }
            return this.requestUrl;
        }

        public void setRequestUrl(String urlString) {
            this.requestUrl = KieServerHttpRequest.convertStringToUrl(urlString);
        }

        public List<String> getHeader(String name) {
            if (this.headers == null) {
                this.headers = new LinkedHashMap<String, List<String>>();
            }
            if (this.headers.get(name) == null) {
                return Collections.EMPTY_LIST;
            }
            return this.headers.get(name);
        }

        public void setHeader(String name, Object value) {
            if (this.headers == null) {
                this.headers = new LinkedHashMap<String, List<String>>();
            }
            if (this.headers.get(name) == null) {
                this.headers.put(name, new ArrayList());
            }
            this.headers.get(name).add(value == null ? null : value.toString());
        }

        public void setQueryParameter(String name, Object value) {
            if (this.queryParameters == null) {
                this.queryParameters = new LinkedHashMap<String, List<String>>();
            }
            if (this.queryParameters.get(name) == null) {
                this.queryParameters.put(name, new ArrayList());
            }
            this.queryParameters.get(name).add(value == null ? null : value.toString());
        }

        public void setFormParameter(String name, Object value) {
            if (this.formParameters == null) {
                this.formParameters = new LinkedHashMap<String, List<String>>();
            }
            if (this.formParameters.get(name) == null) {
                this.formParameters.put(name, new ArrayList());
            }
            this.formParameters.get(name).add(value == null ? null : value.toString());
        }

        public void addToBody(CharSequence addToBody) {
            if (this.body == null) {
                this.body = new StringBuilder();
            }
            this.body.append(addToBody);
        }

        public RequestInfo clone() {
            RequestInfo clone = new RequestInfo();
            clone.baseUrl = this.baseUrl;
            clone.body = this.body;
            clone.bodyContentType = this.bodyContentType;
            clone.charset = this.charset;
            clone.form = this.form;
            clone.formParameters = this.formParameters;
            clone.headers = this.headers;
            clone.password = this.password;
            clone.queryParameters = this.queryParameters;
            clone.requestMethod = this.requestMethod;
            clone.requestUrl = this.requestUrl;
            clone.timeoutInMilliSecs = this.timeoutInMilliSecs;
            clone.user = this.user;
            clone.clientCertificate = this.clientCertificate;
            return clone;
        }
    }
}

