/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.send;

import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import org.mariadb.jdbc.internal.packet.send.InterfaceSendPacket;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;
import org.mariadb.jdbc.internal.util.Utils;

public class SendHandshakeResponsePacket
implements InterfaceSendPacket {
    private final byte packetSeq;
    private final String username;
    private final String password;
    private final byte[] seed;
    private final int clientCapabilities;
    private final byte serverLanguage;
    private final String database;

    public SendHandshakeResponsePacket(String username, String password, String database, int clientCapabilities, byte serverLanguage, byte[] seed, byte packetSeq) {
        this.packetSeq = packetSeq;
        this.username = username;
        this.password = password;
        this.seed = seed;
        this.clientCapabilities = clientCapabilities;
        this.serverLanguage = serverLanguage;
        this.database = database;
    }

    @Override
    public int send(OutputStream os) throws IOException {
        byte[] scrambledPassword;
        PacketOutputStream writeBuffer = (PacketOutputStream)os;
        writeBuffer.startPacket(this.packetSeq);
        try {
            scrambledPassword = Utils.encryptPassword(this.password, this.seed);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not use SHA-1, failing", e);
        }
        writeBuffer.writeInt(this.clientCapabilities).writeInt(0x40000000).writeByte(this.serverLanguage).writeBytes((byte)0, 23).writeString(this.username).writeByte((byte)0).writeByte((byte)scrambledPassword.length).writeByteArray(scrambledPassword);
        if ((this.clientCapabilities & 8) != 0) {
            writeBuffer.writeString(this.database).writeByte((byte)0);
        }
        writeBuffer.finishPacket();
        return 1;
    }
}

