/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.api.io;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.efesto.common.api.exceptions.KieEfestoCommonException;
import org.kie.efesto.common.api.io.IndexFile;

class IndexFileTest {
    IndexFileTest() {
    }

    @Test
    void validatePathName() {
        String toValidate = "/this/is/valid/file.model_json";
        Assertions.assertThat((String)IndexFile.validatePathName((String)toValidate)).isEqualTo(toValidate);
    }

    @Test
    void validateWrongPathName() {
        List<String> toValidate = Arrays.asList("/this/is/invalid/file._json", "/this/is/invalid/file.model");
        toValidate.forEach(toVal -> {
            String fileName = toVal.substring(toVal.lastIndexOf(47) + 1);
            String expectedMessage = String.format("Wrong file name %s", fileName);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IndexFile.validatePathName((String)toVal)).isInstanceOf(KieEfestoCommonException.class)).hasMessage(expectedMessage);
        });
    }

    @Test
    void getModel() {
        String fileName = "file_name.model_json";
        String expected = "model";
        String source = fileName;
        Assertions.assertThat((String)IndexFile.getModel((String)source)).isEqualTo(expected);
        source = File.separator + "dir" + File.separator + fileName;
        Assertions.assertThat((String)IndexFile.getModel((String)source)).isEqualTo(expected);
    }

    @Test
    void testGetModel() {
        String fileName = "/this/is/valid/file.model_json";
        String expected = "model";
        IndexFile indexFile = new IndexFile(fileName);
        Assertions.assertThat((String)indexFile.getModel()).isEqualTo(expected);
    }
}

