/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.api.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.util.Optional;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.efesto.common.api.exceptions.KieEfestoCommonException;
import org.kie.efesto.common.api.io.MemoryFile;
import org.kie.efesto.common.api.utils.FileUtils;

class FileUtilsTest {
    private static final String TEST_FILE = "TestingEmptyFile.txt";
    private static final String NOT_EXISTING_FILE = "NotExistingFile.txt";
    private static final String NOT_EMPTY_FILE = "IndexFile.test_json";
    private static String content;

    FileUtilsTest() {
    }

    @BeforeAll
    public static void setup() throws IOException {
        File testingFile = FileUtils.getFile((String)NOT_EMPTY_FILE);
        Assertions.assertThat((File)testingFile).isNotNull();
        Assertions.assertThat((File)testingFile).exists();
        content = new String(Files.readAllBytes(testingFile.toPath()));
        ((AbstractStringAssert)Assertions.assertThat((String)content).isNotNull()).isNotEmpty();
    }

    @Test
    void getFileFromFileNameExisting() {
        File retrieved = FileUtils.getFile((String)TEST_FILE);
        Assertions.assertThat((File)retrieved).isNotNull();
        Assertions.assertThat((File)retrieved).exists();
    }

    @Test
    void getFileFromFileNameNotExisting() {
        try {
            FileUtils.getFile((String)NOT_EXISTING_FILE);
            Assertions.fail((String)"Expecting KieEfestoCommonException");
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(KieEfestoCommonException.class);
        }
    }

    @Test
    void getFileInputStreamExisting() throws IOException {
        FileInputStream retrieved = FileUtils.getFileInputStream((String)TEST_FILE);
        Assertions.assertThat((InputStream)retrieved).isNotNull();
    }

    @Test
    void getFileInputStreamNotExisting() {
        try {
            FileUtils.getFileInputStream((String)NOT_EXISTING_FILE);
            Assertions.fail((String)"Expecting KieEfestoCommonException");
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(KieEfestoCommonException.class);
        }
    }

    @Test
    void getFileContent() throws IOException {
        String retrieved = FileUtils.getFileContent((String)NOT_EMPTY_FILE);
        ((AbstractStringAssert)Assertions.assertThat((String)retrieved).isNotNull()).isNotEmpty();
    }

    @Test
    void getInputStreamFromFileNameExisting() {
        InputStream retrieved = FileUtils.getInputStreamFromFileName((String)TEST_FILE);
        Assertions.assertThat((InputStream)retrieved).isNotNull();
    }

    @Test
    void getInputStreamFromFileNameNotExisting() {
        try {
            FileUtils.getInputStreamFromFileName((String)NOT_EXISTING_FILE);
            Assertions.fail((String)"Expecting KieEfestoCommonException thrown");
        }
        catch (Exception e) {
            Assertions.assertThat((boolean)(e instanceof KieEfestoCommonException)).isTrue();
        }
    }

    @Test
    void getFileFromFileNameOrFilePathExisting() {
        Optional retrieved = FileUtils.getFileFromFileNameOrFilePath((String)TEST_FILE, (String)TEST_FILE);
        ((OptionalAssert)Assertions.assertThat((Optional)retrieved).isNotNull()).isNotEmpty();
        String path = String.format("target%1$stest-classes%1$s%2$s", File.separator, TEST_FILE);
        retrieved = FileUtils.getFileFromFileNameOrFilePath((String)NOT_EXISTING_FILE, (String)path);
        ((OptionalAssert)Assertions.assertThat((Optional)retrieved).isNotNull()).isNotEmpty();
        retrieved = FileUtils.getFileFromFileNameOrFilePath((String)path, (String)NOT_EXISTING_FILE);
        ((OptionalAssert)Assertions.assertThat((Optional)retrieved).isNotNull()).isNotEmpty();
    }

    @Test
    void getFileFromFileNameOrFilePathNotExisting() {
        Optional retrieved = FileUtils.getFileFromFileNameOrFilePath((String)NOT_EXISTING_FILE, (String)NOT_EXISTING_FILE);
        ((OptionalAssert)Assertions.assertThat((Optional)retrieved).isNotNull()).isEmpty();
    }

    @Test
    void getFileFromURL() throws IOException {
        URL url = FileUtilsTest.getJarUrl();
        Assertions.assertThat((URL)url).isNotNull();
        Optional retrieved = FileUtils.getFileFromURL((URL)url);
        ((OptionalAssert)Assertions.assertThat((Optional)retrieved).isNotNull()).isPresent();
        Assertions.assertThat((File)((File)retrieved.get())).isInstanceOf(MemoryFile.class);
        Assertions.assertThat((File)((File)retrieved.get())).canRead();
        url = FileUtilsTest.getResourceUrl();
        Assertions.assertThat((URL)url).isNotNull();
        retrieved = FileUtils.getFileFromURL((URL)url);
        ((OptionalAssert)Assertions.assertThat((Optional)retrieved).isNotNull()).isPresent();
        Assertions.assertThat((File)((File)retrieved.get())).isInstanceOf(File.class);
        Assertions.assertThat((File)((File)retrieved.get())).canRead();
    }

    @Test
    void getOptionalFileFromJar() throws IOException {
        URL jarUrl = FileUtilsTest.getJarUrl();
        Assertions.assertThat((URL)jarUrl).isNotNull();
        Optional retrieved = FileUtils.getOptionalFileFromJar((URL)jarUrl);
        Assertions.assertThat((Optional)retrieved).isNotNull();
        Assertions.assertThat((boolean)retrieved.isPresent()).isTrue();
        Assertions.assertThat((Optional)retrieved).get().isInstanceOf(MemoryFile.class);
    }

    @Test
    void getOptionalFileFromResource() {
        URL resourceUrl = FileUtilsTest.getResourceUrl();
        Optional retrieved = FileUtils.getOptionalFileFromResource((URL)resourceUrl);
        Assertions.assertThat((Optional)retrieved).isNotNull();
        Assertions.assertThat((boolean)retrieved.isPresent()).isTrue();
        Assertions.assertThat((Optional)retrieved).get().isInstanceOf(MemoryFile.class);
    }

    @Test
    void getOptionalFileFromURLFile() {
        URL resourceUrl = FileUtilsTest.getResourceUrl();
        Optional retrieved = FileUtils.getOptionalFileFromURLFile((URL)resourceUrl);
        Assertions.assertThat((Optional)retrieved).isNotNull();
        Assertions.assertThat((boolean)retrieved.isPresent()).isTrue();
        Assertions.assertThat((Optional)retrieved).get().isInstanceOf(File.class);
    }

    @Test
    void getFileFromResource() throws IOException {
        URL resourceUrl = FileUtilsTest.getResourceUrl();
        File retrieved = FileUtils.getFileFromResource((URL)resourceUrl);
        Assertions.assertThat((File)retrieved).isNotNull();
        Assertions.assertThat((File)retrieved).isInstanceOf(MemoryFile.class);
        Assertions.assertThat((File)retrieved).canRead();
    }

    @Test
    void getFileFromJar() throws URISyntaxException, IOException {
        URL jarUrl = FileUtilsTest.getJarUrl();
        Assertions.assertThat((URL)jarUrl).isNotNull();
        File retrieved = FileUtils.getFileFromJar((URL)jarUrl);
        Assertions.assertThat((File)retrieved).isNotNull();
        Assertions.assertThat((File)retrieved).isInstanceOf(MemoryFile.class);
        Assertions.assertThat((File)retrieved).canRead();
    }

    private static URL getResourceUrl() {
        URL toReturn = Thread.currentThread().getContextClassLoader().getResource(NOT_EMPTY_FILE);
        Assertions.assertThat((URL)toReturn).isNotNull();
        return toReturn;
    }

    private static URL getJarUrl() throws MalformedURLException {
        URL retrieved = Thread.currentThread().getContextClassLoader().getResource("TestJar.jar");
        Assertions.assertThat((URL)retrieved).isNotNull();
        String newString = "jar:" + retrieved + "!/IndexFile.testb_json";
        return new URL(newString);
    }
}

