/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.api.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;
import org.kie.efesto.common.api.io.IndexFile;
import org.kie.efesto.common.api.io.MemoryFile;
import org.kie.efesto.common.api.model.FRI;
import org.kie.efesto.common.api.model.GeneratedClassResource;
import org.kie.efesto.common.api.model.GeneratedExecutableResource;
import org.kie.efesto.common.api.model.GeneratedRedirectResource;
import org.kie.efesto.common.api.model.GeneratedResource;
import org.kie.efesto.common.api.model.GeneratedResources;
import org.kie.efesto.common.api.utils.FileUtils;
import org.kie.efesto.common.api.utils.JSONUtils;

class JSONUtilsTest {
    JSONUtilsTest() {
    }

    @Test
    void getGeneratedResourceString() throws JsonProcessingException {
        String fullClassName = "full.class.Name";
        GeneratedClassResource generatedResource = new GeneratedClassResource(fullClassName);
        String expected = String.format("{\"step-type\":\"class\",\"fullClassName\":\"%s\"}", fullClassName);
        String retrieved = JSONUtils.getGeneratedResourceString((GeneratedResource)generatedResource);
        Assertions.assertThat((String)retrieved).isEqualTo(expected);
        String model = "foo";
        FRI fri = new FRI("this/is/fri", model);
        String target = "foo";
        generatedResource = new GeneratedRedirectResource(fri, target);
        expected = String.format("{\"step-type\":\"redirect\",\"fri\":%s,\"target\":\"%s\"}", JSONUtils.getFRIString((FRI)fri), target);
        retrieved = JSONUtils.getGeneratedResourceString((GeneratedResource)generatedResource);
        Assertions.assertThat((String)retrieved).isEqualTo(expected);
        generatedResource = new GeneratedExecutableResource(fri, Collections.singletonList(fullClassName));
        expected = String.format("{\"step-type\":\"executable\",\"fri\":%s,\"fullClassNames\":[\"%s\"]}", JSONUtils.getFRIString((FRI)fri), fullClassName);
        retrieved = JSONUtils.getGeneratedResourceString((GeneratedResource)generatedResource);
        Assertions.assertThat((String)retrieved).isEqualTo(expected);
    }

    @Test
    void getGeneratedResourceObject() throws JsonProcessingException {
        String generatedResourceString = "{\"step-type\":\"redirect\",\"fri\":{\"basePath\":\"this/is/fri\",\"fri\":\"this/is/fri_foo\"},\"target\":\"foo\"}";
        GeneratedResource retrieved = JSONUtils.getGeneratedResourceObject((String)generatedResourceString);
        ((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).isInstanceOf(GeneratedRedirectResource.class);
        generatedResourceString = "{\"step-type\":\"class\",\"fullClassName\":\"full.class.Name\"}\"";
        retrieved = JSONUtils.getGeneratedResourceObject((String)generatedResourceString);
        ((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).isInstanceOf(GeneratedClassResource.class);
        generatedResourceString = "{\"step-type\":\"executable\",\"fri\":{\"basePath\":\"this/is/fri\",\"fri\":\"this/is/fri_foo\",\"model\":\"foo\"},\"fullClassNames\":[\"full.class.Name\"]}";
        retrieved = JSONUtils.getGeneratedResourceObject((String)generatedResourceString);
        ((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).isInstanceOf(GeneratedExecutableResource.class);
    }

    @Test
    void getGeneratedResourcesString() throws JsonProcessingException {
        String fullClassName = "full.class.Name";
        GeneratedClassResource generatedIntermediateResource = new GeneratedClassResource(fullClassName);
        String model = "foo";
        FRI fri = new FRI("this/is/fri", model);
        GeneratedExecutableResource generatedFinalResource = new GeneratedExecutableResource(fri, Collections.singletonList(fullClassName));
        GeneratedResources generatedResources = new GeneratedResources();
        generatedResources.add((Object)generatedIntermediateResource);
        generatedResources.add((Object)generatedFinalResource);
        String retrieved = JSONUtils.getGeneratedResourcesString((GeneratedResources)generatedResources);
        String expected1 = String.format("{\"step-type\":\"class\",\"fullClassName\":\"%s\"}", fullClassName);
        String expected2 = String.format("{\"step-type\":\"executable\",\"fri\":%s,\"fullClassNames\":[\"%s\"]}", JSONUtils.getFRIString((FRI)fri), fullClassName);
        Assertions.assertThat((String)retrieved).contains(new CharSequence[]{expected1});
        Assertions.assertThat((String)retrieved).contains(new CharSequence[]{expected2});
    }

    @Test
    void getGeneratedResourcesObjectFromString() throws JsonProcessingException {
        String generatedResourcesString = "[{\"step-type\":\"executable\",\"fri\":{\"basePath\":\"this/is/fri\",\"fri\":\"/foo/this/is/fri\"}},{\"step-type\":\"class\",\"fullClassName\":\"full.class.Name\"}]";
        GeneratedResources retrieved = JSONUtils.getGeneratedResourcesObject((String)generatedResourcesString);
        Assertions.assertThat((Iterable)retrieved).isNotNull();
        String fullClassName = "full.class.Name";
        GeneratedClassResource expected1 = new GeneratedClassResource(fullClassName);
        String model = "foo";
        FRI fri = new FRI("this/is/fri", model);
        GeneratedExecutableResource expected2 = new GeneratedExecutableResource(fri, Collections.singletonList(fullClassName));
        Assertions.assertThat((Iterable)retrieved).contains((Object[])new GeneratedResource[]{expected1});
        Assertions.assertThat((Iterable)retrieved).contains((Object[])new GeneratedResource[]{expected2});
    }

    @Test
    void getGeneratedResourcesObjectFromFile() throws Exception {
        String fileName = "IndexFile.test_json";
        URL resource = Thread.currentThread().getContextClassLoader().getResource(fileName);
        assert (resource != null);
        IndexFile indexFile = new IndexFile(new File(resource.toURI()));
        GeneratedResources retrieved = JSONUtils.getGeneratedResourcesObject((IndexFile)indexFile);
        Assertions.assertThat((Iterable)retrieved).isNotNull();
        String fullClassName = "full.class.Name";
        GeneratedClassResource expected1 = new GeneratedClassResource(fullClassName);
        String model = "foo";
        FRI fri = new FRI("this/is/fri", model);
        GeneratedExecutableResource expected2 = new GeneratedExecutableResource(fri, Collections.singletonList(fullClassName));
        Assertions.assertThat((Iterable)retrieved).contains((Object[])new GeneratedResource[]{expected1});
        Assertions.assertThat((Iterable)retrieved).contains((Object[])new GeneratedResource[]{expected2});
    }

    @Test
    void getGeneratedResourcesObjectFromJar() throws Exception {
        ClassLoader originalClassLoader = this.addJarToClassLoader();
        Optional optionalIndexFile = FileUtils.getFileFromFileName((String)"IndexFile.testb_json");
        ((OptionalAssert)Assertions.assertThat((Optional)optionalIndexFile).isNotNull()).isPresent();
        Assertions.assertThat((Optional)optionalIndexFile).get().isInstanceOf(MemoryFile.class);
        MemoryFile memoryFile = (MemoryFile)optionalIndexFile.get();
        IndexFile indexFile = new IndexFile((MemoryFile)optionalIndexFile.get());
        Assertions.assertThat((byte[])indexFile.getContent()).isEqualTo((Object)memoryFile.getContent());
        GeneratedResources retrieved = JSONUtils.getGeneratedResourcesObject((IndexFile)indexFile);
        Assertions.assertThat((Iterable)retrieved).isNotNull();
        String fullClassName = "full.class.Name";
        GeneratedClassResource expected1 = new GeneratedClassResource(fullClassName);
        String model = "foo";
        FRI fri = new FRI("this/is/fri", model);
        GeneratedExecutableResource expected2 = new GeneratedExecutableResource(fri, Collections.singletonList(fullClassName));
        Assertions.assertThat((Iterable)retrieved).contains((Object[])new GeneratedResource[]{expected1});
        Assertions.assertThat((Iterable)retrieved).contains((Object[])new GeneratedResource[]{expected2});
        this.restoreClassLoader(originalClassLoader);
    }

    @Test
    void getFRIString() throws JsonProcessingException {
        String model = "foo";
        String basePath = "this/is/fri";
        FRI fri = new FRI(basePath, model);
        String retrieved = JSONUtils.getFRIString((FRI)fri);
        String expected = String.format("{\"basePath\":\"%1$s\",\"model\":\"%2$s\",\"fri\":\"/%2$s%1$s\"}", "/" + basePath, model);
        Assertions.assertThat((String)retrieved).isEqualTo(expected);
    }

    @Test
    void getFRIObject() throws JsonProcessingException {
        String friString = "{\"basePath\":\"this/is/fri\",\"model\":\"foo\",\"fri\":\"/foo/this/is/fri\"}";
        FRI retrieved = JSONUtils.getFRIObject((String)friString);
        Assertions.assertThat((Object)retrieved).isNotNull();
        String expected = "foo";
        Assertions.assertThat((String)retrieved.getModel()).isEqualTo(expected);
        expected = "this/is/fri";
        Assertions.assertThat((String)retrieved.getBasePath()).isEqualTo(expected);
        expected = "/foo/this/is/fri";
        Assertions.assertThat((String)retrieved.getFri()).isEqualTo(expected);
    }

    private ClassLoader addJarToClassLoader() {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        URL jarUrl = Thread.currentThread().getContextClassLoader().getResource("TestJar.jar");
        Assertions.assertThat((URL)jarUrl).isNotNull();
        URL fileUrl = Thread.currentThread().getContextClassLoader().getResource("IndexFile.testb_json");
        Assertions.assertThat((URL)fileUrl).isNull();
        URL[] urls = new URL[]{jarUrl};
        URLClassLoader testClassLoader = URLClassLoader.newInstance(urls, originalClassLoader);
        Thread.currentThread().setContextClassLoader(testClassLoader);
        return originalClassLoader;
    }

    private void restoreClassLoader(ClassLoader toRestore) {
        Thread.currentThread().setContextClassLoader(toRestore);
    }
}

