/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.api.identifiers;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.efesto.common.api.identifiers.LocalUri;

public class LocalUriTest {
    @Test
    public void testToString() {
        LocalUri hpath = LocalUri.Root.append("example").append("some-id").append("instances").append("some-instance-id");
        Assertions.assertEquals((Object)"/example/some-id/instances/some-instance-id", (Object)hpath.path());
    }

    @Test
    public void testStartsWith() {
        LocalUri hpath = LocalUri.Root.append("example").append("some-id").append("instances").append("some-instance-id");
        Assertions.assertTrue((boolean)hpath.startsWith("example"));
    }

    @Test
    public void testParse() {
        String path = "/example/some-id/instances/some-instance-id";
        LocalUri hpath = LocalUri.Root.append("example").append("some-id").append("instances").append("some-instance-id");
        LocalUri parsedHPath = LocalUri.parse((String)path);
        Assertions.assertEquals((Object)hpath, (Object)parsedHPath);
    }

    @Test
    public void testParseMalformed() {
        String path = "/example////some-id//instances/some-instance-id";
        LocalUri hpath = LocalUri.Root.append("example").append("some-id").append("instances").append("some-instance-id");
        LocalUri parsedHPath = LocalUri.parse((String)path);
        Assertions.assertEquals((Object)hpath, (Object)parsedHPath);
    }

    @Test
    public void testParseMalformedRelative() {
        String path = "example////some-id//instances/some-instance-id";
        Assertions.assertThrows(IllegalArgumentException.class, () -> LocalUri.parse((String)path));
    }

    @Test
    public void testUrlEncoding() {
        LocalUri path = LocalUri.Root.append("URL unsafe").append("??").append("Compon/ents").append("are \\ encoded");
        Assertions.assertEquals((Object)"/URL+unsafe/%3F%3F/Compon%2Fents/are+%5C+encoded", (Object)path.path());
    }

    @Test
    public void testUriConversion() {
        String path = "/example/some-id/instances/some-instance-id";
        LocalUri parsed = LocalUri.parse((String)path);
        Assertions.assertEquals((Object)parsed.toUri().toString(), (Object)String.format("%s://%s", "efesto-local", parsed.path()));
    }
}

