/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.backend.closure;

import com.google.common.base.Preconditions;
import com.google.j2cl.transpiler.ast.DeclaredTypeDescriptor;
import com.google.j2cl.transpiler.ast.HasName;
import com.google.j2cl.transpiler.ast.MethodLike;
import com.google.j2cl.transpiler.ast.TypeDeclaration;
import com.google.j2cl.transpiler.ast.TypeDescriptor;
import com.google.j2cl.transpiler.backend.closure.ClosureTypesGenerator;
import com.google.j2cl.transpiler.backend.closure.Import;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ClosureGenerationEnvironment {
    private final Map<String, String> aliasByTypeBinaryName = new HashMap<String, String>();
    private final Map<HasName, String> uniqueNameByVariable;
    private final ClosureTypesGenerator closureTypesGenerator = new ClosureTypesGenerator(this);

    public ClosureGenerationEnvironment(Collection<Import> imports, Map<HasName, String> uniqueNameByVariable) {
        for (Import anImport : imports) {
            String alias = anImport.getAlias();
            Preconditions.checkArgument((alias != null && !alias.isEmpty() ? 1 : 0) != 0, (String)"Bad alias for %s", (Object)anImport.getElement());
            this.aliasByTypeBinaryName.put(anImport.getElement().getQualifiedBinaryName(), alias);
        }
        this.uniqueNameByVariable = uniqueNameByVariable;
    }

    public String getUniqueNameForVariable(HasName variable) {
        if (this.uniqueNameByVariable.containsKey(variable)) {
            return this.uniqueNameByVariable.get(variable);
        }
        return variable.getName();
    }

    public String aliasForType(DeclaredTypeDescriptor typeDescriptor) {
        return this.aliasForType(typeDescriptor.getTypeDeclaration());
    }

    public String aliasForType(TypeDeclaration typeDeclaration) {
        if (typeDeclaration.isExtern()) {
            return typeDeclaration.getQualifiedJsName();
        }
        String moduleAlias = this.aliasByTypeBinaryName.get(typeDeclaration.getEnclosingModule().getQualifiedBinaryName());
        Preconditions.checkState((moduleAlias != null ? 1 : 0) != 0, (String)"An alias was needed for %s but no alias was found.", (Object)typeDeclaration);
        String innerTypeQualifier = typeDeclaration.getInnerTypeQualifier();
        return innerTypeQualifier.isEmpty() ? moduleAlias : moduleAlias + "." + innerTypeQualifier;
    }

    public String getClosureTypeString(TypeDescriptor typeDescriptor) {
        return this.closureTypesGenerator.getClosureTypeString(typeDescriptor);
    }

    public String getJsDocForParameter(MethodLike methodLike, int index) {
        return this.closureTypesGenerator.getJsDocForParameter(methodLike, index);
    }
}

