/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.backend.closure;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.google.j2cl.transpiler.ast.ArrayTypeDescriptor;
import com.google.j2cl.transpiler.ast.AstUtils;
import com.google.j2cl.transpiler.ast.DeclaredTypeDescriptor;
import com.google.j2cl.transpiler.ast.HasName;
import com.google.j2cl.transpiler.ast.IntersectionTypeDescriptor;
import com.google.j2cl.transpiler.ast.MethodDescriptor;
import com.google.j2cl.transpiler.ast.MethodLike;
import com.google.j2cl.transpiler.ast.PrimitiveTypeDescriptor;
import com.google.j2cl.transpiler.ast.TypeDeclaration;
import com.google.j2cl.transpiler.ast.TypeDescriptor;
import com.google.j2cl.transpiler.ast.TypeDescriptors;
import com.google.j2cl.transpiler.ast.TypeVariable;
import com.google.j2cl.transpiler.ast.UnionTypeDescriptor;
import com.google.j2cl.transpiler.backend.closure.ClosureGenerationEnvironment;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ClosureTypesGenerator {
    private final ClosureGenerationEnvironment environment;
    private static final ClosurePrimitiveType UNDEFINED = new ClosurePrimitiveType("undefined", false);
    private static final ClosurePrimitiveType NULL = new ClosurePrimitiveType("null", true);
    private static final ClosurePrimitiveType STRING = new ClosurePrimitiveType("string", false);
    private static final ClosurePrimitiveType NUMBER = new ClosurePrimitiveType("number", false);
    private static final ClosurePrimitiveType VOID = new ClosurePrimitiveType("void", false);
    private static final ClosurePrimitiveType BOOLEAN = new ClosurePrimitiveType("boolean", false);
    private static final ClosurePrimitiveType ARRAY = new ClosurePrimitiveType("Array", true);
    private static final ClosurePrimitiveType ANY = new ClosurePrimitiveType("*", true);
    private static final ClosureUnknownType UNKNOWN = new ClosureUnknownType();
    private static final ImmutableMap<String, ClosureType> specialClosureTypesByName = ImmutableMap.builder().put((Object)UNDEFINED.render(), (Object)UNDEFINED).put((Object)NULL.render(), (Object)NULL).put((Object)ANY.render(), (Object)ANY).put((Object)UNKNOWN.render(), (Object)UNKNOWN).put((Object)STRING.render(), (Object)STRING).put((Object)NUMBER.render(), (Object)NUMBER).put((Object)BOOLEAN.render(), (Object)BOOLEAN).put((Object)VOID.render(), (Object)VOID).build();
    private static final ThreadLocal<Map<TypeDeclaration, ClosureType>> closureTypeByTypeDeclaration = ThreadLocal.withInitial(() -> {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)TypeDescriptors.get().javaLangObject.getTypeDeclaration(), (Object)ANY.toNullable()).put((Object)TypeDescriptors.get().javaLangString.getTypeDeclaration(), (Object)STRING.toNullable()).put((Object)TypeDescriptors.get().javaLangDouble.getTypeDeclaration(), (Object)NUMBER.toNullable()).put((Object)TypeDescriptors.get().javaLangBoolean.getTypeDeclaration(), (Object)BOOLEAN.toNullable()).put((Object)TypeDescriptors.get().javaLangVoid.getTypeDeclaration(), (Object)VOID.toNullable());
        DeclaredTypeDescriptor nothing = TypeDescriptors.get().kotlinNothing;
        if (nothing != null) {
            builder.put((Object)TypeDescriptors.get().kotlinNothing.getTypeDeclaration(), (Object)UNKNOWN.toNonNullable());
        }
        return builder.build();
    });

    ClosureTypesGenerator(ClosureGenerationEnvironment environment) {
        this.environment = environment;
    }

    public String getClosureTypeString(TypeDescriptor typeDescriptor) {
        Preconditions.checkArgument((!typeDescriptor.isIntersection() ? 1 : 0) != 0);
        return this.getClosureType(typeDescriptor).render();
    }

    public String getJsDocForParameter(MethodLike methodLike, int index) {
        MethodDescriptor methodDescriptor = methodLike.getDescriptor();
        MethodDescriptor.ParameterDescriptor parameterDescriptor = (MethodDescriptor.ParameterDescriptor)methodDescriptor.getParameterDescriptors().get(index);
        return this.toClosureTypeParameter(methodDescriptor, parameterDescriptor, parameterDescriptor.getTypeDescriptor()).render();
    }

    private ClosureType getClosureType(TypeDescriptor typeDescriptor) {
        if (typeDescriptor.isPrimitive()) {
            return this.getClosureTypeForPrimitive((PrimitiveTypeDescriptor)typeDescriptor);
        }
        if (typeDescriptor instanceof TypeVariable) {
            return this.getClosureTypeForTypeVariable((TypeVariable)typeDescriptor);
        }
        if (typeDescriptor.isArray()) {
            return this.getClosureTypeForArray((ArrayTypeDescriptor)typeDescriptor);
        }
        if (typeDescriptor.isUnion()) {
            return this.getClosureTypeForUnion((UnionTypeDescriptor)typeDescriptor);
        }
        if (typeDescriptor.isIntersection()) {
            return this.getClosureTypeForIntersection((IntersectionTypeDescriptor)typeDescriptor);
        }
        DeclaredTypeDescriptor declaredTypeDescriptor = (DeclaredTypeDescriptor)typeDescriptor;
        if ((declaredTypeDescriptor = this.replaceJsEnumArguments(declaredTypeDescriptor)).isJsFunctionInterface()) {
            return this.getClosureTypeForJsFunction(declaredTypeDescriptor);
        }
        return ClosureTypesGenerator.withNullability(this.getClosureTypeForDeclaration(declaredTypeDescriptor.getTypeDeclaration(), (List<ClosureType>)this.getClosureTypes((Collection<? extends TypeDescriptor>)declaredTypeDescriptor.getTypeArgumentDescriptors())), typeDescriptor.isNullable());
    }

    private DeclaredTypeDescriptor replaceJsEnumArguments(DeclaredTypeDescriptor typeDescriptor) {
        if (TypeDescriptors.isBoxedEnum((TypeDescriptor)typeDescriptor)) {
            return typeDescriptor;
        }
        ImmutableList replacedTypeArguments = (ImmutableList)typeDescriptor.getTypeArgumentDescriptors().stream().map(t -> AstUtils.isNonNativeJsEnum((TypeDescriptor)t) ? TypeDescriptors.getEnumBoxType((TypeDescriptor)t) : t).collect(ImmutableList.toImmutableList());
        if (replacedTypeArguments.equals((Object)typeDescriptor.getTypeArgumentDescriptors())) {
            return typeDescriptor;
        }
        ImmutableMap specializationMap = (ImmutableMap)Streams.zip((Stream)typeDescriptor.getTypeDeclaration().getTypeParameterDescriptors().stream(), (Stream)replacedTypeArguments.stream(), Maps::immutableEntry).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        return (DeclaredTypeDescriptor)typeDescriptor.toUnparameterizedTypeDescriptor().specializeTypeVariables((Map)specializationMap);
    }

    private ClosureType getClosureTypeForPrimitive(PrimitiveTypeDescriptor typeDescriptor) {
        if (TypeDescriptors.isPrimitiveLong((TypeDescriptor)typeDescriptor)) {
            return this.getClosureType((TypeDescriptor)TypeDescriptors.BootstrapType.NATIVE_LONG.getDescriptor()).toNonNullable();
        }
        if (TypeDescriptors.isPrimitiveBoolean((TypeDescriptor)typeDescriptor)) {
            return BOOLEAN;
        }
        if (TypeDescriptors.isPrimitiveVoid((TypeDescriptor)typeDescriptor)) {
            return VOID;
        }
        return NUMBER;
    }

    private ClosureType getClosureTypeForTypeVariable(TypeVariable typeVariable) {
        if (typeVariable.isWildcardOrCapture()) {
            return UNKNOWN;
        }
        return new ClosureNamedType(this.environment.getUniqueNameForVariable((HasName)typeVariable.toDeclaration()), new ClosureType[0]);
    }

    private ClosureType getClosureTypeForArray(ArrayTypeDescriptor typeDescriptor) {
        return ClosureTypesGenerator.withNullability(new ClosureNamedType("Array", this.getClosureType(typeDescriptor.getComponentTypeDescriptor())), typeDescriptor.isNullable());
    }

    private ClosureType getClosureTypeForUnion(UnionTypeDescriptor typeDescriptor) {
        return ClosureTypesGenerator.withNullability(new ClosureUnionType((Iterable<ClosureType>)this.getClosureTypes((Collection<? extends TypeDescriptor>)typeDescriptor.getUnionTypeDescriptors())), typeDescriptor.isNullable());
    }

    private ClosureType getClosureTypeForIntersection(IntersectionTypeDescriptor typeDescriptor) {
        return this.getClosureType(typeDescriptor.getFirstType());
    }

    private ClosureType getClosureTypeForJsFunction(DeclaredTypeDescriptor typeDescriptor) {
        Preconditions.checkArgument((boolean)typeDescriptor.isJsFunctionInterface());
        if (typeDescriptor.isRaw()) {
            HashSet typeParameterDescriptors = new HashSet(typeDescriptor.getTypeDeclaration().getTypeParameterDescriptors());
            typeDescriptor = typeDescriptor.toUnparameterizedTypeDescriptor().specializeTypeVariables(t -> typeParameterDescriptors.contains(t) ? TypeVariable.createWildcardWithUpperBound((TypeDescriptor)t.toRawTypeDescriptor()) : t);
        }
        MethodDescriptor functionalMethodDescriptor = typeDescriptor.getJsFunctionMethodDescriptor();
        Preconditions.checkState((boolean)functionalMethodDescriptor.getTypeParameterTypeDescriptors().isEmpty());
        return ClosureTypesGenerator.withNullability(new ClosureFunctionType((Iterable<ClosureFunctionType.Parameter>)this.toClosureTypeParameters(functionalMethodDescriptor), this.getClosureType(functionalMethodDescriptor.getReturnTypeDescriptor())), typeDescriptor.isNullable());
    }

    private ImmutableList<ClosureFunctionType.Parameter> toClosureTypeParameters(MethodDescriptor methodDescriptor) {
        return (ImmutableList)methodDescriptor.getParameterDescriptors().stream().map(parameterDescriptor -> this.toClosureTypeParameter(methodDescriptor, (MethodDescriptor.ParameterDescriptor)parameterDescriptor)).collect(ImmutableList.toImmutableList());
    }

    private ClosureFunctionType.Parameter toClosureTypeParameter(MethodDescriptor methodDescriptor, MethodDescriptor.ParameterDescriptor parameterDescriptor) {
        return this.toClosureTypeParameter(methodDescriptor, parameterDescriptor, parameterDescriptor.getTypeDescriptor());
    }

    private ClosureFunctionType.Parameter toClosureTypeParameter(MethodDescriptor methodDescriptor, MethodDescriptor.ParameterDescriptor parameterDescriptor, TypeDescriptor parameterTypeDescriptor) {
        boolean isJsVarargs = parameterDescriptor.isVarargs() && methodDescriptor.isJsMethodVarargs();
        boolean isOptional = parameterDescriptor.isJsOptional() && (methodDescriptor.isJsMember() || methodDescriptor.isJsFunction());
        parameterTypeDescriptor = isJsVarargs ? ((ArrayTypeDescriptor)parameterTypeDescriptor).getComponentTypeDescriptor() : parameterTypeDescriptor;
        return new ClosureFunctionType.Parameter(isJsVarargs, isOptional, this.getClosureType(parameterTypeDescriptor));
    }

    private ImmutableList<ClosureType> getClosureTypes(Collection<? extends TypeDescriptor> typeDescriptors) {
        return (ImmutableList)typeDescriptors.stream().map(this::getClosureType).collect(ImmutableList.toImmutableList());
    }

    private ClosureType getClosureTypeForDeclaration(TypeDeclaration typeDeclaration, List<ClosureType> typeParameters) {
        ClosureType closureType = ClosureTypesGenerator.maybeGetStandardClosureType(typeDeclaration);
        if (closureType != null) {
            return closureType;
        }
        DeclaredTypeDescriptor typeDescriptor = typeDeclaration.toRawTypeDescriptor();
        if (TypeDescriptors.isJavaLangComparable((TypeDescriptor)typeDescriptor)) {
            return new ClosureUnionType(new ClosureNamedType(this.environment.aliasForType(typeDeclaration), typeParameters), BOOLEAN, NUMBER, STRING);
        }
        if (TypeDescriptors.isJavaLangCharSequence((TypeDescriptor)typeDescriptor)) {
            return new ClosureUnionType(new ClosureNamedType(this.environment.aliasForType(typeDeclaration), typeParameters), STRING);
        }
        if (TypeDescriptors.isJavaLangNumber((TypeDescriptor)typeDescriptor)) {
            return new ClosureUnionType(new ClosureNamedType(this.environment.aliasForType(typeDeclaration), typeParameters), NUMBER);
        }
        if (TypeDescriptors.isJavaLangCloneable((TypeDescriptor)typeDescriptor) || TypeDescriptors.isJavaIoSerializable((TypeDescriptor)typeDescriptor)) {
            return new ClosureUnionType(new ClosureNamedType(this.environment.aliasForType(typeDeclaration), typeParameters), ARRAY);
        }
        if (specialClosureTypesByName.containsKey((Object)typeDeclaration.getQualifiedJsName())) {
            return (ClosureType)specialClosureTypesByName.get((Object)typeDeclaration.getQualifiedJsName());
        }
        if (typeDeclaration.getQualifiedJsName().equals("Object") && typeParameters.size() == 1) {
            return new ClosureNamedType(this.environment.aliasForType(typeDeclaration), (Iterable<ClosureType>)ImmutableList.builder().add((Object)STRING).addAll(typeParameters).build());
        }
        if (typeDeclaration.isJsEnum()) {
            return new ClosureNamedTypeWithUnknownNullability(this.environment.aliasForType(typeDeclaration)).toNullable();
        }
        return new ClosureNamedType(this.environment.aliasForType(typeDeclaration), typeParameters);
    }

    public static ClosureType maybeGetStandardClosureType(TypeDeclaration typeDeclaration) {
        return closureTypeByTypeDeclaration.get().get(typeDeclaration);
    }

    private static ClosureType withNullability(ClosureType type, boolean nullable) {
        return nullable ? type.toNullable() : type.toNonNullable();
    }

    private static class ClosureFunctionType
    extends ClosureType {
        private final ImmutableList<Parameter> parameters;
        private final ClosureType returnClosureType;

        ClosureFunctionType(Iterable<Parameter> parameters, ClosureType returnClosureType) {
            this.parameters = ImmutableList.copyOf(parameters);
            this.returnClosureType = returnClosureType;
        }

        @Override
        boolean isNullable() {
            return false;
        }

        @Override
        public String render() {
            return String.format("function(%s):%s", this.parameters.stream().map(Parameter::render).collect(Collectors.joining(", ")), this.returnClosureType.render());
        }

        private static class Parameter {
            private final boolean isVarargs;
            private final boolean isOptional;
            private final ClosureType closureType;

            Parameter(boolean isVarargs, boolean isOptional, ClosureType closureType) {
                Preconditions.checkArgument((!isVarargs || !isOptional ? 1 : 0) != 0);
                this.isVarargs = isVarargs;
                this.isOptional = isOptional;
                this.closureType = closureType;
            }

            String render() {
                Object[] args = new Object[]{this.isVarargs ? "..." : "", this.closureType.render(), this.isOptional ? "=" : ""};
                return String.format("%s%s%s", args);
            }
        }
    }

    private static class ClosureBangDecoratedType
    extends ClosureType {
        private final ClosureType type;

        ClosureBangDecoratedType(ClosureType type) {
            this.type = type;
        }

        @Override
        boolean isNullable() {
            return false;
        }

        @Override
        String render() {
            return "!" + this.type.render();
        }

        @Override
        ClosureType toNullable() {
            return this.type.toNullable();
        }

        @Override
        ClosureType toNonNullable() {
            return this;
        }
    }

    private static class ClosureWildcardDecoratedType
    extends ClosureType {
        private final ClosureType type;

        ClosureWildcardDecoratedType(ClosureType type) {
            this.type = type;
        }

        @Override
        boolean isNullable() {
            return true;
        }

        @Override
        String render() {
            return "?" + this.type.render();
        }

        @Override
        ClosureType toNullable() {
            return this;
        }

        @Override
        ClosureType toNonNullable() {
            return this.type.toNonNullable();
        }
    }

    private static class ClosureUnionType
    extends ClosureType {
        private final ImmutableList<ClosureType> types;

        ClosureUnionType(ClosureType ... types) {
            this(Arrays.asList(types));
        }

        ClosureUnionType(Iterable<ClosureType> types) {
            this.types = ImmutableList.copyOf(types);
        }

        @Override
        boolean isNullable() {
            return this.types.stream().anyMatch(ClosureType::isNullable);
        }

        @Override
        String render() {
            return this.types.stream().map(ClosureType::render).collect(Collectors.joining("|", "(", ")"));
        }
    }

    private static class ClosureNamedTypeWithUnknownNullability
    extends ClosureNamedType {
        ClosureNamedTypeWithUnknownNullability(String name) {
            super(name, new ClosureType[0]);
        }

        @Override
        ClosureType toNullable() {
            return new ClosureWildcardDecoratedType(this);
        }

        @Override
        ClosureType toNonNullable() {
            return new ClosureBangDecoratedType(this);
        }
    }

    private static class ClosureNamedType
    extends ClosureType {
        private final String name;
        private final ImmutableList<ClosureType> typeParameters;

        ClosureNamedType(String name, ClosureType ... typeParameters) {
            this(name, Arrays.asList(typeParameters));
        }

        ClosureNamedType(String name, Iterable<ClosureType> typeParameters) {
            this.name = name;
            this.typeParameters = ImmutableList.copyOf(typeParameters);
        }

        @Override
        boolean isNullable() {
            return true;
        }

        @Override
        String render() {
            return this.name + (this.typeParameters.isEmpty() ? "" : this.typeParameters.stream().map(ClosureType::render).collect(Collectors.joining(", ", "<", ">")));
        }
    }

    private static class ClosureUnknownType
    extends ClosureType {
        private ClosureUnknownType() {
        }

        @Override
        String render() {
            return "?";
        }

        @Override
        boolean isNullable() {
            return true;
        }

        @Override
        ClosureType toNullable() {
            return this;
        }

        @Override
        ClosureType toNonNullable() {
            return this;
        }
    }

    private static class ClosurePrimitiveType
    extends ClosureType {
        private final String type;
        private final boolean isNullable;

        ClosurePrimitiveType(String type, boolean isNullable) {
            this.type = type;
            this.isNullable = isNullable;
        }

        @Override
        boolean isNullable() {
            return this.isNullable;
        }

        @Override
        String render() {
            return this.type;
        }
    }

    private static abstract class ClosureType {
        private ClosureType() {
        }

        abstract boolean isNullable();

        abstract String render();

        ClosureType toNullable() {
            return this.isNullable() ? this : new ClosureWildcardDecoratedType(this);
        }

        ClosureType toNonNullable() {
            return this.isNullable() ? new ClosureBangDecoratedType(this) : this;
        }
    }
}

