/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.backend.closure;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.j2cl.common.SourcePosition;
import com.google.j2cl.common.visitor.Processor;
import com.google.j2cl.transpiler.ast.AbstractVisitor;
import com.google.j2cl.transpiler.ast.ArrayAccess;
import com.google.j2cl.transpiler.ast.ArrayLength;
import com.google.j2cl.transpiler.ast.ArrayLiteral;
import com.google.j2cl.transpiler.ast.ArrayTypeDescriptor;
import com.google.j2cl.transpiler.ast.AstUtils;
import com.google.j2cl.transpiler.ast.AwaitExpression;
import com.google.j2cl.transpiler.ast.BinaryExpression;
import com.google.j2cl.transpiler.ast.CastExpression;
import com.google.j2cl.transpiler.ast.ConditionalExpression;
import com.google.j2cl.transpiler.ast.DeclaredTypeDescriptor;
import com.google.j2cl.transpiler.ast.Expression;
import com.google.j2cl.transpiler.ast.ExpressionWithComment;
import com.google.j2cl.transpiler.ast.FieldAccess;
import com.google.j2cl.transpiler.ast.FunctionExpression;
import com.google.j2cl.transpiler.ast.HasName;
import com.google.j2cl.transpiler.ast.InstanceOfExpression;
import com.google.j2cl.transpiler.ast.JavaScriptConstructorReference;
import com.google.j2cl.transpiler.ast.JsDocCastExpression;
import com.google.j2cl.transpiler.ast.JsDocExpression;
import com.google.j2cl.transpiler.ast.Literal;
import com.google.j2cl.transpiler.ast.MemberReference;
import com.google.j2cl.transpiler.ast.MethodCall;
import com.google.j2cl.transpiler.ast.MethodDescriptor;
import com.google.j2cl.transpiler.ast.MethodLike;
import com.google.j2cl.transpiler.ast.MultiExpression;
import com.google.j2cl.transpiler.ast.NewArray;
import com.google.j2cl.transpiler.ast.NewInstance;
import com.google.j2cl.transpiler.ast.Node;
import com.google.j2cl.transpiler.ast.NumberLiteral;
import com.google.j2cl.transpiler.ast.PostfixExpression;
import com.google.j2cl.transpiler.ast.PrefixExpression;
import com.google.j2cl.transpiler.ast.PrefixOperator;
import com.google.j2cl.transpiler.ast.Statement;
import com.google.j2cl.transpiler.ast.SuperReference;
import com.google.j2cl.transpiler.ast.ThisReference;
import com.google.j2cl.transpiler.ast.TypeDescriptor;
import com.google.j2cl.transpiler.ast.TypeDescriptors;
import com.google.j2cl.transpiler.ast.TypeVariable;
import com.google.j2cl.transpiler.ast.Variable;
import com.google.j2cl.transpiler.ast.VariableDeclarationExpression;
import com.google.j2cl.transpiler.ast.VariableDeclarationFragment;
import com.google.j2cl.transpiler.ast.VariableReference;
import com.google.j2cl.transpiler.backend.closure.ClosureGenerationEnvironment;
import com.google.j2cl.transpiler.backend.closure.StatementTranspiler;
import com.google.j2cl.transpiler.backend.common.SourceBuilder;
import java.util.Collections;
import java.util.List;

public final class ExpressionTranspiler {
    public static void render(Expression expression, final ClosureGenerationEnvironment environment, final SourceBuilder sourceBuilder) {
        if (expression == null) {
            return;
        }
        new AbstractVisitor(){

            public boolean enterArrayAccess(ArrayAccess arrayAccess) {
                this.processLeftSubExpression((Expression)arrayAccess, arrayAccess.getArrayExpression());
                sourceBuilder.append("[");
                this.renderNoParens((Node)arrayAccess.getIndexExpression());
                sourceBuilder.append("]");
                return false;
            }

            public boolean enterArrayLength(ArrayLength arrayLength) {
                this.processLeftSubExpression((Expression)arrayLength, arrayLength.getArrayExpression());
                sourceBuilder.append(".length");
                return false;
            }

            public boolean enterArrayLiteral(ArrayLiteral arrayLiteral) {
                this.renderDelimitedAndCommaSeparated("[", "]", arrayLiteral.getValueExpressions());
                return false;
            }

            public boolean enterAwaitExpression(AwaitExpression awaitExpression) {
                sourceBuilder.append("await ");
                this.processRightSubExpression((Expression)awaitExpression, awaitExpression.getExpression());
                return false;
            }

            public boolean enterBinaryExpression(BinaryExpression expression) {
                this.processLeftSubExpression((Expression)expression, expression.getLeftOperand());
                sourceBuilder.append(" " + expression.getOperator() + " ");
                this.processRightSubExpression((Expression)expression, expression.getRightOperand());
                return false;
            }

            public boolean enterCastExpression(CastExpression castExpression) {
                Preconditions.checkArgument((boolean)false, (Object)(castExpression + " CastExpression should have been normalized to method call."));
                return false;
            }

            public boolean enterJsDocExpression(JsDocExpression jsDocExpression) {
                sourceBuilder.append(String.format("/**@%s*/ ", jsDocExpression.getAnnotation()));
                this.renderNoParens((Node)jsDocExpression.getExpression());
                return false;
            }

            public boolean enterJsDocCastExpression(JsDocCastExpression jsDocCastExpression) {
                String jsdoc = environment.getClosureTypeString(jsDocCastExpression.getTypeDescriptor());
                sourceBuilder.append("/**@type {" + jsdoc + "}*/ (");
                this.renderNoParens((Node)jsDocCastExpression.getExpression());
                sourceBuilder.append(")");
                return false;
            }

            public boolean enterExpressionWithComment(ExpressionWithComment expressionWithComment) {
                this.renderNoParens((Node)expressionWithComment.getExpression());
                sourceBuilder.append(" /* " + expressionWithComment.getComment() + " */");
                return false;
            }

            public boolean enterFieldAccess(FieldAccess fieldAccess) {
                String fieldMangledName = fieldAccess.getTarget().getMangledName();
                this.renderQualifiedName((Expression)fieldAccess, fieldMangledName, fieldAccess.getSourcePosition());
                return false;
            }

            public boolean enterFunctionExpression(FunctionExpression expression) {
                if (expression.isJsAsync()) {
                    sourceBuilder.append("async ");
                }
                this.emitParameters(expression);
                sourceBuilder.append(" =>");
                StatementTranspiler.render((Statement)expression.getBody(), environment, sourceBuilder);
                return false;
            }

            private void emitParameters(FunctionExpression expression) {
                List parameters = expression.getParameters();
                sourceBuilder.append("(");
                String separator = "";
                for (int i = 0; i < parameters.size(); ++i) {
                    sourceBuilder.append(separator);
                    this.emitParameter(expression, i);
                    separator = ", ";
                }
                sourceBuilder.append(")");
            }

            private void emitParameter(FunctionExpression expression, int i) {
                Variable parameter = (Variable)expression.getParameters().get(i);
                if (parameter == expression.getJsVarargsParameter()) {
                    sourceBuilder.append("...");
                }
                if (!this.isUnknownTypeParameter(expression, i)) {
                    sourceBuilder.append("/** " + environment.getJsDocForParameter((MethodLike)expression, i) + " */ ");
                }
                this.renderNoParens((Node)parameter);
            }

            private boolean isUnknownTypeParameter(FunctionExpression functionExpression, int i) {
                Variable parameter = (Variable)functionExpression.getParameters().get(i);
                TypeDescriptor parameterType = parameter.getTypeDescriptor();
                if (parameter == functionExpression.getJsVarargsParameter()) {
                    parameterType = ((ArrayTypeDescriptor)parameterType).getComponentTypeDescriptor();
                }
                return parameterType.isTypeVariable() && ((TypeVariable)parameterType).isWildcardOrCapture();
            }

            public boolean enterInstanceOfExpression(InstanceOfExpression expression) {
                this.processLeftSubExpression((Expression)expression, expression.getExpression());
                sourceBuilder.append(" instanceof ");
                sourceBuilder.append(environment.aliasForType((DeclaredTypeDescriptor)expression.getTestTypeDescriptor()));
                return false;
            }

            public boolean enterConditionalExpression(ConditionalExpression conditionalExpression) {
                this.processLeftSubExpression((Expression)conditionalExpression, conditionalExpression.getConditionExpression());
                sourceBuilder.append(" ? ");
                this.renderNoParens((Node)conditionalExpression.getTrueExpression());
                sourceBuilder.append(" : ");
                this.renderNoParens((Node)conditionalExpression.getFalseExpression());
                return false;
            }

            public boolean enterLiteral(Literal literal) {
                sourceBuilder.append(literal.getSourceText());
                return false;
            }

            public boolean enterMethodCall(MethodCall expression) {
                if (expression.isStaticDispatch()) {
                    this.renderStaticDispatchMethodCall(expression);
                } else if (expression.getTarget().isJsPropertyGetter()) {
                    this.renderJsPropertyAccess(expression);
                } else if (expression.getTarget().isJsPropertySetter()) {
                    this.renderJsPropertySetter(expression);
                } else {
                    this.renderMethodCallHeader(expression);
                    this.renderDelimitedAndCommaSeparated("(", ")", expression.getArguments());
                }
                return false;
            }

            private void renderStaticDispatchMethodCall(MethodCall expression) {
                MethodDescriptor methodDescriptor = expression.getTarget();
                String typeName = environment.aliasForType(methodDescriptor.getEnclosingTypeDescriptor());
                Object qualifier = methodDescriptor.isStatic() ? typeName : typeName + ".prototype";
                sourceBuilder.append(AstUtils.buildQualifiedName((String[])new String[]{qualifier, methodDescriptor.getMangledName(), "call"}));
                this.renderDelimitedAndCommaSeparated("(", ")", Iterables.concat(Collections.singletonList(expression.getQualifier()), (Iterable)expression.getArguments()));
            }

            private void renderQualifiedName(Expression enclosingExpression, String jsPropertyName) {
                this.renderQualifiedName(enclosingExpression, jsPropertyName, SourcePosition.NONE);
            }

            private void renderQualifiedName(Expression enclosingExpression, String jsPropertyName, SourcePosition sourcePosition) {
                Expression qualifier = ((MemberReference)enclosingExpression).getQualifier();
                if (this.shouldRenderQualifier(qualifier)) {
                    this.processLeftSubExpression(enclosingExpression, qualifier);
                    if (jsPropertyName.isEmpty()) {
                        return;
                    }
                    sourceBuilder.append(".");
                }
                sourceBuilder.emitWithMapping(sourcePosition, () -> sourceBuilder.append(jsPropertyName));
            }

            private boolean shouldRenderQualifier(Expression qualifier) {
                Preconditions.checkNotNull((Object)qualifier);
                if (!(qualifier instanceof JavaScriptConstructorReference)) {
                    return true;
                }
                JavaScriptConstructorReference constructorReference = (JavaScriptConstructorReference)qualifier;
                return constructorReference.getReferencedTypeDeclaration() != TypeDescriptors.get().globalNamespace.getTypeDeclaration();
            }

            private void renderJsPropertyAccess(MethodCall expression) {
                this.renderQualifiedName((Expression)expression, expression.getTarget().getSimpleJsName());
            }

            private void renderJsPropertySetter(MethodCall expression) {
                this.renderJsPropertyAccess(expression);
                sourceBuilder.append(" = ");
                this.renderNoParens((Node)expression.getArguments().get(0));
            }

            private void renderMethodCallHeader(MethodCall expression) {
                Preconditions.checkArgument((!expression.isStaticDispatch() ? 1 : 0) != 0);
                MethodDescriptor target = expression.getTarget();
                if (target.isConstructor()) {
                    sourceBuilder.append("super");
                } else if (target.isJsFunction()) {
                    this.processLeftSubExpression((Expression)expression, expression.getQualifier());
                } else {
                    this.renderQualifiedName((Expression)expression, target.getMangledName());
                }
            }

            public boolean enterMultiExpression(MultiExpression multiExpression) {
                List expressions = multiExpression.getExpressions();
                if (expressions.stream().anyMatch(Predicates.instanceOf(VariableDeclarationExpression.class))) {
                    sourceBuilder.append("( () => {");
                    for (Expression expression : expressions.subList(0, expressions.size() - 1)) {
                        this.renderNoParens((Node)expression);
                        sourceBuilder.append(";");
                    }
                    Expression returnValue = (Expression)Iterables.getLast((Iterable)expressions);
                    sourceBuilder.append(" return ");
                    this.renderNoParens((Node)returnValue);
                    sourceBuilder.append(";})()");
                } else {
                    Preconditions.checkArgument((expressions.size() > 1 ? 1 : 0) != 0);
                    this.renderDelimitedAndCommaSeparated("(", ")", expressions);
                }
                return false;
            }

            public boolean enterNewArray(NewArray newArrayExpression) {
                Preconditions.checkArgument((boolean)false, (Object)"NewArray should have been normalized.");
                return false;
            }

            public boolean enterNewInstance(NewInstance expression) {
                Preconditions.checkArgument((expression.getQualifier() == null ? 1 : 0) != 0);
                DeclaredTypeDescriptor targetTypeDescriptor = expression.getTarget().getEnclosingTypeDescriptor().toRawTypeDescriptor();
                sourceBuilder.append("new " + environment.aliasForType(targetTypeDescriptor));
                this.renderDelimitedAndCommaSeparated("(", ")", expression.getArguments());
                return false;
            }

            public boolean enterNumberLiteral(NumberLiteral numberLiteral) {
                Number value = numberLiteral.getValue();
                if (Double.compare(value.intValue(), value.doubleValue()) == 0) {
                    sourceBuilder.append(Integer.toString(value.intValue()));
                } else {
                    sourceBuilder.append(value.toString());
                }
                return false;
            }

            public boolean enterPostfixExpression(PostfixExpression expression) {
                Preconditions.checkArgument((!TypeDescriptors.isPrimitiveLong((TypeDescriptor)expression.getTypeDescriptor()) ? 1 : 0) != 0);
                this.processLeftSubExpression((Expression)expression, expression.getOperand());
                sourceBuilder.append(expression.getOperator().toString());
                return false;
            }

            public boolean enterPrefixExpression(PrefixExpression expression) {
                PrefixOperator operator = expression.getOperator();
                sourceBuilder.append(operator.toString());
                if (operator == PrefixOperator.PLUS || operator == PrefixOperator.MINUS) {
                    sourceBuilder.append(" ");
                }
                this.processRightSubExpression((Expression)expression, expression.getOperand());
                return false;
            }

            public boolean enterSuperReference(SuperReference expression) {
                sourceBuilder.append("super");
                return false;
            }

            public boolean enterThisReference(ThisReference expression) {
                sourceBuilder.append("this");
                return false;
            }

            public boolean enterJavaScriptConstructorReference(JavaScriptConstructorReference constructorReference) {
                sourceBuilder.append(environment.aliasForType(constructorReference.getReferencedTypeDeclaration()));
                return false;
            }

            public boolean enterVariableDeclarationExpression(VariableDeclarationExpression variableDeclarationExpression) {
                this.renderDelimitedAndCommaSeparated("let ", "", variableDeclarationExpression.getFragments());
                return false;
            }

            public boolean enterVariableDeclarationFragment(VariableDeclarationFragment fragment) {
                Variable variable = fragment.getVariable();
                if (fragment.needsTypeDeclaration()) {
                    sourceBuilder.append("/** " + environment.getClosureTypeString(variable.getTypeDescriptor()) + " */ ");
                }
                this.renderNoParens((Node)variable);
                if (fragment.getInitializer() != null) {
                    sourceBuilder.append(" = ");
                    this.renderNoParens((Node)fragment.getInitializer());
                }
                return false;
            }

            public boolean enterVariable(Variable variable) {
                sourceBuilder.emitWithMapping(AstUtils.removeUnnamedSourcePosition((SourcePosition)variable.getSourcePosition()), () -> sourceBuilder.append(environment.getUniqueNameForVariable((HasName)variable)));
                return false;
            }

            public boolean enterVariableReference(VariableReference expression) {
                sourceBuilder.append(environment.getUniqueNameForVariable((HasName)expression.getTarget()));
                return false;
            }

            private void renderDelimitedAndCommaSeparated(String prefix, String suffix, Iterable<? extends Node> nodes) {
                sourceBuilder.append(prefix);
                this.renderCommaSeparated(nodes);
                sourceBuilder.append(suffix);
            }

            private void renderCommaSeparated(Iterable<? extends Node> nodes) {
                String separator = ", ";
                String currentSeparator = "";
                for (Node node : nodes) {
                    if (node == null) continue;
                    sourceBuilder.append(currentSeparator);
                    currentSeparator = separator;
                    this.renderNoParens(node);
                }
            }

            private void processLeftSubExpression(Expression expression, Expression operand) {
                this.renderExpression(operand, expression.requiresParensOnLeft(operand));
            }

            private void processRightSubExpression(Expression expression, Expression operand) {
                this.renderExpression(operand, expression.requiresParensOnRight(operand));
            }

            private void renderExpression(Expression expression, boolean needsParentheses) {
                if (needsParentheses) {
                    sourceBuilder.append("(");
                    this.renderNoParens((Node)expression);
                    sourceBuilder.append(")");
                } else {
                    this.renderNoParens((Node)expression);
                }
            }

            private void renderNoParens(Node node) {
                node.accept((Processor)this);
            }
        }.renderNoParens((Node)expression);
    }

    private ExpressionTranspiler() {
    }
}

