/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.backend.closure;

import com.google.j2cl.transpiler.ast.TypeDeclaration;

class Import
implements Comparable<Import> {
    private final String alias;
    private final TypeDeclaration typeDeclaration;
    private final ImportCategory importCategory;

    Import(String alias, TypeDeclaration typeDeclaration, ImportCategory importCategory) {
        this.alias = alias;
        this.typeDeclaration = typeDeclaration;
        this.importCategory = importCategory;
    }

    public String getAlias() {
        return this.alias;
    }

    public ImportCategory getImportCategory() {
        return this.importCategory;
    }

    public String getImplModulePath() {
        return this.typeDeclaration.getImplModuleName();
    }

    public String getHeaderModulePath() {
        return this.typeDeclaration.getModuleName();
    }

    public TypeDeclaration getElement() {
        return this.typeDeclaration;
    }

    @Override
    public int compareTo(Import that) {
        return this.getImplModulePath().compareTo(that.getImplModulePath());
    }

    public String toString() {
        return this.alias + " => " + this.typeDeclaration + " (" + this.importCategory + ")";
    }

    public static enum ImportCategory {
        EXTERN,
        SELF,
        LOADTIME,
        RUNTIME,
        JSDOC,
        AJD_DEPENDENCY;


        public boolean needsGoogRequireInHeader() {
            return this == LOADTIME || this == RUNTIME || this == JSDOC || this == AJD_DEPENDENCY;
        }

        public boolean needsGoogRequireInImpl() {
            return this == LOADTIME;
        }

        public boolean needsGoogForwardDeclare() {
            return this == RUNTIME || this == JSDOC;
        }

        public boolean needsGoogModuleGet() {
            return this == RUNTIME;
        }

        boolean strongerThan(ImportCategory other) {
            return this.compareTo(other) < 0;
        }
    }
}

