/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.backend.closure;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.j2cl.common.visitor.Processor;
import com.google.j2cl.transpiler.ast.AbstractVisitor;
import com.google.j2cl.transpiler.ast.ArrayTypeDescriptor;
import com.google.j2cl.transpiler.ast.AstUtils;
import com.google.j2cl.transpiler.ast.DeclaredTypeDescriptor;
import com.google.j2cl.transpiler.ast.FieldAccess;
import com.google.j2cl.transpiler.ast.FieldDeclarationStatement;
import com.google.j2cl.transpiler.ast.FieldDescriptor;
import com.google.j2cl.transpiler.ast.FunctionExpression;
import com.google.j2cl.transpiler.ast.InstanceOfExpression;
import com.google.j2cl.transpiler.ast.IntersectionTypeDescriptor;
import com.google.j2cl.transpiler.ast.JavaScriptConstructorReference;
import com.google.j2cl.transpiler.ast.JsDocCastExpression;
import com.google.j2cl.transpiler.ast.MemberDescriptor;
import com.google.j2cl.transpiler.ast.Method;
import com.google.j2cl.transpiler.ast.MethodCall;
import com.google.j2cl.transpiler.ast.MethodDescriptor;
import com.google.j2cl.transpiler.ast.NewInstance;
import com.google.j2cl.transpiler.ast.Type;
import com.google.j2cl.transpiler.ast.TypeDeclaration;
import com.google.j2cl.transpiler.ast.TypeDescriptor;
import com.google.j2cl.transpiler.ast.TypeDescriptors;
import com.google.j2cl.transpiler.ast.TypeVariable;
import com.google.j2cl.transpiler.ast.UnionTypeDescriptor;
import com.google.j2cl.transpiler.ast.Variable;
import com.google.j2cl.transpiler.ast.VariableDeclarationFragment;
import com.google.j2cl.transpiler.backend.closure.ClosureTypesGenerator;
import com.google.j2cl.transpiler.backend.closure.Import;
import com.google.j2cl.transpiler.backend.closure.JsKeywords;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ImportGatherer
extends AbstractVisitor {
    private final Set<String> localNameUses = new HashSet<String>();
    private final Set<TypeDescriptor> collectedForJsDoc = new HashSet<TypeDescriptor>();
    private final Map<TypeDeclaration, Import.ImportCategory> categoryForTypeDeclaration = new LinkedHashMap<TypeDeclaration, Import.ImportCategory>();
    private static final ImmutableMap<String, String> ABBREVIATED_WELL_KNOWN_PACKAGES = ImmutableMap.of((Object)"java.lang", (Object)"j.l", (Object)"java.util", (Object)"j.u", (Object)"com.google.common", (Object)"c.g.c", (Object)"com.google", (Object)"c.g");

    public static List<Import> gatherImports(Type type) {
        return new ImportGatherer().doGatherImports(type);
    }

    private ImportGatherer() {
    }

    public void exitFunctionExpression(FunctionExpression functionExpression) {
        for (Variable parameter : functionExpression.getParameters()) {
            this.collectForJsDoc(parameter.getTypeDescriptor());
        }
    }

    public void exitType(Type type) {
        this.addTypeDeclaration(type.getDeclaration(), Import.ImportCategory.SELF);
        if (type.isOverlayImplementation() && type.getOverlaidTypeDeclaration().isNative()) {
            this.collectImportsFromNativeType(type.getOverlaidTypeDeclaration());
        }
        if (type.getSuperTypeDescriptor() != null) {
            this.addTypeDeclaration(type.getSuperTypeDescriptor().getTypeDeclaration(), Import.ImportCategory.LOADTIME);
        }
        type.getSuperTypesStream().forEach(this::collectForJsDoc);
    }

    private void collectImportsFromNativeType(TypeDeclaration nativeType) {
        this.addTypeDeclaration(nativeType, Import.ImportCategory.LOADTIME);
        nativeType.toUnparameterizedTypeDescriptor().getDeclaredMemberDescriptors().stream().filter(m -> !m.isJsOverlay()).forEach(m -> {
            this.maybeAddNativeReference((MemberDescriptor)m);
            if (m.isMethod()) {
                this.collectForJsDoc(((MethodDescriptor)m).getReturnTypeDescriptor());
            } else if (m.isField()) {
                this.collectForJsDoc(((FieldDescriptor)m).getTypeDescriptor());
            }
        });
    }

    public void exitJsDocCastExpression(JsDocCastExpression jsDocCastExpression) {
        this.collectForJsDoc(jsDocCastExpression.getTypeDescriptor());
    }

    public void exitFieldDeclarationStatement(FieldDeclarationStatement fieldDeclarationStatement) {
        this.collectForJsDoc(fieldDeclarationStatement.getFieldDescriptor().getTypeDescriptor());
    }

    public void exitVariableDeclarationFragment(VariableDeclarationFragment variableDeclarationFragment) {
        if (variableDeclarationFragment.needsTypeDeclaration()) {
            Variable variable = variableDeclarationFragment.getVariable();
            this.collectForJsDoc(variable.getTypeDescriptor());
        }
    }

    public void exitMethod(Method method) {
        MethodDescriptor methodDescriptor = method.getDescriptor();
        this.maybeAddNativeReference((MemberDescriptor)methodDescriptor);
        this.collectForJsDoc(methodDescriptor.getReturnTypeDescriptor());
        methodDescriptor.getParameterTypeDescriptors().forEach(this::collectForJsDoc);
    }

    private void maybeAddNativeReference(MemberDescriptor memberDescriptor) {
        if (memberDescriptor.hasJsNamespace() && !memberDescriptor.isExtern()) {
            this.addTypeDeclaration(AstUtils.getNamespaceAsTypeDescriptor((MemberDescriptor)memberDescriptor).getTypeDeclaration(), Import.ImportCategory.JSDOC);
        }
    }

    public void exitFieldAccess(FieldAccess fieldAccess) {
        FieldDescriptor memberDescriptor = fieldAccess.getTarget();
        if (memberDescriptor.isExtern()) {
            this.addExternTypeDeclaration(memberDescriptor.getQualifiedJsName());
        }
    }

    public void exitMethodCall(MethodCall methodCall) {
        MethodDescriptor methodDescriptor = methodCall.getTarget();
        if (methodCall.isStaticDispatch()) {
            this.addTypeDeclaration(methodDescriptor.getEnclosingTypeDescriptor().getTypeDeclaration());
        }
        if (methodDescriptor.isExtern()) {
            this.addExternTypeDeclaration(methodDescriptor.getQualifiedJsName());
        }
    }

    public void exitNewInstance(NewInstance newInstance) {
        this.addTypeDeclaration(newInstance.getTarget().getEnclosingTypeDescriptor().getTypeDeclaration());
    }

    public void exitInstanceOfExpression(InstanceOfExpression instanceOfExpression) {
        DeclaredTypeDescriptor testTypeDescriptor = (DeclaredTypeDescriptor)instanceOfExpression.getTestTypeDescriptor();
        this.addTypeDeclaration(testTypeDescriptor.getTypeDeclaration());
    }

    public void exitJavaScriptConstructorReference(JavaScriptConstructorReference constructorReference) {
        TypeDeclaration referencedTypeDeclaration = constructorReference.getReferencedTypeDeclaration();
        if (referencedTypeDeclaration == TypeDescriptors.get().globalNamespace.getTypeDeclaration()) {
            return;
        }
        this.addTypeDeclaration(referencedTypeDeclaration);
    }

    private void collectForJsDoc(TypeDescriptor typeDescriptor) {
        if (!this.collectedForJsDoc.add(typeDescriptor)) {
            return;
        }
        if (TypeDescriptors.isPrimitiveLong((TypeDescriptor)typeDescriptor)) {
            this.collectForJsDoc((TypeDescriptor)TypeDescriptors.BootstrapType.NATIVE_LONG.getDescriptor());
            return;
        }
        if (typeDescriptor.isPrimitive()) {
            return;
        }
        if (typeDescriptor.isArray()) {
            ArrayTypeDescriptor arrayTypeDescriptor = (ArrayTypeDescriptor)typeDescriptor;
            this.collectForJsDoc(arrayTypeDescriptor.getLeafTypeDescriptor());
            return;
        }
        if (typeDescriptor.isUnion()) {
            UnionTypeDescriptor unionTypeDescriptor = (UnionTypeDescriptor)typeDescriptor;
            unionTypeDescriptor.getUnionTypeDescriptors().forEach(this::collectForJsDoc);
            return;
        }
        if (typeDescriptor instanceof TypeVariable) {
            this.collectTypeDescriptorsIntroducedByTypeBounds((TypeVariable)typeDescriptor);
            return;
        }
        if (typeDescriptor.isIntersection()) {
            IntersectionTypeDescriptor intersectionTypeDescriptor = (IntersectionTypeDescriptor)typeDescriptor;
            intersectionTypeDescriptor.getIntersectionTypeDescriptors().forEach(this::collectForJsDoc);
            return;
        }
        DeclaredTypeDescriptor declaredTypeDescriptor = (DeclaredTypeDescriptor)typeDescriptor;
        if (ClosureTypesGenerator.maybeGetStandardClosureType(declaredTypeDescriptor.getTypeDeclaration()) != null) {
            return;
        }
        if (declaredTypeDescriptor.hasOverlayImplementationType()) {
            this.addTypeDeclaration(declaredTypeDescriptor.getOverlayImplementationTypeDescriptor().getTypeDeclaration(), Import.ImportCategory.AJD_DEPENDENCY);
        }
        if (AstUtils.isNonNativeJsEnum((TypeDescriptor)typeDescriptor)) {
            this.collectForJsDoc(TypeDescriptors.getEnumBoxType((TypeDescriptor)typeDescriptor.toRawTypeDescriptor()));
        }
        if (declaredTypeDescriptor.isJsFunctionInterface()) {
            this.collectTypeDescriptorsIntroducedByJsFunction(declaredTypeDescriptor);
            return;
        }
        declaredTypeDescriptor.getTypeArgumentDescriptors().forEach(this::collectForJsDoc);
        this.addTypeDeclaration(declaredTypeDescriptor.getTypeDeclaration(), Import.ImportCategory.JSDOC);
    }

    private void collectTypeDescriptorsIntroducedByJsFunction(DeclaredTypeDescriptor typeDescriptor) {
        Preconditions.checkState((boolean)typeDescriptor.isJsFunctionInterface());
        MethodDescriptor jsFunctionMethodDescriptor = typeDescriptor.getJsFunctionMethodDescriptor();
        for (TypeDescriptor parameterTypeDescriptor : jsFunctionMethodDescriptor.getParameterTypeDescriptors()) {
            this.collectForJsDoc(parameterTypeDescriptor);
        }
        this.collectForJsDoc(jsFunctionMethodDescriptor.getReturnTypeDescriptor());
    }

    private void collectTypeDescriptorsIntroducedByTypeBounds(TypeVariable typeVariable) {
        TypeDescriptor boundTypeDescriptor = typeVariable.getUpperBoundTypeDescriptor();
        if (TypeDescriptors.isJavaLangObject((TypeDescriptor)boundTypeDescriptor)) {
            return;
        }
        this.collectForJsDoc(boundTypeDescriptor);
    }

    private void addTypeDeclaration(TypeDeclaration typeDeclaration) {
        this.addTypeDeclaration(typeDeclaration, this.getImplicitImportCategory());
    }

    private void addTypeDeclaration(TypeDeclaration typeDeclaration, Import.ImportCategory importCategory) {
        Preconditions.checkArgument((!typeDeclaration.isJsFunctionInterface() ? 1 : 0) != 0);
        Preconditions.checkArgument((!typeDeclaration.getQualifiedJsName().isEmpty() ? 1 : 0) != 0);
        this.categoryForTypeDeclaration.merge(typeDeclaration.getEnclosingModule(), typeDeclaration.isExtern() ? Import.ImportCategory.EXTERN : importCategory, (existing, other) -> existing == null || other.strongerThan((Import.ImportCategory)((Object)existing)) ? other : existing);
        if (typeDeclaration.isExtern()) {
            this.localNameUses.add(typeDeclaration.getEnclosingModule().getQualifiedJsName());
        }
    }

    private Import.ImportCategory getImplicitImportCategory() {
        if (this.getCurrentMember() == null) {
            return Import.ImportCategory.LOADTIME;
        }
        if (this.getCurrentMember().isField()) {
            return Import.ImportCategory.LOADTIME;
        }
        if (this.getCurrentMember().getDescriptor().getOrigin().isSyntheticInstanceOfSupportMember()) {
            return Import.ImportCategory.LOADTIME;
        }
        return Import.ImportCategory.RUNTIME;
    }

    private void addExternTypeDeclaration(String qualifiedJsName) {
        String topScopeQualifier = (String)Iterables.get((Iterable)Splitter.on((char)'.').split((CharSequence)qualifiedJsName), (int)0);
        this.addTypeDeclaration(TypeDescriptors.createGlobalNativeTypeDescriptor((String)topScopeQualifier, (TypeDescriptor[])new TypeDescriptor[0]).getTypeDeclaration());
    }

    private ImmutableList<Import> doGatherImports(Type type) {
        type.accept((Processor)this);
        return (ImmutableList)this.categoryForTypeDeclaration.entrySet().stream().map(entry -> this.createImport((TypeDeclaration)entry.getKey(), (Import.ImportCategory)((Object)((Object)entry.getValue())))).sorted().collect(ImmutableList.toImmutableList());
    }

    private Import createImport(TypeDeclaration typeDeclaration, Import.ImportCategory importCategory) {
        return new Import(this.computeAlias(typeDeclaration), typeDeclaration, importCategory);
    }

    private String computeAlias(TypeDeclaration typeDeclaration) {
        if (typeDeclaration.isExtern()) {
            return typeDeclaration.getQualifiedJsName();
        }
        Object nameComponents = ImmutableList.builder().add((Object)ImportGatherer.getAbbreviatedPackageName(typeDeclaration)).addAll(this.getClassComponents(typeDeclaration)).build();
        String proposedAlias = null;
        do {
            Preconditions.checkState((!nameComponents.isEmpty() ? 1 : 0) != 0);
            String lastComponent = (String)Iterables.getLast((Iterable)nameComponents);
            proposedAlias = Joiner.on((char)'_').skipNulls().join((Object)lastComponent, proposedAlias, new Object[0]);
            nameComponents = nameComponents.subList(0, nameComponents.size() - 1);
        } while (this.localNameUses.contains(proposedAlias) || !JsKeywords.isKeyword(proposedAlias));
        this.localNameUses.add(proposedAlias);
        return proposedAlias;
    }

    private ImmutableList<String> getClassComponents(TypeDeclaration typeDeclaration) {
        if (typeDeclaration.getQualifiedJsName().startsWith("vmbootstrap.") || typeDeclaration.getQualifiedJsName().startsWith("nativebootstrap.")) {
            return ImmutableList.of((Object)("$" + String.join((CharSequence)"_", (Iterable<? extends CharSequence>)typeDeclaration.getClassComponents())));
        }
        return (ImmutableList)typeDeclaration.getClassComponents().stream().map(component -> component.replace("_", "__")).map(component -> !Character.isJavaIdentifierStart(component.charAt(0)) ? "$" + component : component).collect(ImmutableList.toImmutableList());
    }

    private static String getAbbreviatedPackageName(TypeDeclaration typeDeclaration) {
        Object packageName = typeDeclaration.getPackageName();
        for (String prefix : ABBREVIATED_WELL_KNOWN_PACKAGES.keySet()) {
            if (!((String)packageName).startsWith(prefix)) continue;
            packageName = (String)ABBREVIATED_WELL_KNOWN_PACKAGES.get((Object)prefix) + ((String)packageName).substring(prefix.length());
            break;
        }
        return ((String)packageName).replace('.', '_');
    }
}

