/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.backend.closure;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.j2cl.common.Problems;
import com.google.j2cl.common.SourcePosition;
import com.google.j2cl.transpiler.ast.MemberDescriptor;
import com.google.j2cl.transpiler.ast.Type;
import com.google.j2cl.transpiler.backend.closure.ClosureGenerationEnvironment;
import com.google.j2cl.transpiler.backend.closure.Import;
import com.google.j2cl.transpiler.backend.closure.JsKeywords;
import com.google.j2cl.transpiler.backend.common.SourceBuilder;
import com.google.j2cl.transpiler.backend.common.UniqueNamesResolver;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class JavaScriptGenerator {
    protected final Type type;
    protected final ClosureGenerationEnvironment environment;
    protected final List<Import> imports;
    protected final SourceBuilder sourceBuilder = new SourceBuilder();
    protected final Problems problems;

    public JavaScriptGenerator(Problems problems, Type type, List<Import> imports) {
        this.problems = problems;
        this.type = type;
        this.imports = imports;
        ImmutableSet namesUsedInAliases = (ImmutableSet)imports.stream().map(anImport -> (String)Iterables.get((Iterable)Splitter.onPattern((String)"\\\\.").split((CharSequence)anImport.getAlias()), (int)0)).collect(ImmutableSet.toImmutableSet());
        Map uniqueNameByVariable = UniqueNamesResolver.computeUniqueNames((Set)Sets.union((Set)namesUsedInAliases, JsKeywords.getKeywords()), (Type)type);
        this.environment = new ClosureGenerationEnvironment(imports, uniqueNameByVariable);
    }

    public Map<SourcePosition, SourcePosition> getSourceMappings() {
        return this.sourceBuilder.getMappings();
    }

    public Map<MemberDescriptor, SourcePosition> getOutputSourceInfoByMember() {
        return this.sourceBuilder.getOutputSourceInfoByMember();
    }

    abstract String renderOutput();

    abstract String getSuffix();

    void renderSuppressions(String ... suppressions) {
        Preconditions.checkArgument((suppressions.length > 0 ? 1 : 0) != 0);
        this.sourceBuilder.appendLines(new String[]{"/** @fileoverview @suppress {" + Joiner.on((String)", ").join((Object[])suppressions) + "} */"});
        this.sourceBuilder.newLine();
    }
}

