/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.backend.closure;

import com.google.j2cl.common.Problems;
import com.google.j2cl.transpiler.ast.Type;
import com.google.j2cl.transpiler.ast.TypeDeclaration;
import com.google.j2cl.transpiler.backend.closure.Import;
import com.google.j2cl.transpiler.backend.closure.JavaScriptGenerator;
import java.util.HashSet;
import java.util.List;

public class JavaScriptHeaderGenerator
extends JavaScriptGenerator {
    public static final String FILE_SUFFIX = ".java.js";

    public JavaScriptHeaderGenerator(Problems problems, Type type, List<Import> imports) {
        super(problems, type, imports);
    }

    @Override
    public String renderOutput() {
        TypeDeclaration typeDeclaration = this.type.getDeclaration();
        this.sourceBuilder.append("goog.module(");
        this.sourceBuilder.emitWithMapping(this.type.getSourcePosition(), () -> this.sourceBuilder.append("'" + typeDeclaration.getModuleName() + "'"));
        this.sourceBuilder.append(");");
        this.sourceBuilder.newLine();
        this.sourceBuilder.newLine();
        HashSet<String> alreadyRequiredPaths = new HashSet<String>();
        alreadyRequiredPaths.add(this.type.getDeclaration().getQualifiedJsName());
        this.imports.stream().filter(i -> i.getImportCategory().needsGoogRequireInHeader()).forEach(headerImport -> {
            String path = headerImport.getHeaderModulePath();
            if (alreadyRequiredPaths.add(path)) {
                this.sourceBuilder.appendln("goog.require('" + path + "');");
            }
        });
        this.sourceBuilder.newLine();
        String className = this.environment.aliasForType(this.type.getDeclaration());
        String implementationPath = typeDeclaration.getImplModuleName();
        this.sourceBuilder.appendLines(new String[]{"const " + className + " = goog.require('" + implementationPath + "');"});
        this.sourceBuilder.newLine();
        if (this.type.isOverlayImplementation()) {
            this.sourceBuilder.appendln("/** @nodts */");
        }
        this.sourceBuilder.emitWithMapping(this.type.getSourcePosition(), () -> this.sourceBuilder.append("exports"));
        this.sourceBuilder.appendln(" = " + className + ";");
        return this.sourceBuilder.build();
    }

    @Override
    public String getSuffix() {
        return FILE_SUFFIX;
    }
}

