/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.backend.closure;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.j2cl.common.FilePosition;
import com.google.j2cl.common.InternalCompilerError;
import com.google.j2cl.common.Problems;
import com.google.j2cl.common.SourcePosition;
import com.google.j2cl.transpiler.ast.AstUtils;
import com.google.j2cl.transpiler.ast.DeclaredTypeDescriptor;
import com.google.j2cl.transpiler.ast.Field;
import com.google.j2cl.transpiler.ast.HasName;
import com.google.j2cl.transpiler.ast.MemberDescriptor;
import com.google.j2cl.transpiler.ast.Method;
import com.google.j2cl.transpiler.ast.MethodDescriptor;
import com.google.j2cl.transpiler.ast.MethodLike;
import com.google.j2cl.transpiler.ast.Statement;
import com.google.j2cl.transpiler.ast.Type;
import com.google.j2cl.transpiler.ast.TypeDeclaration;
import com.google.j2cl.transpiler.ast.TypeDescriptor;
import com.google.j2cl.transpiler.ast.TypeDescriptors;
import com.google.j2cl.transpiler.ast.TypeVariable;
import com.google.j2cl.transpiler.ast.Variable;
import com.google.j2cl.transpiler.ast.Visibility;
import com.google.j2cl.transpiler.backend.closure.ClosureTypesGenerator;
import com.google.j2cl.transpiler.backend.closure.ExpressionTranspiler;
import com.google.j2cl.transpiler.backend.closure.Import;
import com.google.j2cl.transpiler.backend.closure.JavaScriptGenerator;
import com.google.j2cl.transpiler.backend.closure.NativeJavaScriptFile;
import com.google.j2cl.transpiler.backend.closure.StatementTranspiler;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class JavaScriptImplGenerator
extends JavaScriptGenerator {
    private NativeJavaScriptFile nativeSource;
    private final ClosureTypesGenerator closureTypesGenerator;
    public static final String FILE_SUFFIX = ".impl.java.js";

    public JavaScriptImplGenerator(Problems problems, Type type, List<Import> imports) {
        super(problems, type, imports);
        this.closureTypesGenerator = new ClosureTypesGenerator(this.environment);
    }

    private static String getMethodQualifiers(MethodDescriptor methodDescriptor) {
        String staticQualifier;
        String string = staticQualifier = methodDescriptor.isStatic() ? "static " : "";
        if (!methodDescriptor.isAbstract() && methodDescriptor.isJsAsync()) {
            return staticQualifier + "async ";
        }
        return staticQualifier;
    }

    private void emitMethodHeader(Method method) {
        MethodDescriptor methodDescriptor = method.getDescriptor();
        this.sourceBuilder.append(JavaScriptImplGenerator.getMethodQualifiers(methodDescriptor));
        this.sourceBuilder.emitWithMapping(method.getSourcePosition(), () -> this.sourceBuilder.append(methodDescriptor.getMangledName()));
        this.sourceBuilder.append("(");
        String separator = "";
        for (int i = 0; i < method.getParameters().size(); ++i) {
            this.sourceBuilder.append(separator);
            this.emitParameter((MethodLike)method, i);
            separator = ", ";
        }
        this.sourceBuilder.append(") ");
    }

    private void emitParameter(MethodLike expression, int i) {
        Variable parameter = (Variable)expression.getParameters().get(i);
        if (parameter == expression.getJsVarargsParameter()) {
            this.sourceBuilder.append("...");
        }
        this.sourceBuilder.append("/** " + this.closureTypesGenerator.getJsDocForParameter(expression, i) + " */ ");
        this.sourceBuilder.emitWithMapping(AstUtils.removeUnnamedSourcePosition((SourcePosition)parameter.getSourcePosition()), () -> this.sourceBuilder.append(this.environment.getUniqueNameForVariable((HasName)parameter)));
    }

    @Override
    public String getSuffix() {
        return FILE_SUFFIX;
    }

    public void setNativeSource(NativeJavaScriptFile nativeSource) {
        this.nativeSource = (NativeJavaScriptFile)Preconditions.checkNotNull((Object)nativeSource);
    }

    @Override
    public String renderOutput() {
        try {
            this.renderImports();
            if (this.type.isJsEnum()) {
                this.renderClosureEnum();
            } else {
                this.renderClass();
            }
            this.renderExports();
            return this.sourceBuilder.build();
        }
        catch (RuntimeException e) {
            throw new InternalCompilerError((Throwable)e, "Error generating source for type %s.", new Object[]{this.type.getDeclaration().getQualifiedBinaryName()});
        }
    }

    private void renderClosureEnum() {
        TypeDeclaration typeDeclaration = this.type.getDeclaration();
        this.sourceBuilder.append("/** @enum {" + this.closureTypesGenerator.getClosureTypeString(AstUtils.getJsEnumValueFieldType((TypeDeclaration)typeDeclaration)) + "}");
        if (this.type.getDeclaration().isDeprecated()) {
            this.sourceBuilder.append(" @deprecated");
        }
        this.sourceBuilder.appendln(" */");
        this.sourceBuilder.append("const ");
        this.sourceBuilder.emitWithMapping(this.type.getSourcePosition(), () -> this.sourceBuilder.append(this.environment.aliasForType(typeDeclaration)));
        this.sourceBuilder.append(" = ");
        this.sourceBuilder.openBrace();
        this.sourceBuilder.newLine();
        for (Field field : this.type.getStaticFields()) {
            this.sourceBuilder.emitWithMemberMapping((MemberDescriptor)field.getDescriptor(), () -> {
                if (field.getDescriptor().isDeprecated()) {
                    this.sourceBuilder.appendln(" /** @deprecated */");
                }
                this.sourceBuilder.emitWithMapping(field.getSourcePosition(), () -> this.sourceBuilder.append(field.getMangledName()));
                this.sourceBuilder.append(" : ");
                ExpressionTranspiler.render(field.getInitializer(), this.environment, this.sourceBuilder);
                this.sourceBuilder.append(",");
                this.sourceBuilder.newLine();
            });
        }
        this.sourceBuilder.closeBrace();
        this.sourceBuilder.append(";");
        this.sourceBuilder.newLine();
    }

    public void renderClass() {
        this.renderTypeAnnotation();
        this.renderClassBody();
        this.renderLoadTimeStatements();
        this.renderNativeSource();
    }

    private void renderImports() {
        TypeDeclaration typeDeclaration = this.type.getDeclaration();
        this.sourceBuilder.appendln("goog.module('" + typeDeclaration.getImplModuleName() + "');");
        this.sourceBuilder.newLine();
        HashMap aliasesByPath = new HashMap();
        this.sourceBuilder.emitBlock((List)this.imports.stream().filter(i -> i.getImportCategory().needsGoogRequireInImpl()).collect(ImmutableList.toImmutableList()), eagerImport -> {
            String alias = eagerImport.getAlias();
            String path = eagerImport.getImplModulePath();
            String previousAlias = (String)aliasesByPath.get(path);
            if (previousAlias == null) {
                this.sourceBuilder.appendln("const " + alias + " = goog.require('" + path + "');");
                aliasesByPath.put(path, alias);
            } else {
                this.sourceBuilder.appendln("const " + alias + " = " + previousAlias + ";");
            }
        });
        this.sourceBuilder.emitBlock((List)this.imports.stream().filter(i -> i.getImportCategory().needsGoogForwardDeclare()).collect(ImmutableList.toImmutableList()), lazyImport -> {
            String alias = lazyImport.getAlias();
            String path = lazyImport.getImplModulePath();
            this.sourceBuilder.appendln("let " + alias + " = goog.forwardDeclare('" + path + "');");
        });
    }

    private void renderTypeAnnotation() {
        String classJsDoc;
        DeclaredTypeDescriptor superTypeDescriptor;
        if (this.type.isOverlayImplementation()) {
            this.sourceBuilder.appendln("/** @nodts */");
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (this.type.isInterface()) {
            JavaScriptImplGenerator.appendWithNewLine(sb, " * @interface");
        } else if (this.type.isAbstract() || TypeDescriptors.isBoxedTypeAsJsPrimitives((TypeDescriptor)this.type.getTypeDescriptor())) {
            JavaScriptImplGenerator.appendWithNewLine(sb, " * @abstract");
        }
        if (this.type.getDeclaration().isFinal()) {
            JavaScriptImplGenerator.appendWithNewLine(sb, " * @final");
        }
        if (this.type.getDeclaration().hasTypeParameters()) {
            JavaScriptImplGenerator.appendWithNewLine(sb, " *" + this.getJsDocDeclarationForTypeVariable((Collection<TypeVariable>)this.type.getDeclaration().getTypeParameterDescriptors()));
        }
        if ((superTypeDescriptor = this.type.getSuperTypeDescriptor()) != null && superTypeDescriptor.hasTypeArguments()) {
            this.renderClauseIfTypeExistsInJavaScript("extends", superTypeDescriptor, sb);
        }
        String extendsOrImplementsString = this.type.isInterface() ? "extends" : "implements";
        this.type.getSuperInterfaceTypeDescriptors().forEach(t -> this.renderClauseIfTypeExistsInJavaScript(extendsOrImplementsString, (DeclaredTypeDescriptor)t, sb));
        if (this.type.getDeclaration().isDeprecated()) {
            JavaScriptImplGenerator.appendWithNewLine(sb, " * @deprecated");
        }
        if (!(classJsDoc = sb.toString()).isEmpty()) {
            this.sourceBuilder.appendln("/**");
            this.sourceBuilder.append(classJsDoc);
            this.sourceBuilder.appendln(" */");
        }
    }

    private void renderClauseIfTypeExistsInJavaScript(String extendsOrImplementsString, DeclaredTypeDescriptor typeDescriptor, StringBuilder sb) {
        if (!typeDescriptor.isJavaScriptClass()) {
            return;
        }
        Object superTypeString = this.environment.aliasForType(typeDescriptor.getTypeDeclaration());
        if (typeDescriptor.hasTypeArguments()) {
            superTypeString = (String)superTypeString + typeDescriptor.getTypeArgumentDescriptors().stream().map(t -> AstUtils.isNonNativeJsEnum((TypeDescriptor)t) ? TypeDescriptors.getEnumBoxType((TypeDescriptor)t) : t).map(this.closureTypesGenerator::getClosureTypeString).collect(Collectors.joining(", ", "<", ">"));
        }
        JavaScriptImplGenerator.appendWithNewLine(sb, String.format(" * @%s {%s}", extendsOrImplementsString, superTypeString));
    }

    private void renderClassBody() {
        this.sourceBuilder.append("class ");
        this.sourceBuilder.emitWithMapping(this.type.getSourcePosition(), () -> this.sourceBuilder.append(this.environment.aliasForType(this.type.getDeclaration())));
        DeclaredTypeDescriptor superTypeDescriptor = this.type.getSuperTypeDescriptor();
        if (superTypeDescriptor != null && superTypeDescriptor.isJavaScriptClass()) {
            this.sourceBuilder.append(String.format(" extends %s", this.environment.aliasForType(superTypeDescriptor)));
        }
        this.sourceBuilder.append(" ");
        this.sourceBuilder.openBrace();
        this.sourceBuilder.newLine();
        this.renderTypeMethods();
        this.renderLoadModules();
        this.sourceBuilder.closeBrace();
    }

    private void renderTypeMethods() {
        for (Method method : this.type.getMethods()) {
            if (method.isNative()) {
                if (method.getDescriptor().hasJsNamespace()) continue;
                this.sourceBuilder.emitWithMemberMapping((MemberDescriptor)method.getDescriptor(), () -> {
                    this.sourceBuilder.append("// ");
                    this.renderMethodJsDoc(method);
                    this.sourceBuilder.append("// native ");
                    this.emitMethodHeader(method);
                });
            } else {
                this.sourceBuilder.emitWithMemberMapping((MemberDescriptor)method.getDescriptor(), () -> {
                    this.renderMethodJsDoc(method);
                    this.emitMethodHeader(method);
                    StatementTranspiler.render((Statement)method.getBody(), this.environment, this.sourceBuilder);
                });
            }
            this.sourceBuilder.newLine();
        }
    }

    private void renderMethodJsDoc(Method method) {
        String jsDoc;
        if (!Strings.isNullOrEmpty((String)method.getJsDocDescription())) {
            this.sourceBuilder.appendln("//" + method.getJsDocDescription());
        }
        this.sourceBuilder.appendln((String)((jsDoc = this.getJsDoc(method)).isEmpty() ? "" : "/**" + jsDoc + " */"));
    }

    private String getJsDoc(Method method) {
        MethodDescriptor methodDescriptor = method.getDescriptor();
        boolean isKotlinSource = methodDescriptor.getEnclosingTypeDescriptor().getTypeDeclaration().getSourceLanguage() == TypeDeclaration.SourceLanguage.KOTLIN;
        StringBuilder jsDocBuilder = new StringBuilder();
        if (methodDescriptor.getJsVisibility() != Visibility.PUBLIC) {
            jsDocBuilder.append(" @").append(methodDescriptor.getJsVisibility().jsText);
        }
        if (!(!methodDescriptor.isFinal() || methodDescriptor.isStatic() && (methodDescriptor.isJsMember() || isKotlinSource) || methodDescriptor.isPropertyGetter() || methodDescriptor.isPropertySetter())) {
            jsDocBuilder.append(" @final");
        }
        if (methodDescriptor.isAbstract()) {
            jsDocBuilder.append(" @abstract");
        }
        if (method.getDescriptor().isJsOverride()) {
            jsDocBuilder.append(" @override");
        }
        if (!methodDescriptor.canBeReferencedExternally() && !methodDescriptor.equals(methodDescriptor.getEnclosingTypeDescriptor().getMarkImplementorMethodDescriptor())) {
            jsDocBuilder.append(" @nodts");
        }
        if (methodDescriptor.isSideEffectFree()) {
            jsDocBuilder.append(" @nosideeffects");
        }
        if (methodDescriptor.isBridge() && (isKotlinSource || methodDescriptor.getJsOverriddenMethodDescriptors().stream().anyMatch(m -> m.isFinal()))) {
            jsDocBuilder.append(" @suppress{visibility}");
        }
        if (!methodDescriptor.getTypeParameterTypeDescriptors().isEmpty()) {
            jsDocBuilder.append(this.getJsDocDeclarationForTypeVariable((Collection<TypeVariable>)methodDescriptor.getTypeParameterTypeDescriptors()));
        }
        String returnTypeName = this.closureTypesGenerator.getClosureTypeString(methodDescriptor.getReturnTypeDescriptor());
        if (this.needsReturnJsDoc(methodDescriptor)) {
            jsDocBuilder.append(" @return {").append(returnTypeName).append("}");
        }
        if (methodDescriptor.isDeprecated()) {
            jsDocBuilder.append(" @deprecated");
        }
        return jsDocBuilder.toString();
    }

    private boolean needsReturnJsDoc(MethodDescriptor methodDescriptor) {
        return !methodDescriptor.isConstructor() && !TypeDescriptors.isPrimitiveVoid((TypeDescriptor)methodDescriptor.getReturnTypeDescriptor());
    }

    private void renderLoadModules() {
        MethodDescriptor methodDescriptor = AstUtils.getLoadModulesDescriptor((DeclaredTypeDescriptor)this.type.getTypeDescriptor());
        this.sourceBuilder.newLine();
        this.sourceBuilder.appendln("/** @nodts */");
        this.sourceBuilder.append("static " + methodDescriptor.getMangledName() + "() ");
        this.sourceBuilder.openBrace();
        this.imports.stream().filter(i -> i.getImportCategory().needsGoogModuleGet()).forEach(lazyImport -> {
            String alias = lazyImport.getAlias();
            String path = lazyImport.getImplModulePath();
            this.sourceBuilder.newLine();
            this.sourceBuilder.append(alias + " = goog.module.get('" + path + "');");
        });
        this.sourceBuilder.closeBrace();
    }

    private void renderLoadTimeStatements() {
        this.type.getLoadTimeStatements().forEach(s -> {
            this.sourceBuilder.newLine();
            StatementTranspiler.render(s, this.environment, this.sourceBuilder);
        });
        this.sourceBuilder.newLine();
    }

    private void renderNativeSource() {
        if (this.nativeSource == null) {
            return;
        }
        String className = this.environment.aliasForType(this.type.getDeclaration());
        this.sourceBuilder.newLine();
        this.sourceBuilder.appendln("/* NATIVE.JS EPILOG */");
        this.sourceBuilder.newLine();
        String longAliasName = this.type.getDeclaration().getQualifiedSourceName().replace("_", "__").replace('.', '_');
        if (!className.equals(longAliasName)) {
            this.sourceBuilder.appendln("const " + longAliasName + " = " + className + ";");
            this.sourceBuilder.newLine();
        }
        int nativeSourceLine = 0;
        int currentByteOffset = 0;
        String content = this.nativeSource.getContent();
        for (String line : Splitter.on((char)'\n').split((CharSequence)content)) {
            String trimmedLine = CharMatcher.whitespace().trimTrailingFrom((CharSequence)line);
            if (!trimmedLine.isEmpty()) {
                int firstNonWhitespaceColumn = CharMatcher.whitespace().negate().indexIn((CharSequence)trimmedLine);
                this.sourceBuilder.append(" ".repeat(firstNonWhitespaceColumn));
                this.sourceBuilder.emitWithMapping(SourcePosition.newBuilder().setStartFilePosition(FilePosition.newBuilder().setLine(nativeSourceLine).setColumn(firstNonWhitespaceColumn).setByteOffset(currentByteOffset + firstNonWhitespaceColumn).build()).setEndFilePosition(FilePosition.newBuilder().setLine(nativeSourceLine).setColumn(trimmedLine.length()).setByteOffset(currentByteOffset + trimmedLine.length()).build()).setFilePath(this.nativeSource.getRelativeFilePath()).setName(this.type.getDeclaration().getQualifiedBinaryName() + ".<native>").build(), () -> this.sourceBuilder.append(trimmedLine.substring(firstNonWhitespaceColumn)));
            }
            this.sourceBuilder.newLine();
            ++nativeSourceLine;
            currentByteOffset += line.length() + 1;
        }
    }

    private void renderExports() {
        this.sourceBuilder.newLine();
        this.sourceBuilder.appendln("exports = " + this.environment.aliasForType(this.type.getDeclaration()) + ";");
    }

    private String getJsDocDeclarationForTypeVariable(Collection<TypeVariable> typeDescriptors) {
        Object[] objectArray = new Object[1];
        objectArray[0] = typeDescriptors.stream().map(this.closureTypesGenerator::getClosureTypeString).collect(Collectors.joining(", "));
        return String.format(" @template %s", objectArray);
    }

    private static void appendWithNewLine(StringBuilder sb, String string) {
        sb.append(string);
        sb.append("\n");
    }
}

