/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.backend.closure;

import java.nio.file.Path;

public class NativeJavaScriptFile {
    private final String relativePath;
    private final String content;
    public static final String NATIVE_EXTENSION = ".native.js";

    public NativeJavaScriptFile(String relativePath, String content) {
        this.relativePath = relativePath;
        this.content = content;
    }

    public String getRelativeFilePath() {
        return this.getRelativePathWithoutExtension() + ".native_js";
    }

    public String getRelativePathWithoutExtension() {
        return this.relativePath.substring(0, this.relativePath.lastIndexOf(NATIVE_EXTENSION));
    }

    public String getFullyQualifiedName() {
        return Path.of(this.getRelativePathWithoutExtension(), new String[0]).getFileName().toString();
    }

    public String getContent() {
        return this.content;
    }

    public String toString() {
        return this.relativePath;
    }
}

