/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.backend.closure;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.io.MoreFiles;
import com.google.j2cl.common.OutputUtils;
import com.google.j2cl.common.Problems;
import com.google.j2cl.common.SourceUtils;
import com.google.j2cl.transpiler.ast.CompilationUnit;
import com.google.j2cl.transpiler.ast.Type;
import com.google.j2cl.transpiler.ast.TypeDeclaration;
import com.google.j2cl.transpiler.backend.closure.NativeJavaScriptFile;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

final class NativeJavaScriptFileResolver {
    private final Map<String, NativeJavaScriptFile> byRelativePath;
    private final Map<String, NativeJavaScriptFile> byFullyQualifiedName;
    private final Problems problems;
    private final Set<NativeJavaScriptFile> usedFiles = new HashSet<NativeJavaScriptFile>();

    public static NativeJavaScriptFileResolver create(List<SourceUtils.FileInfo> files, Problems problems) {
        ImmutableMap.Builder byRelativePath = ImmutableMap.builder();
        ImmutableMap.Builder byFullyQualifiedName = ImmutableMap.builder();
        for (SourceUtils.FileInfo file : files) {
            Preconditions.checkArgument((boolean)file.sourcePath().endsWith(".native.js"));
            try {
                String content = MoreFiles.asCharSource((Path)Paths.get(file.sourcePath(), new String[0]), (Charset)StandardCharsets.UTF_8, (OpenOption[])new OpenOption[0]).read();
                NativeJavaScriptFile nativeFile = new NativeJavaScriptFile(file.targetPath(), content);
                byRelativePath.put((Object)nativeFile.getRelativePathWithoutExtension(), (Object)nativeFile);
                String qualifiedName = nativeFile.getFullyQualifiedName();
                if (qualifiedName.indexOf(46) <= 0) continue;
                byFullyQualifiedName.put((Object)nativeFile.getFullyQualifiedName(), (Object)nativeFile);
            }
            catch (IOException e) {
                problems.fatal(Problems.FatalError.CANNOT_OPEN_FILE, new Object[]{e.toString()});
            }
        }
        return new NativeJavaScriptFileResolver((Map<String, NativeJavaScriptFile>)byRelativePath.buildOrThrow(), (Map<String, NativeJavaScriptFile>)byFullyQualifiedName.buildOrThrow(), problems);
    }

    private NativeJavaScriptFileResolver(Map<String, NativeJavaScriptFile> byRelativePath, Map<String, NativeJavaScriptFile> byFullyQualifiedName, Problems problems) {
        this.byRelativePath = byRelativePath;
        this.byFullyQualifiedName = byFullyQualifiedName;
        this.problems = problems;
    }

    public NativeJavaScriptFile getMatchingNativeFile(CompilationUnit j2clCompilationUnit, Type type) {
        Preconditions.checkArgument((!j2clCompilationUnit.isSynthetic() ? 1 : 0) != 0, (Object)"Synthetic CompilationUnit cannot have a corresponding .native.js file.");
        TypeDeclaration typeDeclaration = type.getUnderlyingTypeDeclaration();
        NativeJavaScriptFile matchedFile = this.resolveByFullyQualifiedName(typeDeclaration.getQualifiedBinaryName()).or(() -> this.resolveByRelativePath(OutputUtils.getPackageRelativePath((String)typeDeclaration.getPackageName(), (String)typeDeclaration.getSimpleBinaryName()))).or(() -> this.resolveByRelativePath(SourceUtils.getJavaPath((String)NativeJavaScriptFileResolver.getAbsolutePath(j2clCompilationUnit, typeDeclaration)))).orElse(null);
        if (matchedFile != null) {
            this.usedFiles.add(matchedFile);
        }
        return matchedFile;
    }

    public void checkAllFilesUsed() {
        HashSet<NativeJavaScriptFile> allPotentialFiles = new HashSet<NativeJavaScriptFile>(this.byRelativePath.values());
        Sets.SetView unusedFiles = Sets.difference(allPotentialFiles, this.usedFiles);
        unusedFiles.forEach(file -> this.problems.error("Unused native file '%s'.", new Object[]{file}));
    }

    private Optional<NativeJavaScriptFile> resolveByRelativePath(String relativePath) {
        return Optional.ofNullable(this.byRelativePath.get(relativePath));
    }

    private Optional<NativeJavaScriptFile> resolveByFullyQualifiedName(String fullyQualifiedName) {
        return Optional.ofNullable(this.byFullyQualifiedName.get(fullyQualifiedName));
    }

    private static String getAbsolutePath(CompilationUnit compilationUnit, TypeDeclaration typeDeclaration) {
        return compilationUnit.getDirectoryPath() + "/" + typeDeclaration.getSimpleBinaryName();
    }
}

