/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.backend.closure;

import com.google.common.base.Preconditions;
import com.google.j2cl.common.OutputUtils;
import com.google.j2cl.common.Problems;
import com.google.j2cl.common.SourcePosition;
import com.google.j2cl.common.SourceUtils;
import com.google.j2cl.transpiler.ast.CompilationUnit;
import com.google.j2cl.transpiler.ast.Library;
import com.google.j2cl.transpiler.ast.Type;
import com.google.j2cl.transpiler.ast.TypeDeclaration;
import com.google.j2cl.transpiler.backend.closure.Import;
import com.google.j2cl.transpiler.backend.closure.ImportGatherer;
import com.google.j2cl.transpiler.backend.closure.JavaScriptHeaderGenerator;
import com.google.j2cl.transpiler.backend.closure.JavaScriptImplGenerator;
import com.google.j2cl.transpiler.backend.closure.KytheIndexingMetadata;
import com.google.j2cl.transpiler.backend.closure.NativeJavaScriptFile;
import com.google.j2cl.transpiler.backend.closure.NativeJavaScriptFileResolver;
import com.google.j2cl.transpiler.backend.closure.ReadableSourceMapGenerator;
import com.google.j2cl.transpiler.backend.closure.SourceMapGeneratorStage;
import com.google.j2cl.transpiler.backend.libraryinfo.LibraryInfoBuilder;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class OutputGeneratorStage {
    private final List<SourceUtils.FileInfo> nativeJavaScriptFiles;
    private final Problems problems;
    private final OutputUtils.Output output;
    private final Path libraryInfoOutputPath;
    private final boolean shouldGenerateReadableSourceMaps;
    private final boolean shouldGenerateReadableLibraryInfo;
    private final boolean generateKytheIndexingMetadata;
    private static final String SOURCE_MAP_SUFFIX = ".js.map";
    private static final String READABLE_MAPPINGS_SUFFIX = ".js.mappings";

    public OutputGeneratorStage(List<SourceUtils.FileInfo> nativeJavaScriptFiles, OutputUtils.Output output, Path libraryInfoOutputPath, boolean shouldGenerateReadableLibraryInfo, boolean shouldGenerateReadableSourceMaps, boolean generateKytheIndexingMetadata, Problems problems) {
        this.nativeJavaScriptFiles = nativeJavaScriptFiles;
        this.output = output;
        this.libraryInfoOutputPath = libraryInfoOutputPath;
        this.shouldGenerateReadableLibraryInfo = shouldGenerateReadableLibraryInfo;
        this.shouldGenerateReadableSourceMaps = shouldGenerateReadableSourceMaps;
        this.generateKytheIndexingMetadata = generateKytheIndexingMetadata;
        this.problems = problems;
    }

    public void generateOutputs(Library library) {
        NativeJavaScriptFileResolver nativeJavaScriptFileResolver = NativeJavaScriptFileResolver.create(this.nativeJavaScriptFiles, this.problems);
        LibraryInfoBuilder libraryInfoBuilder = new LibraryInfoBuilder();
        for (CompilationUnit compilationUnit : library.getCompilationUnits()) {
            for (Type type : compilationUnit.getTypes()) {
                NativeJavaScriptFile matchingNativeFile;
                List<Import> imports = ImportGatherer.gatherImports(type);
                JavaScriptImplGenerator jsImplGenerator = new JavaScriptImplGenerator(this.problems, type, imports);
                String typeRelativePath = OutputGeneratorStage.getPackageRelativePath(type.getDeclaration());
                NativeJavaScriptFile nativeJavaScriptFile = matchingNativeFile = compilationUnit.isSynthetic() ? null : nativeJavaScriptFileResolver.getMatchingNativeFile(compilationUnit, type);
                if (matchingNativeFile != null) {
                    jsImplGenerator.setNativeSource(matchingNativeFile);
                    TypeDeclaration typeDeclaration = type.getUnderlyingTypeDeclaration();
                    if (typeDeclaration.isNative() || typeDeclaration.isJsEnum()) {
                        this.problems.error("%s '%s' does not support having a '.native.js' file.", new Object[]{typeDeclaration.isJsEnum() ? "JsEnum" : "Native JsType", typeDeclaration.getReadableDescription()});
                        continue;
                    }
                    this.output.write(matchingNativeFile.getRelativeFilePath(), matchingNativeFile.getContent());
                }
                Object javaScriptImplementationSource = jsImplGenerator.renderOutput();
                JavaScriptHeaderGenerator jsHeaderGenerator = new JavaScriptHeaderGenerator(this.problems, type, imports);
                Object javaScriptHeaderSource = jsHeaderGenerator.renderOutput();
                if (this.generateKytheIndexingMetadata) {
                    javaScriptHeaderSource = (String)javaScriptHeaderSource + this.renderKytheIndexingMetadata(jsHeaderGenerator.getSourceMappings());
                    javaScriptImplementationSource = (String)javaScriptImplementationSource + this.renderKytheIndexingMetadata(jsImplGenerator.getSourceMappings());
                } else {
                    String sourceMap = this.renderSourceMap(type, jsImplGenerator.getSourceMappings());
                    if (sourceMap != null) {
                        javaScriptImplementationSource = (String)javaScriptImplementationSource + String.format("%n//# sourceMappingURL=%s\n", type.getDeclaration().getSimpleBinaryName() + SOURCE_MAP_SUFFIX);
                        this.output.write(typeRelativePath + SOURCE_MAP_SUFFIX, sourceMap);
                    }
                }
                if (this.shouldGenerateReadableSourceMaps && !compilationUnit.isSynthetic()) {
                    this.outputReadableSourceMap(compilationUnit, type, (String)javaScriptImplementationSource, jsImplGenerator.getSourceMappings(), matchingNativeFile);
                }
                String implRelativePath = typeRelativePath + jsImplGenerator.getSuffix();
                this.output.write(implRelativePath, (String)javaScriptImplementationSource);
                String headerRelativePath = typeRelativePath + jsHeaderGenerator.getSuffix();
                this.output.write(headerRelativePath, (String)javaScriptHeaderSource);
                if (this.libraryInfoOutputPath == null && !this.shouldGenerateReadableLibraryInfo) continue;
                libraryInfoBuilder.addType(type, headerRelativePath, implRelativePath, jsImplGenerator.getOutputSourceInfoByMember());
            }
            if (this.generateKytheIndexingMetadata || compilationUnit.isSynthetic()) continue;
            this.output.copyFile(compilationUnit.getFilePath(), compilationUnit.getPackageRelativePath());
        }
        if (this.shouldGenerateReadableLibraryInfo) {
            this.output.write("library_info_debug.json", libraryInfoBuilder.toJson(this.problems));
        }
        if (this.libraryInfoOutputPath != null) {
            OutputUtils.writeToFile((Path)this.libraryInfoOutputPath, (byte[])libraryInfoBuilder.toByteArray(), (Problems)this.problems);
        }
        nativeJavaScriptFileResolver.checkAllFilesUsed();
    }

    private String renderKytheIndexingMetadata(Map<SourcePosition, SourcePosition> javaSourcePositionByOutputSourcePosition) {
        KytheIndexingMetadata metadata = new KytheIndexingMetadata();
        for (Map.Entry<SourcePosition, SourcePosition> entry : javaSourcePositionByOutputSourcePosition.entrySet()) {
            SourcePosition javaSourcePosition = entry.getValue();
            SourcePosition javaScriptSourcePosition = entry.getKey();
            metadata.addAnchorAnchor(javaSourcePosition.getStartFilePosition().getByteOffset(), javaSourcePosition.getEndFilePosition().getByteOffset(), javaScriptSourcePosition.getStartFilePosition().getByteOffset(), javaScriptSourcePosition.getEndFilePosition().getByteOffset(), null, javaSourcePosition.getFilePath(), null);
        }
        return String.format("%n// Kythe Indexing Metadata:%n// %s", metadata.toJson());
    }

    @Nullable
    private String renderSourceMap(Type type, Map<SourcePosition, SourcePosition> javaSourcePositionByOutputSourcePosition) {
        try {
            return SourceMapGeneratorStage.generateSourceMaps(type, javaSourcePositionByOutputSourcePosition);
        }
        catch (IOException e) {
            this.problems.fatal(Problems.FatalError.CANNOT_WRITE_FILE, new Object[]{e.toString()});
            return null;
        }
    }

    private void outputReadableSourceMap(CompilationUnit j2clUnit, Type type, String javaScriptImplementationFileContents, Map<SourcePosition, SourcePosition> javaSourcePositionByOutputSourcePosition, NativeJavaScriptFile nativeJavaScriptFile) {
        Preconditions.checkArgument((!j2clUnit.isSynthetic() ? 1 : 0) != 0, (Object)"Cannot generate sourcemap for synthetic CompilationUnit");
        String readableOutput = ReadableSourceMapGenerator.generate(javaSourcePositionByOutputSourcePosition, javaScriptImplementationFileContents, nativeJavaScriptFile, j2clUnit.getFilePath(), this.problems);
        if (!readableOutput.isEmpty()) {
            String readableSourceMapRelativePath = OutputGeneratorStage.getPackageRelativePath(type.getDeclaration()) + READABLE_MAPPINGS_SUFFIX;
            this.output.write(readableSourceMapRelativePath, readableOutput);
        }
    }

    private static String getPackageRelativePath(TypeDeclaration typeDeclaration) {
        return OutputUtils.getPackageRelativePath((String)typeDeclaration.getPackageName(), (String)typeDeclaration.getSimpleBinaryName());
    }
}

