/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.backend.closure;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.j2cl.common.Problems;
import com.google.j2cl.common.SourcePosition;
import com.google.j2cl.transpiler.backend.closure.NativeJavaScriptFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class ReadableSourceMapGenerator {
    public static String generate(Map<SourcePosition, SourcePosition> javaSourcePositionByOutputSourcePosition, String javaScriptImplementationFileContents, NativeJavaScriptFile nativeJavaScriptFile, String j2clUnitFilePath, Problems problems) {
        ImmutableMap<String, List<String>> sourceLinesByFileName = ReadableSourceMapGenerator.buildSourceLinesByFileName(nativeJavaScriptFile, j2clUnitFilePath, problems);
        StringBuilder sb = new StringBuilder();
        ArrayList<Map.Entry<SourcePosition, SourcePosition>> entries = new ArrayList<Map.Entry<SourcePosition, SourcePosition>>(javaSourcePositionByOutputSourcePosition.entrySet());
        List<String> javaScriptSourceLines = Arrays.asList(javaScriptImplementationFileContents.split("\n"));
        for (Map.Entry entry : entries) {
            SourcePosition javaSourcePosition = (SourcePosition)Preconditions.checkNotNull((Object)((SourcePosition)entry.getValue()));
            SourcePosition javaScriptSourcePosition = (SourcePosition)Preconditions.checkNotNull((Object)((SourcePosition)entry.getKey()));
            List javaSourceLines = (List)sourceLinesByFileName.get(javaSourcePosition.getFileName());
            if (javaSourceLines == null) continue;
            boolean hasName = javaSourcePosition.getName() != null;
            sb.append(ReadableSourceMapGenerator.extract(javaSourcePosition, javaSourceLines, hasName)).append(" => ").append(ReadableSourceMapGenerator.extract(javaScriptSourcePosition, javaScriptSourceLines, hasName).trim());
            if (hasName) {
                sb.append(" \"").append(javaSourcePosition.getName()).append("\"");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private static ImmutableMap<String, List<String>> buildSourceLinesByFileName(NativeJavaScriptFile nativeJavaScriptFile, String j2clUnitFilePath, Problems problems) {
        ImmutableMap.Builder contentsByFileNameBuilder = ImmutableMap.builder();
        if (nativeJavaScriptFile != null) {
            String nativeJavaScriptFileFileName = nativeJavaScriptFile.getRelativeFilePath();
            contentsByFileNameBuilder.put((Object)new File(nativeJavaScriptFileFileName).getName(), (Object)Splitter.on((char)'\n').splitToList((CharSequence)nativeJavaScriptFile.getContent()));
        }
        try {
            contentsByFileNameBuilder.put((Object)new File(j2clUnitFilePath).getName(), Files.readAllLines(Paths.get(j2clUnitFilePath, new String[0])));
        }
        catch (IOException e) {
            problems.fatal(Problems.FatalError.CANNOT_OPEN_FILE, new Object[]{e.toString()});
        }
        return contentsByFileNameBuilder.build();
    }

    private static String extract(SourcePosition sourcePosition, List<String> lines, boolean condense) {
        int startLine = sourcePosition.getStartFilePosition().getLine();
        int endLine = sourcePosition.getEndFilePosition().getLine();
        String fragment = lines.get(startLine);
        int endColumn = sourcePosition.getEndFilePosition().getColumn();
        int startColumn = sourcePosition.getStartFilePosition().getColumn();
        if (endLine != startLine || endColumn == -1) {
            StringBuilder content = new StringBuilder(ReadableSourceMapGenerator.trimTrailingWhitespace(fragment.substring(startColumn)));
            if (condense && startLine + 3 < endLine) {
                content.append("\n").append(ReadableSourceMapGenerator.trimTrailingWhitespace(lines.get(startLine + 1))).append("\n...").append(ReadableSourceMapGenerator.trimTrailingWhitespace(lines.get(endLine - 1)));
            } else {
                for (int line = startLine + 1; line < endLine; ++line) {
                    content.append("\n").append(ReadableSourceMapGenerator.trimTrailingWhitespace(lines.get(line)));
                }
            }
            content.append("\n").append(ReadableSourceMapGenerator.trimTrailingWhitespace(lines.get(endLine).substring(0, endColumn)));
            return "[" + content + "]";
        }
        return "[" + fragment.substring(startColumn, endColumn) + "]";
    }

    private static String trimTrailingWhitespace(String string) {
        return CharMatcher.whitespace().trimTrailingFrom((CharSequence)string);
    }

    private ReadableSourceMapGenerator() {
    }
}

