/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.backend.closure;

import com.google.debugging.sourcemap.SourceMapFormat;
import com.google.debugging.sourcemap.SourceMapGenerator;
import com.google.debugging.sourcemap.SourceMapGeneratorFactory;
import com.google.j2cl.common.FilePosition;
import com.google.j2cl.common.SourcePosition;
import com.google.j2cl.transpiler.ast.Type;
import java.io.IOException;
import java.util.Map;

public final class SourceMapGeneratorStage {
    public static String generateSourceMaps(Type type, Map<SourcePosition, SourcePosition> javaSourcePositionByOutputSourcePosition) throws IOException {
        return SourceMapGeneratorStage.renderSourceMapToString(type, javaSourcePositionByOutputSourcePosition);
    }

    private static String renderSourceMapToString(Type type, Map<SourcePosition, SourcePosition> javaSourcePositionByOutputSourcePosition) throws IOException {
        SourceMapGenerator sourceMapGenerator = SourceMapGeneratorFactory.getInstance((SourceMapFormat)SourceMapFormat.V3);
        for (Map.Entry<SourcePosition, SourcePosition> entry : javaSourcePositionByOutputSourcePosition.entrySet()) {
            SourcePosition javaSourcePosition = entry.getValue();
            SourcePosition javaScriptSourcePosition = entry.getKey();
            sourceMapGenerator.addMapping(javaSourcePosition.getFileName(), javaSourcePosition.getName(), SourceMapGeneratorStage.toFilePosition(javaSourcePosition.getStartFilePosition()), SourceMapGeneratorStage.toFilePosition(javaScriptSourcePosition.getStartFilePosition()), SourceMapGeneratorStage.toFilePosition(javaScriptSourcePosition.getEndFilePosition()));
        }
        StringBuilder sb = new StringBuilder();
        String typeName = type.getDeclaration().getSimpleBinaryName();
        sourceMapGenerator.appendTo((Appendable)sb, typeName + ".impl.java.js");
        return sb.toString();
    }

    private static com.google.debugging.sourcemap.FilePosition toFilePosition(FilePosition j2clFilePosition) {
        return new com.google.debugging.sourcemap.FilePosition(j2clFilePosition.getLine(), j2clFilePosition.getColumn());
    }

    private SourceMapGeneratorStage() {
    }
}

