/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.backend.closure;

import com.google.j2cl.common.InternalCompilerError;
import com.google.j2cl.common.visitor.Processor;
import com.google.j2cl.transpiler.ast.AbstractVisitor;
import com.google.j2cl.transpiler.ast.AssertStatement;
import com.google.j2cl.transpiler.ast.Block;
import com.google.j2cl.transpiler.ast.BreakStatement;
import com.google.j2cl.transpiler.ast.CatchClause;
import com.google.j2cl.transpiler.ast.ContinueStatement;
import com.google.j2cl.transpiler.ast.DoWhileStatement;
import com.google.j2cl.transpiler.ast.Expression;
import com.google.j2cl.transpiler.ast.ExpressionStatement;
import com.google.j2cl.transpiler.ast.FieldDeclarationStatement;
import com.google.j2cl.transpiler.ast.ForStatement;
import com.google.j2cl.transpiler.ast.HasName;
import com.google.j2cl.transpiler.ast.IfStatement;
import com.google.j2cl.transpiler.ast.JsForInStatement;
import com.google.j2cl.transpiler.ast.LabeledStatement;
import com.google.j2cl.transpiler.ast.MemberDescriptor;
import com.google.j2cl.transpiler.ast.Node;
import com.google.j2cl.transpiler.ast.ReturnStatement;
import com.google.j2cl.transpiler.ast.Statement;
import com.google.j2cl.transpiler.ast.SwitchCase;
import com.google.j2cl.transpiler.ast.SwitchStatement;
import com.google.j2cl.transpiler.ast.SynchronizedStatement;
import com.google.j2cl.transpiler.ast.ThrowStatement;
import com.google.j2cl.transpiler.ast.TryStatement;
import com.google.j2cl.transpiler.ast.Variable;
import com.google.j2cl.transpiler.ast.VariableDeclarationExpression;
import com.google.j2cl.transpiler.ast.WhileStatement;
import com.google.j2cl.transpiler.backend.closure.ClosureGenerationEnvironment;
import com.google.j2cl.transpiler.backend.closure.ExpressionTranspiler;
import com.google.j2cl.transpiler.backend.common.SourceBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StatementTranspiler {
    public static void render(Statement statement, final ClosureGenerationEnvironment environment, final SourceBuilder builder) {
        class SourceTransformer
        extends AbstractVisitor {
            SourceTransformer() {
            }

            public boolean enterAssertStatement(AssertStatement assertStatement) {
                throw new InternalCompilerError("AssertStatement should have been normalized away.");
            }

            public boolean enterBlock(Block block) {
                builder.openBrace();
                this.renderStatements(block.getStatements());
                builder.closeBrace();
                return false;
            }

            public boolean enterBreakStatement(BreakStatement breakStatement) {
                builder.emitWithMapping(breakStatement.getSourcePosition(), () -> {
                    builder.append("break");
                    if (breakStatement.getLabelReference() != null) {
                        builder.append(" " + environment.getUniqueNameForVariable((HasName)breakStatement.getLabelReference().getTarget()));
                    }
                    builder.append(";");
                });
                return false;
            }

            public boolean enterCatchClause(CatchClause catchClause) {
                this.render((Node)catchClause.getBody());
                return false;
            }

            public boolean enterContinueStatement(ContinueStatement continueStatement) {
                builder.emitWithMapping(continueStatement.getSourcePosition(), () -> {
                    builder.append("continue");
                    if (continueStatement.getLabelReference() != null) {
                        builder.append(" " + environment.getUniqueNameForVariable((HasName)continueStatement.getLabelReference().getTarget()));
                    }
                    builder.append(";");
                });
                return false;
            }

            public boolean enterDoWhileStatement(DoWhileStatement doWhileStatement) {
                builder.emitWithMapping(doWhileStatement.getSourcePosition(), () -> {
                    builder.append("do ");
                    this.render((Node)doWhileStatement.getBody());
                    builder.append(" while (");
                    this.renderExpression(doWhileStatement.getConditionExpression());
                    builder.append(");");
                });
                return false;
            }

            public boolean enterExpressionStatement(ExpressionStatement expressionStatement) {
                builder.emitWithMapping(expressionStatement.getSourcePosition(), () -> {
                    this.renderExpression(expressionStatement.getExpression());
                    builder.append(";");
                });
                return false;
            }

            public boolean enterForStatement(ForStatement forStatement) {
                builder.emitWithMapping(forStatement.getSourcePosition(), () -> {
                    builder.append("for (");
                    this.renderSeparated(", ", forStatement.getInitializers());
                    builder.append("; ");
                    this.renderExpression(forStatement.getConditionExpression());
                    builder.append("; ");
                    this.renderSeparated(", ", forStatement.getUpdates());
                    builder.append(") ");
                    this.render((Node)forStatement.getBody());
                });
                return false;
            }

            public boolean enterJsForInStatement(JsForInStatement jsForInStatement) {
                builder.emitWithMapping(jsForInStatement.getSourcePosition(), () -> {
                    builder.append("for(");
                    this.renderExpression((Expression)VariableDeclarationExpression.newBuilder().addVariableDeclarations(new Variable[]{jsForInStatement.getLoopVariable()}).build());
                    builder.append(" in ");
                    this.renderExpression(jsForInStatement.getIterableExpression());
                    builder.append(") ");
                    this.render((Node)jsForInStatement.getBody());
                });
                return false;
            }

            public boolean enterIfStatement(IfStatement ifStatement) {
                builder.emitWithMapping(ifStatement.getSourcePosition(), () -> {
                    builder.append("if (");
                    this.renderExpression(ifStatement.getConditionExpression());
                    builder.append(") ");
                    this.render((Node)ifStatement.getThenStatement());
                    if (ifStatement.getElseStatement() != null) {
                        builder.append(" else ");
                        this.render((Node)ifStatement.getElseStatement());
                    }
                });
                return false;
            }

            public boolean enterFieldDeclarationStatement(FieldDeclarationStatement declaration) {
                String typeJsDoc = environment.getClosureTypeString(declaration.getFieldDescriptor().getTypeDescriptor());
                ArrayList<Object> jsDocs = new ArrayList<Object>();
                if (!declaration.isPublic()) {
                    jsDocs.add("@private");
                }
                if (declaration.isConst()) {
                    jsDocs.add("@const");
                }
                if (jsDocs.isEmpty()) {
                    jsDocs.add("@type");
                }
                jsDocs.add("{" + typeJsDoc + "}");
                if (declaration.isDeprecated()) {
                    jsDocs.add("@deprecated");
                }
                if (!declaration.getFieldDescriptor().canBeReferencedExternally()) {
                    jsDocs.add("@nodts");
                }
                Runnable renderer = () -> builder.emitWithMapping(declaration.getSourcePosition(), () -> {
                    builder.appendln("/**" + String.join((CharSequence)" ", jsDocs) + "*/");
                    this.renderExpression(declaration.getExpression());
                    builder.append(";");
                });
                if (declaration.getFieldDescriptor().isStatic()) {
                    builder.emitWithMemberMapping((MemberDescriptor)declaration.getFieldDescriptor(), renderer);
                } else {
                    renderer.run();
                }
                return false;
            }

            public boolean enterLabeledStatement(LabeledStatement labelStatement) {
                builder.emitWithMapping(labelStatement.getSourcePosition(), () -> {
                    builder.append(environment.getUniqueNameForVariable((HasName)labelStatement.getLabel()) + ": ");
                    this.render((Node)labelStatement.getStatement());
                });
                return false;
            }

            public boolean enterReturnStatement(ReturnStatement returnStatement) {
                builder.emitWithMapping(returnStatement.getSourcePosition(), () -> {
                    Expression expression = returnStatement.getExpression();
                    builder.append("return");
                    if (expression != null) {
                        builder.append(" ");
                        this.renderExpression(expression);
                    }
                    builder.append(";");
                });
                return false;
            }

            public boolean enterSwitchCase(SwitchCase switchCase) {
                if (switchCase.isDefault()) {
                    builder.append("default: ");
                } else {
                    builder.append("case ");
                    this.renderExpression(switchCase.getCaseExpression());
                    builder.append(": ");
                }
                builder.indent();
                this.renderStatements(switchCase.getStatements());
                builder.unindent();
                return false;
            }

            public boolean enterSwitchStatement(SwitchStatement switchStatement) {
                builder.emitWithMapping(switchStatement.getSourcePosition(), () -> {
                    builder.append("switch (");
                    this.renderExpression(switchStatement.getSwitchExpression());
                    builder.append(") ");
                    builder.openBrace();
                    for (SwitchCase switchcase : switchStatement.getCases()) {
                        builder.newLine();
                        this.render((Node)switchcase);
                    }
                    builder.closeBrace();
                });
                return false;
            }

            public boolean enterSynchronizedStatement(SynchronizedStatement synchronizedStatement) {
                throw new InternalCompilerError("SynchronizedStatement should have been normalized away.");
            }

            public boolean enterThrowStatement(ThrowStatement throwStatement) {
                builder.emitWithMapping(throwStatement.getSourcePosition(), () -> {
                    builder.append("throw ");
                    this.renderExpression(throwStatement.getExpression());
                    builder.append(";");
                });
                return false;
            }

            public boolean enterTryStatement(TryStatement tryStatement) {
                builder.emitWithMapping(tryStatement.getSourcePosition(), () -> {
                    builder.append("try ");
                    this.render((Node)tryStatement.getBody());
                    for (CatchClause catchClause : tryStatement.getCatchClauses()) {
                        builder.append(" catch (" + environment.getUniqueNameForVariable((HasName)catchClause.getExceptionVariable()) + ") ");
                        this.render((Node)catchClause.getBody());
                    }
                    if (tryStatement.getFinallyBlock() != null) {
                        builder.append(" finally ");
                        this.render((Node)tryStatement.getFinallyBlock());
                    }
                });
                return false;
            }

            public boolean enterWhileStatement(WhileStatement whileStatement) {
                builder.emitWithMapping(whileStatement.getSourcePosition(), () -> {
                    builder.append("while (");
                    this.renderExpression(whileStatement.getConditionExpression());
                    builder.append(") ");
                    this.render((Node)whileStatement.getBody());
                });
                return false;
            }

            private void render(Node node) {
                node.accept((Processor)this);
            }

            private void renderExpression(Expression expression) {
                ExpressionTranspiler.render(expression, environment, builder);
            }

            private void renderStatements(Collection<Statement> statements) {
                statements.forEach(s -> {
                    builder.newLine();
                    this.render((Node)s);
                });
            }

            private void renderSeparated(String separator, List<? extends Expression> expressions) {
                String nextSeparator = "";
                for (Expression expression : expressions) {
                    builder.append(nextSeparator);
                    nextSeparator = separator;
                    this.renderExpression(expression);
                }
            }
        }
        new SourceTransformer().render((Node)statement);
    }

    private StatementTranspiler() {
    }
}

