/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.backend.common;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.j2cl.common.FilePosition;
import com.google.j2cl.common.SourcePosition;
import com.google.j2cl.transpiler.ast.MemberDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Consumer;

public class SourceBuilder {
    private static final char LINE_SEPARATOR_CHAR = '\n';
    private static final String LINE_SEPARATOR = String.valueOf('\n');
    private static final String INDENT = " ";
    private static final int SINGLE_STRING_THRESHOLD = 1000000;
    private int currentLine = 0;
    private int currentColumn = 0;
    private int currentLength = 0;
    private int currentIndentation = 0;
    private final SortedMap<SourcePosition, SourcePosition> javaSourceInfoByOutputSourceInfo = new TreeMap<SourcePosition, SourcePosition>();
    private final Map<MemberDescriptor, SourcePosition> outputSourceInfoByMember = new HashMap<MemberDescriptor, SourcePosition>();
    private boolean finished = false;
    private final StringBuilder sb = new StringBuilder();
    private final ArrayList<String> outputs = new ArrayList();

    public void emitWithMapping(SourcePosition javaSourcePosition, Runnable codeEmitter) {
        Preconditions.checkNotNull((Object)javaSourcePosition);
        SourcePosition outputSourcePosition = this.emit(codeEmitter);
        if (outputSourcePosition == SourcePosition.NONE || javaSourcePosition == SourcePosition.NONE) {
            return;
        }
        this.javaSourceInfoByOutputSourceInfo.put(outputSourcePosition, javaSourcePosition);
    }

    public void emitWithMemberMapping(MemberDescriptor memberDescriptor, Runnable codeEmitter) {
        Preconditions.checkState((!this.outputSourceInfoByMember.containsKey(memberDescriptor) ? 1 : 0) != 0, (String)"Output source info already exists for this member %s", (Object)memberDescriptor);
        SourcePosition outputSourcePosition = this.emit(codeEmitter);
        if (outputSourcePosition == SourcePosition.NONE) {
            return;
        }
        this.outputSourceInfoByMember.put(memberDescriptor, outputSourcePosition);
    }

    private SourcePosition emit(Runnable codeEmitter) {
        FilePosition startPosition = this.getCurrentPosition();
        codeEmitter.run();
        FilePosition endPosition = this.getCurrentPosition();
        if (endPosition.equals((Object)startPosition)) {
            return SourcePosition.NONE;
        }
        return SourcePosition.newBuilder().setStartFilePosition(startPosition).setEndFilePosition(endPosition).build();
    }

    private void emitEOF() {
        if (this.sb.length() != 0 || !this.outputs.isEmpty()) {
            this.emitWithMapping(SourcePosition.newBuilder().setStartFilePosition(FilePosition.newBuilder().setLine(0).setColumn(0).setByteOffset(0).build()).setEndFilePosition(FilePosition.newBuilder().setLine(0).setColumn(0).setByteOffset(0).build()).build(), () -> {});
        }
        if (this.sb.length() > 0) {
            this.outputs.add(this.sb.toString());
            this.sb.setLength(0);
        }
        this.finished = true;
    }

    public <T> void emitBlock(List<T> item, Consumer<T> renderer) {
        item.forEach(renderer);
        if (!item.isEmpty()) {
            this.newLine();
        }
    }

    public SortedMap<SourcePosition, SourcePosition> getMappings() {
        return this.javaSourceInfoByOutputSourceInfo;
    }

    public ImmutableMap<MemberDescriptor, SourcePosition> getOutputSourceInfoByMember() {
        return ImmutableMap.copyOf(this.outputSourceInfoByMember);
    }

    public void append(String source) {
        Preconditions.checkState((!this.finished ? 1 : 0) != 0);
        if (source.isEmpty()) {
            return;
        }
        String indentedSource = source.replace(LINE_SEPARATOR, LINE_SEPARATOR + INDENT.repeat(this.currentIndentation));
        if (this.sb.length() > 1000000) {
            this.outputs.add(this.sb.toString());
            this.sb.setLength(0);
        }
        this.sb.append(indentedSource);
        this.currentLength += indentedSource.length();
        this.currentLine += CharMatcher.is((char)'\n').countIn((CharSequence)indentedSource);
        int newLineSeparatorIndex = indentedSource.lastIndexOf(LINE_SEPARATOR);
        this.currentColumn = newLineSeparatorIndex == -1 ? this.currentColumn + indentedSource.length() : indentedSource.length() - newLineSeparatorIndex - 1;
    }

    public void appendLines(String ... lines) {
        boolean firstLine = true;
        for (String line : lines) {
            if (!firstLine) {
                this.newLine();
            }
            this.append(line);
            firstLine = false;
        }
    }

    public void appendln(String line) {
        this.append(line);
        this.newLine();
    }

    public void newLine() {
        this.append(LINE_SEPARATOR);
    }

    public void indent() {
        ++this.currentIndentation;
    }

    public void unindent() {
        --this.currentIndentation;
    }

    public String build() {
        return String.join((CharSequence)"", this.buildToList());
    }

    public ImmutableList<String> buildToList() {
        this.emitEOF();
        Preconditions.checkState((this.sb.length() == 0 ? 1 : 0) != 0);
        return ImmutableList.copyOf(this.outputs);
    }

    public void openBrace() {
        this.append("{");
        this.indent();
    }

    public void closeBrace() {
        this.unindent();
        if (this.sb.charAt(this.sb.length() - 1) != '{') {
            this.newLine();
        }
        this.append("}");
    }

    public void openParens(String text) {
        this.append("(" + text);
        this.indent();
    }

    public void closeParens() {
        this.unindent();
        if (this.sb.charAt(this.sb.length() - 1) != '(') {
            this.newLine();
        }
        this.append(")");
    }

    private FilePosition getCurrentPosition() {
        return FilePosition.newBuilder().setLine(this.currentLine).setColumn(this.currentColumn).setByteOffset(this.currentLength).build();
    }
}

