/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.backend.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.j2cl.common.visitor.Processor;
import com.google.j2cl.transpiler.ast.AbstractVisitor;
import com.google.j2cl.transpiler.ast.FunctionExpression;
import com.google.j2cl.transpiler.ast.HasName;
import com.google.j2cl.transpiler.ast.MemberDescriptor;
import com.google.j2cl.transpiler.ast.Method;
import com.google.j2cl.transpiler.ast.MethodDescriptor;
import com.google.j2cl.transpiler.ast.NameDeclaration;
import com.google.j2cl.transpiler.ast.NullabilityAnnotation;
import com.google.j2cl.transpiler.ast.Type;
import com.google.j2cl.transpiler.ast.TypeVariable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class UniqueNamesResolver {
    public static Map<HasName, String> computeUniqueNames(Set<String> initiallyForbiddenNames, Type type) {
        HashSet<String> forbiddenNames = new HashSet<String>(initiallyForbiddenNames);
        HashMultimap variableUniqueNamesByMember = HashMultimap.create();
        final HashMap<HasName, String> uniqueNameByVariable = new HashMap<HasName, String>();
        for (TypeVariable typeParameter : type.getDeclaration().getTypeParameterDescriptors()) {
            Preconditions.checkState((typeParameter.getNullabilityAnnotation() == NullabilityAnnotation.NONE ? 1 : 0) != 0);
            String uniqueName = UniqueNamesResolver.computeUniqueName((HasName)typeParameter, (Predicate<String>)Predicates.not(forbiddenNames::contains));
            forbiddenNames.add(uniqueName);
            uniqueNameByVariable.put((HasName)typeParameter, uniqueName);
        }
        type.accept((Processor)new AbstractVisitor((SetMultimap)variableUniqueNamesByMember, forbiddenNames){
            final /* synthetic */ SetMultimap val$variableUniqueNamesByMember;
            final /* synthetic */ Set val$forbiddenNames;
            {
                this.val$variableUniqueNamesByMember = setMultimap;
                this.val$forbiddenNames = set;
            }

            public void exitMethod(Method method) {
                this.registerUniqueNames(method.getDescriptor());
            }

            public void exitFunctionExpression(FunctionExpression functionExpression) {
                this.registerUniqueNames(functionExpression.getDescriptor());
            }

            public void exitNameDeclaration(NameDeclaration nameDeclaration) {
                this.registerUniqueName(this.getCurrentMember().getDescriptor(), (HasName)nameDeclaration);
            }

            private void registerUniqueNames(MethodDescriptor methodDescriptor) {
                for (TypeVariable typeParameter : methodDescriptor.getTypeParameterTypeDescriptors()) {
                    if (typeParameter.isWildcardOrCapture()) continue;
                    String name = this.registerUniqueName((MemberDescriptor)methodDescriptor, (HasName)typeParameter);
                    uniqueNameByVariable.put(typeParameter, name);
                }
            }

            @CanIgnoreReturnValue
            private String registerUniqueName(MemberDescriptor currentMemberDescriptor, HasName variable) {
                String uniqueName = uniqueNameByVariable.computeIfAbsent(variable, v -> UniqueNamesResolver.computeUniqueName(v, (Predicate<String>)((Predicate)name -> this.isNameAvailable(currentMemberDescriptor, (String)name))));
                this.val$variableUniqueNamesByMember.put((Object)currentMemberDescriptor, (Object)uniqueName);
                return uniqueName;
            }

            private boolean isNameAvailable(MemberDescriptor currentMemberDescriptor, String variableName) {
                return !this.val$forbiddenNames.contains(variableName) && !this.val$variableUniqueNamesByMember.containsEntry((Object)currentMemberDescriptor, (Object)variableName);
            }
        });
        return uniqueNameByVariable;
    }

    private static String computeUniqueName(HasName variable, Predicate<String> isNameAvailable) {
        Object variableName = variable.getName();
        if (!isNameAvailable.apply(variableName)) {
            variableName = (String)variableName + "_";
            int suffix = 0;
            while (!isNameAvailable.apply((Object)((String)variableName + ++suffix))) {
            }
            variableName = (String)variableName + suffix;
        }
        return variableName;
    }

    private UniqueNamesResolver() {
    }
}

