/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.backend.libraryinfo;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.j2cl.common.Problems;
import com.google.j2cl.common.visitor.Processor;
import com.google.j2cl.transpiler.ast.AbstractVisitor;
import com.google.j2cl.transpiler.ast.DeclaredTypeDescriptor;
import com.google.j2cl.transpiler.ast.FieldAccess;
import com.google.j2cl.transpiler.ast.FieldDeclarationStatement;
import com.google.j2cl.transpiler.ast.FieldDescriptor;
import com.google.j2cl.transpiler.ast.Invocation;
import com.google.j2cl.transpiler.ast.JavaScriptConstructorReference;
import com.google.j2cl.transpiler.ast.Member;
import com.google.j2cl.transpiler.ast.MemberDescriptor;
import com.google.j2cl.transpiler.ast.MethodCall;
import com.google.j2cl.transpiler.ast.MethodDescriptor;
import com.google.j2cl.transpiler.ast.Statement;
import com.google.j2cl.transpiler.ast.Type;
import com.google.j2cl.transpiler.ast.TypeDescriptor;
import com.google.j2cl.transpiler.ast.TypeDescriptors;
import com.google.j2cl.transpiler.backend.libraryinfo.LibraryInfo;
import com.google.j2cl.transpiler.backend.libraryinfo.MemberInfo;
import com.google.j2cl.transpiler.backend.libraryinfo.MethodInvocation;
import com.google.j2cl.transpiler.backend.libraryinfo.SourcePosition;
import com.google.j2cl.transpiler.backend.libraryinfo.TypeInfo;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.annotation.Nullable;

public final class LibraryInfoBuilder {
    public static final int NULL_TYPE = 0;
    private final LibraryInfo.Builder libraryInfo = LibraryInfo.newBuilder();
    private final Map<String, Integer> types = new HashMap<String, Integer>();
    private static final ImmutableSet<String> TYPES_ACCESSED_FROM_J2CL_BOOTSTRAP_JS = ImmutableSet.of((Object)"java.lang.Boolean", (Object)"java.lang.Byte", (Object)"java.lang.Character", (Object)"java.lang.CharSequence", (Object)"java.lang.Class", (Object)"java.lang.Comparable", (Object[])new String[]{"java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Number", "java.lang.Object", "java.lang.Short", "java.lang.String", "java.lang.Void", "javaemul.internal.InternalPreconditions"});

    public void addType(Type type, String headerFilePath, String implFilePath, Map<MemberDescriptor, com.google.j2cl.common.SourcePosition> outputSourceInfoByMember) {
        if (!LibraryInfoBuilder.isPrunableType(type.getTypeDescriptor())) {
            return;
        }
        TypeInfo.Builder typeInfoBuilder = TypeInfo.newBuilder().setTypeId(this.getTypeId(type.getTypeDescriptor())).setHeaderSourceFilePath(headerFilePath).setImplSourceFilePath(implFilePath).setJstypeInterface(type.isInterface() && type.getTypeDescriptor().isJsType());
        DeclaredTypeDescriptor superTypeDescriptor = type.getSuperTypeDescriptor();
        if (superTypeDescriptor != null && !superTypeDescriptor.isNative() && !TypeDescriptors.isJavaLangObject((TypeDescriptor)superTypeDescriptor)) {
            typeInfoBuilder.setExtendsType(this.getTypeId(superTypeDescriptor));
        }
        for (DeclaredTypeDescriptor superInterfaceType : type.getSuperInterfaceTypeDescriptors()) {
            if (superInterfaceType.isNative() || superInterfaceType.isJsFunctionInterface()) continue;
            typeInfoBuilder.addImplementsTypes(this.getTypeId(superInterfaceType));
        }
        final LinkedHashMap memberInfoBuilders = Maps.newLinkedHashMapWithExpectedSize((int)type.getMembers().size());
        boolean hasConstantEntryPoint = false;
        for (Member member : type.getMembers()) {
            MemberDescriptor memberDescriptor = member.getDescriptor();
            if (memberDescriptor.hasJsNamespace() || memberDescriptor.getOrigin().isSyntheticInstanceOfSupportMember()) continue;
            if (memberDescriptor.isField() && !LibraryInfoBuilder.mayTriggerClinit(memberDescriptor)) {
                if (!memberDescriptor.isCompileTimeConstant() || !LibraryInfoBuilder.isJsAccessible(memberDescriptor)) continue;
                hasConstantEntryPoint = true;
                continue;
            }
            MemberInfo.Builder builder = memberInfoBuilders.computeIfAbsent(LibraryInfoBuilder.getMemberId(memberDescriptor), m -> LibraryInfoBuilder.createMemberInfo(memberDescriptor, outputSourceInfoByMember));
            this.collectReferencedTypesAndMethodInvocations(member, builder);
        }
        if (type.isOptimizedEnum()) {
            for (Statement statement : type.getLoadTimeStatements()) {
                FieldDeclarationStatement fieldDeclarationStatement;
                if (!(statement instanceof FieldDeclarationStatement) || !(fieldDeclarationStatement = (FieldDeclarationStatement)statement).getFieldDescriptor().isEnumConstant()) continue;
                final String fieldId = LibraryInfoBuilder.getMemberId((MemberDescriptor)fieldDeclarationStatement.getFieldDescriptor());
                fieldDeclarationStatement.accept((Processor)new AbstractVisitor(){

                    public void exitMethodCall(MethodCall methodCall) {
                        if (LibraryInfoBuilder.isJsAccessible((MemberDescriptor)methodCall.getTarget())) {
                            return;
                        }
                        Preconditions.checkState((boolean)methodCall.getTarget().isStatic());
                        ((MemberInfo.Builder)memberInfoBuilders.get(fieldId)).addInvokedMethods(LibraryInfoBuilder.this.createMethodInvocation((MemberDescriptor)methodCall.getTarget()));
                    }
                });
            }
        }
        if (hasConstantEntryPoint) {
            memberInfoBuilders.put("$js_entry$", MemberInfo.newBuilder().setName("$js_entry$").setStatic(true).setJsAccessible(true));
        }
        this.libraryInfo.addTypes(typeInfoBuilder.addAllMembers((Iterable)memberInfoBuilders.values().stream().map(MemberInfo.Builder::build).collect(ImmutableList.toImmutableList())));
    }

    private static MemberInfo.Builder createMemberInfo(MemberDescriptor memberDescriptor, Map<MemberDescriptor, com.google.j2cl.common.SourcePosition> outputSourceInfoByMember) {
        MemberInfo.Builder memberInfoBuilder = MemberInfo.newBuilder().setName(LibraryInfoBuilder.getMemberId(memberDescriptor)).setStatic(memberDescriptor.isStatic()).setJsAccessible(LibraryInfoBuilder.isJsAccessible(memberDescriptor));
        com.google.j2cl.common.SourcePosition position = outputSourceInfoByMember.get(memberDescriptor);
        if (position != null) {
            memberInfoBuilder.setPosition(SourcePosition.newBuilder().setStart(position.getStartFilePosition().getLine()).setEnd(position.getEndFilePosition().getLine() + 1).build());
        }
        return memberInfoBuilder;
    }

    private void collectReferencedTypesAndMethodInvocations(final Member member, MemberInfo.Builder memberInfoBuilder) {
        final LinkedHashSet invokedMethods = new LinkedHashSet(memberInfoBuilder.getInvokedMethodsList());
        final LinkedHashSet explicitlyReferencedTypes = new LinkedHashSet(memberInfoBuilder.getReferencedTypesList());
        final HashSet typesReferencedViaStaticMemberReferences = new HashSet();
        member.accept((Processor)new AbstractVisitor(){

            public void exitJavaScriptConstructorReference(JavaScriptConstructorReference node) {
                DeclaredTypeDescriptor referencedType = node.getReferencedTypeDeclaration().toRawTypeDescriptor();
                if (!LibraryInfoBuilder.isPrunableType(referencedType)) {
                    return;
                }
                if (LibraryInfoBuilder.isJsAccessible(referencedType)) {
                    return;
                }
                if (member.getDescriptor().getEnclosingTypeDescriptor().isSubtypeOf(referencedType)) {
                    return;
                }
                explicitlyReferencedTypes.add(LibraryInfoBuilder.this.getTypeId(referencedType));
            }

            public void exitFieldAccess(FieldAccess node) {
                FieldDescriptor target = node.getTarget();
                if (!LibraryInfoBuilder.isPrunableType(target.getEnclosingTypeDescriptor())) {
                    return;
                }
                if (LibraryInfoBuilder.isJsAccessible((MemberDescriptor)target)) {
                    return;
                }
                if (!LibraryInfoBuilder.mayTriggerClinit((MemberDescriptor)target)) {
                    return;
                }
                this.addInvokedMethod((MemberDescriptor)target);
            }

            public void exitInvocation(Invocation node) {
                MethodDescriptor target = node.getTarget();
                if (!LibraryInfoBuilder.isPrunableType(target.getEnclosingTypeDescriptor())) {
                    return;
                }
                if (LibraryInfoBuilder.isJsAccessible((MemberDescriptor)target)) {
                    return;
                }
                if (target.getOrigin().isSyntheticInstanceOfSupportMember()) {
                    return;
                }
                if (target.getName().equals("$clinit") && !member.getDescriptor().getName().equals("$clinit")) {
                    return;
                }
                if (target.getName().equals("$loadModules")) {
                    return;
                }
                this.addInvokedMethod((MemberDescriptor)target);
            }

            private void addInvokedMethod(MemberDescriptor target) {
                invokedMethods.add(LibraryInfoBuilder.this.createMethodInvocation(target));
                if (!target.isInstanceMember()) {
                    typesReferencedViaStaticMemberReferences.add(LibraryInfoBuilder.this.getTypeId(target.getEnclosingTypeDescriptor()));
                }
            }
        });
        memberInfoBuilder.clearReferencedTypes().clearInvokedMethods().addAllInvokedMethods(invokedMethods).addAllReferencedTypes((Iterable)Sets.difference(explicitlyReferencedTypes, typesReferencedViaStaticMemberReferences));
    }

    private MethodInvocation createMethodInvocation(MemberDescriptor memberDescriptor) {
        return MethodInvocation.newBuilder().setMethod(LibraryInfoBuilder.getMemberId(memberDescriptor)).setEnclosingType(this.getTypeId(memberDescriptor.getEnclosingTypeDescriptor())).build();
    }

    private int getTypeId(DeclaredTypeDescriptor typeDescriptor) {
        return this.types.computeIfAbsent(typeDescriptor.getQualifiedJsName(), x -> this.types.size() + 1);
    }

    private LibraryInfo build() {
        this.libraryInfo.clearTypeNames();
        String[] typeMap = new String[this.types.size() + 1];
        typeMap[0] = "<no-type>";
        this.types.forEach((name, i) -> {
            typeMap[i.intValue()] = name;
        });
        this.libraryInfo.addAllTypeNames(Arrays.asList(typeMap));
        return this.libraryInfo.build();
    }

    @Nullable
    public String toJson(Problems problems) {
        try {
            return JsonFormat.printer().print((MessageOrBuilder)this.build());
        }
        catch (IOException e) {
            problems.fatal(Problems.FatalError.CANNOT_WRITE_FILE, new Object[]{e.toString()});
            return null;
        }
    }

    public byte[] toByteArray() {
        return this.build().toByteArray();
    }

    private static String getMemberId(MemberDescriptor memberDescriptor) {
        String mangledName = LibraryInfoBuilder.isPropertyAccessor(memberDescriptor) ? memberDescriptor.computePropertyMangledName() : memberDescriptor.getMangledName();
        return memberDescriptor.isInstanceMember() ? mangledName + "_$i" : mangledName;
    }

    private static boolean mayTriggerClinit(MemberDescriptor memberDescriptor) {
        return memberDescriptor.isStatic() && (!memberDescriptor.isCompileTimeConstant() || memberDescriptor.isEnumConstant());
    }

    private static boolean isPropertyAccessor(MemberDescriptor memberDescriptor) {
        if (!memberDescriptor.isMethod()) {
            return false;
        }
        MethodDescriptor methodDescriptor = (MethodDescriptor)memberDescriptor;
        return methodDescriptor.isPropertyGetter() || methodDescriptor.isPropertySetter();
    }

    private static boolean isPrunableType(DeclaredTypeDescriptor typeDescriptor) {
        return !typeDescriptor.isNative() && !typeDescriptor.isJsEnum();
    }

    private static boolean isJsAccessible(MemberDescriptor memberDescriptor) {
        return LibraryInfoBuilder.isInBootstrap(memberDescriptor.getEnclosingTypeDescriptor()) || memberDescriptor.canBeReferencedExternally();
    }

    private static boolean isJsAccessible(DeclaredTypeDescriptor typeDescriptor) {
        return LibraryInfoBuilder.isInBootstrap(typeDescriptor) || typeDescriptor.getDeclaredMemberDescriptors().stream().filter(Predicates.not(MemberDescriptor::isInstanceMember)).anyMatch(MemberDescriptor::isJsMember);
    }

    private static boolean isInBootstrap(DeclaredTypeDescriptor typeDescriptor) {
        return TypeDescriptors.isBootstrapNamespace((DeclaredTypeDescriptor)typeDescriptor) || LibraryInfoBuilder.isAccesssedFromJ2clBootstrapJsFiles(typeDescriptor);
    }

    private static boolean isAccesssedFromJ2clBootstrapJsFiles(DeclaredTypeDescriptor typeDescriptor) {
        return TYPES_ACCESSED_FROM_J2CL_BOOTSTRAP_JS.contains((Object)typeDescriptor.getQualifiedSourceName());
    }
}

