/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.backend.wasm;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.j2cl.transpiler.ast.AstUtils;
import com.google.j2cl.transpiler.ast.Method;
import com.google.j2cl.transpiler.ast.MethodDescriptor;
import com.google.j2cl.transpiler.ast.TypeDeclaration;
import com.google.j2cl.transpiler.ast.TypeDescriptor;
import com.google.j2cl.transpiler.ast.Variable;
import com.google.j2cl.transpiler.backend.closure.ClosureGenerationEnvironment;
import com.google.j2cl.transpiler.backend.wasm.$AutoValue_JsMethodImport;
import java.util.List;
import java.util.stream.Collectors;

@AutoValue
abstract class JsMethodImport {
    JsMethodImport() {
    }

    static String getJsImportName(MethodDescriptor methodDescriptor) {
        Object qualifiedJsName = methodDescriptor.getQualifiedJsName();
        if (methodDescriptor.isConstructor()) {
            qualifiedJsName = ((String)qualifiedJsName).replace("<init>", "constructor");
        } else if (methodDescriptor.isPropertyGetter()) {
            qualifiedJsName = "get " + (String)qualifiedJsName;
        } else if (methodDescriptor.isPropertySetter()) {
            qualifiedJsName = "set " + (String)qualifiedJsName;
        }
        return qualifiedJsName;
    }

    static String computeSignature(MethodDescriptor methodDescriptor, ClosureGenerationEnvironment closureEnvironment) {
        return methodDescriptor.getParameterTypeDescriptors().stream().map(TypeDescriptor::toNonNullable).map(arg_0 -> ((ClosureGenerationEnvironment)closureEnvironment).getClosureTypeString(arg_0)).collect(Collectors.joining(","));
    }

    abstract String getBaseImportKey();

    abstract String getSignature();

    public abstract Method getMethod();

    public String getImportKey() {
        int importNumber = this.emitAsMethodReference() || this.isPropertyGetter() || this.isPropertySetter() ? 0 : this.getParameters().size();
        return importNumber == 0 ? this.getBaseImportKey() : this.getBaseImportKey() + "$" + importNumber;
    }

    public String getJsQualifier() {
        MethodDescriptor methodDescriptor = this.getMethod().getDescriptor();
        if (methodDescriptor.isExtern()) {
            ImmutableList<String> jsNameParts = JsMethodImport.splitQualifiedName(methodDescriptor.getQualifiedJsName());
            return (String)jsNameParts.get(0);
        }
        if (methodDescriptor.hasJsNamespace()) {
            return JsMethodImport.computeJsAlias(methodDescriptor.getJsNamespace());
        }
        return JsMethodImport.getJsTypeName(methodDescriptor.getEnclosingTypeDescriptor().getTypeDeclaration());
    }

    public String getJsName() {
        MethodDescriptor methodDescriptor = this.getMethod().getDescriptor();
        if (methodDescriptor.isExtern()) {
            ImmutableList<String> jsNameParts = JsMethodImport.splitQualifiedName(methodDescriptor.getQualifiedJsName());
            return (String)jsNameParts.get(1);
        }
        return methodDescriptor.getSimpleJsName();
    }

    private static ImmutableList<String> splitQualifiedName(String value) {
        int lastDot = value.lastIndexOf(46);
        return lastDot == -1 ? ImmutableList.of((Object)"", (Object)value) : ImmutableList.of((Object)value.substring(0, lastDot), (Object)value.substring(lastDot + 1));
    }

    public boolean isConstructor() {
        return this.getMethod().getDescriptor().isConstructor();
    }

    public boolean isInstance() {
        return this.getMethod().getDescriptor().isInstanceMember();
    }

    public boolean isPropertyGetter() {
        return this.getMethod().getDescriptor().isPropertyGetter();
    }

    public boolean isPropertySetter() {
        return this.getMethod().getDescriptor().isPropertySetter();
    }

    public List<Variable> getParameters() {
        return this.getMethod().getParameters();
    }

    public boolean emitAsMethodReference() {
        return !this.isInstance() && !this.isConstructor() && !this.isPropertyGetter() && !this.isPropertySetter() && !this.getJsName().equals("call") && !this.getBaseImportKey().equals("performance.now");
    }

    static boolean isCompatible(JsMethodImport existing, JsMethodImport other) {
        return existing.isConstructor() == other.isConstructor() && existing.isInstance() == other.isInstance() && existing.isPropertyGetter() == other.isPropertyGetter() && existing.isPropertySetter() == other.isPropertySetter();
    }

    static String getJsTypeName(TypeDeclaration typeDeclaration) {
        return AstUtils.buildQualifiedName((String[])new String[]{JsMethodImport.computeJsAlias(typeDeclaration.getEnclosingModule()), typeDeclaration.getInnerTypeQualifier()});
    }

    private static String computeJsAlias(TypeDeclaration typeDeclaration) {
        if (typeDeclaration.isExtern()) {
            return typeDeclaration.getQualifiedJsName();
        }
        return JsMethodImport.computeJsAlias(typeDeclaration.getQualifiedJsName());
    }

    static String computeJsAlias(String name) {
        return name.replace('.', '_');
    }

    public static Builder newBuilder() {
        return new $AutoValue_JsMethodImport.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setBaseImportKey(String var1);

        public abstract Builder setSignature(String var1);

        public abstract Builder setMethod(Method var1);

        public abstract JsMethodImport build();
    }
}

